/* implements gnometoasters audio API.
 * it generally takes 16bit,BigEndian,Stereo,44.1khz as its stream format
 * the drivers themselves (/dev/dsp,esd,...) are defined in separate files
 * and merely registered through the functions of this api */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include "int.h"

#include "audio.h"
#include "varman.h"
#include "preferences.h"
#include "varmanwidgets.h"

#include "defaultentries.h"

/* the driver database */
audio_ddb_type audio_ddb;

int audio_dummy_open(gpointer driver)
{
   return -1;
};

void audio_dummy_close(gpointer driver)
{
};


/* init the audio driver system */
void audio_init()
{
   GtkWidget *prefs;
   GtkWidget *label;
   
   audio_ddb.drivers=0;
   audio_ddb.drivernames=NULL;
   
   /* we want to let the user decide which driver and with which parameters
    * to use,right ? */
   prefs=gtk_vbox_new(0,0);
   gtk_widget_show(prefs);
   label=gtk_label_new(_("Audio System"));
   gtk_widget_show(label);
   gtk_notebook_append_page(GTK_NOTEBOOK(preferences_editpad),
			    prefs,
			    label);
   
   audio_ddb.currentdriver=varmanwidgets_combo_new(_("Audio driver"),
						   "audio_default",
						   global_defs,
						   APPLYMODE_BUTTON,
						   160,						    
						   audio_ddb.drivernames);
   gtk_box_pack_start(GTK_BOX(prefs),audio_ddb.currentdriver->visual,0,0,0);
   gtk_widget_show(audio_ddb.currentdriver->visual);
   
   /* install dummy driver */
   audio_driver_register(audio_driver_create(DEFAULTENTRIES_AUDIO_DEFAULT_NOSOUND,
					     audio_dummy_open,
					     audio_dummy_close,
					     NULL));
   
};

audio_driver *audio_driver_create(char *name,
				  int (*open)(gpointer data),
				  void (*close)(gpointer data),
				  gpointer data)
{
   audio_driver *driver;
   
   driver=(audio_driver*)malloc(sizeof(audio_driver));
   
   strcpy((char*)&driver->name,name);
   driver->open=open;
   driver->close=close;
   driver->data=data;
   driver->descriptor=-1;
   
   return driver;
};

/* register an audio driver */
int audio_driver_register(audio_driver*driver)
{
   audio_ddb.driver[audio_ddb.drivers]=driver;
   audio_ddb.drivers++;
   
   audio_ddb.drivernames=g_list_append(audio_ddb.drivernames,driver->name);
   varmanwidgets_combo_setpops(audio_ddb.currentdriver,
			       audio_ddb.drivernames);
   varmanwidgets_combo_undo(NULL,audio_ddb.currentdriver);
   
   /* return driver id */
   return (audio_ddb.drivers-1);
};

int audio_getdriverid_by_name(char *name)
{
   int i;
   int result=0;
   /* use dummy if no driver with the given name could be found */
   for (i=0;i<audio_ddb.drivers;i++)
     {
	if (!strcmp((char*)&audio_ddb.driver[i]->name,name))
	  result=i;
     };
   return result;
};

