/* some functions to do lowlevel access to cdrom drives */

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <signal.h>
#include <linux/cdrom.h>
#include <unistd.h>

#include "piping.h"
#include "cdromlow.h"
#include "preferences.h"
#include "varman.h"
#include "helpings.h"

/* uncomment for debugging */
/* #define DEBUG */

/* reimplemented using direct cdrom access:
 * does the current cd have one or more data tracks ? */
int cdromlow_hasdatatrack(char *device)
{
	int cdrom;
	struct cdrom_tochdr header;
	struct cdrom_tocentry entry;
	int x;
	int hasdatatrack=0;	
	
	cdrom=open(device,O_RDONLY|O_NONBLOCK);
	if (cdrom!=-1)
	  {		  
		  ioctl(cdrom,CDROMREADTOCHDR,&header);	
		  for (x=header.cdth_trk0;x<=header.cdth_trk1;x++)
		    {		  
			    entry.cdte_track=x;
			    entry.cdte_format=CDROM_LBA;
			    ioctl(cdrom,CDROMREADTOCENTRY,&entry);
			    if (entry.cdte_ctrl&CDROM_DATA_TRACK)
				hasdatatrack=1;
		    }
		  ;
		  close(cdrom);
	  }
	;
	return hasdatatrack;
}
;

/* return number of tracks on cd,reimplemented using ioctl()s */
int cdromlow_tracks(char *device)
{
	int cdrom;
	struct cdrom_tochdr header;
	int tracknum;
	
	tracknum=0;
	cdrom=open(device,O_RDONLY|O_NONBLOCK);
	if (cdrom!=-1)
	  {		  
		  if (ioctl(cdrom,CDROMREADTOCHDR,&header)!=-1)
		      tracknum=1+header.cdth_trk1-header.cdth_trk0;	
		  else
		      tracknum=0;
		  close(cdrom);
	  }
	;
	return (tracknum);	
}
;

/* return tracksize of track num in sectors (LBA) */
int cdromlow_tracksize_sectors(char *device,int num)
{
	int cdrom;
	struct cdrom_tocentry track,tracknext;
	int tracksize;

	tracksize=0;
	cdrom=open(device,O_RDONLY|O_NONBLOCK);
	if (cdrom!=-1)
	  {		         
		  track.cdte_track=num;
		  track.cdte_format=CDROM_LBA;
		  ioctl(cdrom,CDROMREADTOCENTRY,&track);
		  
		  if (num==cdromlow_tracks(device))
		      tracknext.cdte_track=CDROM_LEADOUT;
		  else
		      tracknext.cdte_track=num+1;
		  tracknext.cdte_format=CDROM_LBA;
		  ioctl(cdrom,CDROMREADTOCENTRY,&tracknext);
		
		  close(cdrom);
		  tracksize=(tracknext.cdte_addr.lba-track.cdte_addr.lba);
	  }
	;	
	return tracksize;
}
;

/* return tracksize for audiotrack n in bytes,reimplemented using ioctl()s */
int cdromlow_tracksize(char *device,int num)
{	
	return cdromlow_tracksize_sectors(device,num)*CD_FRAMESIZE_RAW;
}
;

/* return tracksize of datatrack in bytes,reimplemented using ioctl()s */
int cdromlow_datatracksize(char *device)
{
	return cdromlow_tracksize_sectors(device,1)*CD_FRAMESIZE;
}
;
	
/* return cddb number of cdrom */
int cdromlow_cddbnumber(char *device)
{
	int cdrom;
	struct cdrom_tochdr header;
	struct cdrom_tocentry entry;
	int x,secs;	
	int cddbnum=0;
        int info=0;

	cddbnum=0;
	cdrom=open(device,O_RDONLY|O_NONBLOCK);
	if (cdrom!=-1)
	  {
	     /* check cdrom status before building cddb code */
	     ioctl(cdrom,CDROM_DRIVE_STATUS,&info);
	     if ((info==CDS_DISC_OK)||(info==CDS_NO_INFO))
	       if (ioctl(cdrom,CDROMREADTOCHDR,&header)!=-1)
		 {		  	
		    entry.cdte_track=CDROM_LEADOUT;
		    entry.cdte_format=CDROM_LBA;
		    ioctl(cdrom,CDROMREADTOCENTRY,&entry);
		    secs=(entry.cdte_addr.lba/75);
		    
		    for (x=header.cdth_trk0;x<=header.cdth_trk1;x++)
		      {		  
			 entry.cdte_track=x;
			 entry.cdte_format=CDROM_LBA;
			 ioctl(cdrom,CDROMREADTOCENTRY,&entry);
			 cddbnum+=helpings_dsum((entry.cdte_addr.lba/75)+2);
			 if (x==header.cdth_trk0) secs-=(entry.cdte_addr.lba/75);
		      }
		    ;
		    
		    cddbnum<<=24;
		    cddbnum|=(secs<<8);
		    cddbnum|=(1+header.cdth_trk1-header.cdth_trk0);
		 }
	     ;
	     close(cdrom);
	  }
	;
	return cddbnum;
}
;
