/* Gnometoaster's dialog routines,wrapping around gnome's dialog-util 
 * and displaying a gtkdialog box in the gtk version */

#ifndef DIALOG_H
#define DIALOG_H

#include "config.h"

#define DIALOG_YES 0
#define DIALOG_NO  1

#ifdef HAVE_GNOME
#include <gnome.h>

#define dialog_replycallback GnomeReplyCallback

#define dialog_ok(messagetext) gnome_ok_dialog(messagetext)
#define dialog_error(messagetext) gnome_error_dialog(messagetext)
#define dialog_warning(messagetext) gnome_warning_dialog(messagetext)
#define dialog_question(messagetext,callback,data) gnome_question_dialog(messagetext,callback,data)

#else
#include <gtk/gtk.h>

typedef void (*dialog_replycallback)(gint reply,gpointer data);

GtkWidget *dialog_ok(const gchar *msg);
#define dialog_error dialog_ok
#define dialog_warning dialog_ok
GtkWidget *dialog_question(const gchar *msg,			
			   dialog_replycallback callback,
			   gpointer data);
#endif

#endif // DIALOG_H
