/* cache Directory entries for faster access */

#include "dirlow.h"
#include "preferences.h"

#ifndef DIRCACHE_H
#define DIRCACHE_H

#define DIRCACHE_UNKNOWN -3
#define DIRCACHE_COUNT_UNKNOWN -2
#define DIRCACHE_NODIR -1

#define DIRCACHE_MAXDIRS 5000

typedef struct
{
	char name[MAXPATHLENGTH+1]; // name including full pathname
	int  subdirs;   // subdir count : -1 if file is no directory,-2 if subdir count is unknown
	unsigned int  timestamp;  // size of the file,when filesize has changed rescan for subdirs
} dircache_cacheentry;

extern dircache_cacheentry *dircache_entry[DIRCACHE_MAXDIRS];
extern int dircache_entries;

dircache_cacheentry *dircache_getentry(char *);
dircache_cacheentry *dircache_createentry(char*);
void dircache_savecache(char*);
void dircache_loadcache(char*);
int  dircache_isdir(char*);
int  dircache_subdirentries(char*);
int  dircache_isdirin(char*,char*);
#define dircache_filesize(Filename) dirlow_filesize(Filename)
unsigned int  dircache_filesizein(char*,char*);

#endif // DIRCACHE_H
