/* get the directory tree */

#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>

#include "preferences.h"
#include "dircache.h"

/* uncomment for debugging */
/* #define DEBUG */

int dirlow_isdir(char *d)
{
	struct stat buf;
	int id;
	
	stat(d,&buf);
	
	id=S_ISDIR(buf.st_mode);

	return id;
}
;

int dirlow_islink(char *d)
{
	struct stat buf;
	int il;
	
	lstat(d,&buf);
	
	il=S_ISLNK(buf.st_mode);
	
	return il;
}
;

dirlow_uniqueinodeid *dirlow_uniqueinodeid_get(char *d)
{
	struct stat buf;
	dirlow_uniqueinodeid *id;

	id=(dirlow_uniqueinodeid*)malloc(sizeof(dirlow_uniqueinodeid));
	lstat(d,&buf);
	
	id->st_dev=buf.st_dev;
	id->st_ino=buf.st_ino;
	
	return id;
}
;
	
int dirlow_uniqueinodeid_same(dirlow_uniqueinodeid*first,
			      dirlow_uniqueinodeid*second)
{
	int equal=0;	
	if ((first->st_dev==second->st_dev)&&
	    (first->st_ino==second->st_ino))
	    equal=1;
	return equal;
}
;

unsigned int dirlow_filesize(char *d)
{
	struct stat buf;
	unsigned int fs;
	
	stat(d,&buf);
	
	fs=buf.st_size;
	
	return fs;
}
;

int dirlow_subdirentries(char *d)
{
	DIR *dir;
	struct dirent *entry;
	int entries;
	
	char subdirname[MAXPATHLENGTH];
	
	dir=opendir(d);
	entries=0;
	if (dir!=NULL)
	  {
		  while (((entry=readdir(dir))!=NULL)&&(entries==0))
		    {
			    strcpy((char*)&subdirname,d);
			    if (d[strlen(d)-1]!="/"[0])
				strcat((char*)&subdirname,"/");
			    strcat((char*)&subdirname,(char*)&entry->d_name);
			    if ( strcmp((char*)&entry->d_name,".")  &&
			         strcmp((char*)&entry->d_name,"..") &&
				 dirlow_isdir((char*)&subdirname)
				)
				entries++;
		    }
		  ;
		  closedir(dir);
	  }
	;
	return entries;
}
;
	

unsigned int dirlow_timestamp(char *d)
{
	struct stat buf;
	if (stat(d,&buf)==-1) buf.st_mtime=-1;
	return buf.st_mtime;
}
;

	    
/* set contentonly to TRUE if directory itself shouldn't be removed */
int dirlow_removedir(char *d,int contentonly)
{	
   DIR *dir;
   struct dirent *entry;
	
   char fullent[4096];

   if (dirlow_islink(d))
     {
	printf ("dirlow_removedir: Warning! The directoy %s \n",d);
	printf ("                  is a symbolic link.\n");
	/* only delete symlink if contentonly is false */
	return (!contentonly)?(remove(d)==0):1;
     }
   ;
   
   dir=opendir(d);
   if (dir!=NULL)
     {
	while ((entry=readdir(dir))!=NULL)
	  {
	     if (strcmp((char*)&entry->d_name,".")&&
		 strcmp((char*)&entry->d_name,".."))
	       {				      
		  strcpy((char*)&fullent,d);
		  if (d[strlen(d)-1]!="/"[0])
		    strcat((char*)&fullent,"/");
		  /* check wether theres a path length overflow */
		  if ((strlen((char*)&fullent)+strlen((char*)&entry->d_name))>MAXPATHLENGTH)
		    {
		       printf ("directory recursion error.\n This means,that the filetree you attempted to remove contains too many recursive directories.\n");
		       printf ("Please try removing %s with using the \"rm -rf\" command.\n",
			       (char*)&fullent);
		       printf ("Another option would be setting MAXPATHLENGTH to a higher value\n");
		       printf ("in preferences.h and recompile Gnometoaster.\n");
		    }
		  else
		    {	
		       strcat((char*)&fullent,(char*)&entry->d_name);
#ifdef DEBUG
		       printf ("deleting %s ...\n",
			       (char*)&fullent);
		       printf ("Path string length: %i\n",
			       strlen((char*)&fullent));
#endif
		       if (dircache_isdir((char*)&fullent))
			 {
#ifdef DEBUG
			    printf ("deleting directory recursively...\n");
#endif
			    dirlow_removedir((char*)&fullent,0);
			 }
		       else
			 remove((char*)&fullent);
		    }
		  ;
	       }
			    ;
	  }
	;
	closedir(dir);
     }
   ;
   /* delete directory only if contentonly is false */
   return (!contentonly)?(rmdir(d)==0):1;
}
;

int dirlow_mkdirin(char *p,char *d)
{
	char *buf;
	int success;
	
	buf=(char*)malloc(MAXPATHLENGTH);
	strcpy(buf,p);
	if (p[strlen(p)-1]!="/"[0])
	    strcat(buf,"/");
	strcat(buf,d);
	success=(mkdir(buf,0777)==0);
	free(buf);
	return success;
}
;
