/* Some functions to handle lists of files as given back on drag and drop
 * events or popup events (delete,rename,etc) */

#ifndef FILEMAN_H
#define FILEMAN_H

#include <glib.h>

/* callback functions to make fileman functions generic */
typedef int (*fileman_mkdircall)(char *dirname,char *path,gpointer data);
typedef int (*fileman_addfilecall)(char *filename,char *path,gpointer data);

/* default calls used by compatibility macros */
int fileman_defaultmkdir(char *dirname,char *path,gpointer data);
int fileman_defaultaddfile(char *filename,char *path,gpointer data);

/* the following function can be used to parse a selection as given back
 * by drag and drop and call filehandle(char*) for each separate file */
int fileman_selectionhandler(char *s,char *p,int (*filehandle)(char *s,char *p));

/* get filename without path. char *d has to be allocated.
 * if resulting filename is "",it will be replaced by "root" */
void fileman_strippath(char *filename,char *stripped);

/* remove the specified single file item. If this is a directory,it will
 * be removed recursively. Parameter char *p is unused and set to NULL */
int fileman_remove_item(char *s,char *p);

/* remove a whole batch of files using the function above */
int fileman_remove_items(char *s);

/* add a file using the specified callback functions */
int fileman_addnormalfile_generic(char *f,
				  char *p,
				  fileman_mkdircall,
				  fileman_addfilecall,
				  gpointer data);
/* add a single normal file to the path specified by char *p.
 * this is done by creating a symbolic link to the source file in
 * the destination directory */
#define fileman_addnormalfile(file,path) \
   fileman_addnormalfile_generic(file,path, \
				 fileman_defaultmkdir, \
				 fileman_defaultaddfile, \
				 NULL)


/* add a directory with subdirs using the specified callback functions 
 * if contentof is TRUE,only the content of the directory,not the directory
 * itself is added to the destination */
int fileman_adddirectory_generic(char *sd,
				 char *p,
				 GList **linkcount,
				 int contentof,
				 fileman_mkdircall,
				 fileman_addfilecall,
				 gpointer data
				 );

/* add a single directory to the path specified by char *p
 * all the items of this directory will be added depending on wether theyre
 * directories themselves,in which case adddirectory will simply be called
 * recursively,or wether theyre just normal files,which will then be added
 * using addnormalfile() 
 * linkcount should be a pointer to a GList pointer initialized with NULL */
#define fileman_adddirectory(sd,p,linkcount) \
   fileman_adddirectory_generic(sd, \
				p, \
				linkcount, \
				0, \
				fileman_defaultmkdir, \
				fileman_defaultaddfile, \
				NULL )

/* add either dir or file using specified cb functions */
int fileman_addfile_generic(char*f,char*p,
			    fileman_mkdircall,
			    fileman_addfilecall,
			    gpointer data
			    );

/* add a single generic file item to the patch specified by char *p 
 * this can be either a normal file or a directory */
#define fileman_addfile(file,path) \
   fileman_addfile_generic( file,path, \
			    fileman_defaultmkdir, \
			    fileman_defaultaddfile, \
			    NULL )

/* will be used to copy the contents of a trackstream into a file
 * within the specified path with the name of the stream as filename
 * This function is currently not implemented and will generate a 
 * dummy message only describing the stream it has been called with */
int fileman_addstream(char*s,char *p);

/* add an item to the specified path. item can be one of stream,directory,
 * normal file */
int fileman_add_item(char *s,char *p);

/* add a selection of items to the specified path. items can be
 * stream,directory,normal file */
int fileman_add_items(char *s,char *p);

/* add a directory to a specified path,ask the user for a name
 * call "finished" when done. */
void fileman_mkdir_dialog(char *path,
			  void (*finished)(gpointer),
			  gpointer data);

/* returns TRUE if specified file exists */
int fileman_file_exist(char *filename);   

#endif // FILEMAN_H
