
/* get the directory tree */

#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>

#include "main.h"
#include "getdir.h"
#include "dircache.h" // finally,some step towards "highspeed"
#include "dndsetup.h"
#include "menusys.h"

void getdir_drag(GtkWidget *w,
		 GdkDragContext *ct,
		 GtkSelectionData *data,
		 guint inf,
		 guint time,
		 getdir_dirinfo *info)
{
	
	strcpy((gchar*)&info->receiverstring,"file:");
	strcat((gchar*)&info->receiverstring,(gchar*)&info->dirname);
	strcat((gchar*)&info->receiverstring,CRLF);
	gtk_selection_data_set (data,
				data->target,
				8,(gchar*)&info->receiverstring,
				strlen((gchar*)&info->receiverstring));
}
;

void getdir_drop(GtkWidget *w,
		 GdkDragContext *c,
		 gint x,
		 gint y,
		 GtkSelectionData *data,
		 guint inf,
		 guint time,
		 getdir_dirinfo *info)
{
	if ((data->length>=0) && (data->format == 8)
	    && (info->receiver!=NULL))
	  {
		  info->recdata=(gchar*)data->data;
		  info->receiver(w,info);
		  gtk_drag_finish(c,TRUE,FALSE,time);
		  return;
	  }
	;
	gtk_drag_finish (c,FALSE,FALSE,time);
}
;

void getdir_cb_collapse(GtkWidget *item,getdir_dirinfo *info);
void getdir_cb_expand(GtkWidget *item,getdir_dirinfo *info) // this is the internal callback for reloading directory contents
{
        /* only remove if present - may not be present if chdir is executed
	 * from the filelist by double clicking on a directory within a 
	 * newly mounted partition */
 	if (GTK_TREE_ITEM_SUBTREE(GTK_TREE_ITEM(item))!=NULL)
		gtk_tree_item_remove_subtree(GTK_TREE_ITEM(item));
	if ((dircache_subdirentries((char*)&info->dirname))||(info->parent==NULL))
	  {
		  /* check this existance of subdir entries once more to fix a drawing error */
		  /* do not remove expand sign if parent tree item */
		  gtk_signal_disconnect_by_func(GTK_OBJECT(item),
						GTK_SIGNAL_FUNC(getdir_cb_expand),
						info);
		  getdir_tree(GTK_TREE_ITEM(item),
			      info);		
		  gtk_signal_connect(GTK_OBJECT(item),"collapse",
				     GTK_SIGNAL_FUNC(getdir_cb_collapse),info);
		  gtk_tree_item_expand(GTK_TREE_ITEM(item));
	  }
	;
}
; // do only call this the first time a directory is expanded,afterwards disable signal handler
  // this call would end up in some infinite recursion otherwise


void getdir_cb_collapse(GtkWidget *item,getdir_dirinfo *info) // remove directory from memory once its leaf has been closed
{
	GList *selection;

	selection=GTK_TREE_SELECTION(GTK_TREE_ITEM_SUBTREE(GTK_ITEM(item)));
	if ((selection==NULL) || (selection->data!=item))
	    gtk_tree_select_child(GTK_TREE_ROOT_TREE
				  (GTK_TREE_ITEM_SUBTREE
				   (GTK_ITEM(item)))
				  ,item);
	gtk_signal_connect(GTK_OBJECT(item),"expand",    // reconnect reading routine
			   GTK_SIGNAL_FUNC(getdir_cb_expand),info);
	gtk_signal_disconnect_by_func(GTK_OBJECT(item),
				      GTK_SIGNAL_FUNC(getdir_cb_collapse),
				      info);
	gtk_tree_item_remove_subtree(GTK_TREE_ITEM(item));
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(item),
				  gtk_tree_new());            // add dummy tree instead of the real directory

/* FIXME: do remove the getdir_expanddirinfo structs connected to the 
 * Items of the collapsing subtree,no plan how to do this though */

}
;

/* select item with name "name" from "tree",which is expanded automatically
 * if this shouldnt be already the case. 
 *  name: item name
 *  tree: GtkTreeItem,as the tree has to be expandable on demand */
void getdir_selectsubdir(GtkWidget *tree,
			 char *name)
{
	GtkTree *subtree;
	GList *current;
	GtkTreeItem *found;
	GtkLabel *label;
	char *labeltext;

	/* the item has to take care of expand event count for itself
	 * anyway,so why should we care about that here then ? ;-) */
	gtk_tree_item_expand(GTK_TREE_ITEM(tree));
	subtree=GTK_TREE(GTK_TREE_ITEM_SUBTREE(tree));
	current=subtree->children;
	found=NULL;
	while ((current!=NULL)&&(found==NULL))
	  {		  
		  label=GTK_LABEL(gtk_container_children(GTK_CONTAINER(current->data))->data);
		  gtk_label_get(label,&labeltext);
		  if (!strcmp(name,labeltext))
		      found=GTK_TREE_ITEM(current->data);
		  
		  current=current->next;
	  };
	if (found!=NULL)
	    gtk_tree_select_child(GTK_TREE_ROOT_TREE(GTK_TREE_ITEM_SUBTREE(tree)),
				  GTK_WIDGET(found));
}
;
		

getdir_dirinfo *getdir_dirinfo_create(char *path,
				      GtkSignalFunc select,
				      GtkSignalFunc unselect,
				      void *data,
				      int allowdrag,				      
				      void (*receiver)(GtkWidget *,void*),
				      menusys_menu *popup)
{
	getdir_dirinfo *di;
	di=(getdir_dirinfo*)malloc(sizeof(getdir_dirinfo));
	strcpy((char*)&di->dirname,path);
	di->select=select;
	di->unselect=unselect;
	di->data=data;
	di->allowdrag=allowdrag;
	di->receiver=receiver;
	di->popup=popup;
	return di;
}
;

void getdir_connectstdsignals(GtkWidget *item,
			      GtkWidget *parent,
			      getdir_dirinfo *info)
{	
	info->referringto=item;
	info->parent=parent;
	gtk_signal_connect(GTK_OBJECT(item),"expand",
			   GTK_SIGNAL_FUNC(getdir_cb_expand),info);
	gtk_signal_connect(GTK_OBJECT(item),"select",
			   info->select,info);
	gtk_signal_connect(GTK_OBJECT(item),"deselect",
			   info->unselect,info);
	
	if (info->allowdrag)
	  {		  
		  dndsetup_drag(item,
				GTK_SIGNAL_FUNC(getdir_drag),
				NULL,
				info);
	  }
	;
	
	if (info->receiver!=NULL)
	  {
		  /* do no more use dndsetup here, just connect the signal
		   * handler but do not setup the item as drop destination.
		   * all drop events to a tree are currently by 
		   * droptreepatch.c,which then redistributes those
		   * events to their receivers */
		  gtk_signal_connect (GTK_OBJECT(item),
				      "drag_data_received",
				      GTK_SIGNAL_FUNC(getdir_drop),
				      info);
	  }
	;
	
	if (info->popup!=NULL)
	    menusys_attachpopupmenu(item,info->popup,(gpointer)info);
}
;
	

/* GtkTreeItem *host is new: it is necessary to make drag and drop support
 * work,as when drag and drop is enabled a Tree Item has to be connected
 * all the way down to the root tree,which has to be attached to some visible
 * widget already. To maintain getdir_trees full functionality,you are
 * allowed to pass a NULL pointer instead of the GtkTreeItem,if the tree
 * you intend to create is a root tree. otherwise getdir_tree will
 * automatically attach the created tree to the passed GtkTreeItem. */
GtkWidget *getdir_tree(GtkTreeItem *host,getdir_dirinfo *di)
{
	GtkWidget *dirtree;
	DIR *dir;
	GtkWidget *entrytree;
	struct dirent *entry;
	char newdir[256];
	getdir_dirinfo *getdir_expanddirinfo;
			
	dirtree=gtk_tree_new();
	if (host!=NULL)
	  {		  
		  gtk_tree_item_set_subtree(host,dirtree);
		  gtk_widget_show(dirtree);
	  }
	;
	
	gtk_tree_append(GTK_TREE(dirtree),
			gtk_tree_item_new_with_label("Test"));
	/* this line seems to solve a major problem ;-)
	 * the thing is that I do not know why yet ....
	 * This time it really looks like some bug in the GtkTree Widget
	 * see Changelog for Details on that...
	 * and btw: it is intended that the widget added here is never
	 * actually shown within the tree,as it is not even intended to
	 * exist at all */
	
	dir=opendir((gchar*)&di->dirname);
	if (dir!=NULL)
	  {		  
		  while ((entry=readdir(dir))!=NULL)
		    {
			    if ( (strcmp((char*)&entry->d_name,".")) &&
				(strcmp((char*)&entry->d_name,"..")) )
			      {
				      strcpy((char*)&newdir,(gchar*)&di->dirname);
				      if (di->dirname[strlen((gchar*)&di->dirname)-1]!="/"[0])
					  strcat((char*)&newdir,"/");
				      strcat((char*)&newdir,(char*)&entry->d_name);
				      if (dircache_isdir((char*)&newdir)) {
					      entrytree=gtk_tree_item_new_with_label((char*)&entry->d_name);
					      gtk_tree_append(GTK_TREE(dirtree),entrytree);
					      if (dircache_subdirentries((char*)&newdir)>0)
						{
							gtk_tree_item_set_subtree(GTK_TREE_ITEM(entrytree),
										  gtk_tree_new());
						}       // do add a dummy tree only - real directory is read within expand callback
					      ;
					      gtk_widget_show(entrytree);
					      getdir_expanddirinfo=
						  getdir_dirinfo_create((char*)&newdir,
									di->select,
									di->unselect,
									di->data,
									di->allowdrag,
									di->receiver,
									di->popup);					      
					      getdir_connectstdsignals(entrytree,
								       GTK_WIDGET(host),
								       getdir_expanddirinfo);
				      }
				      ;
			      }
			    ;
		    }
		  ;
		  closedir(dir);
	  }
	;
	return dirtree;
}
;
		  
