/* contains some litte helper functions used by parts of Gnometoaster */

#include "int.h"
#include "preferences.h"

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>

/* uncomment for debugging */
/* #define DEBUG */

/* store string results here */
char buffer[MAXSTRINGSIZE];

/* build sum of all a numbers digits */
int helpings_dsum(int val)
{
	int d=0;
	
	for (;val>0;val/=10)
	  {
		 d+=val%10;
	  }
	;
	return d;	
}
;
	
/* build Glist from a list of strings terminated with NULL
 * this is useful mainly to create a Glist out of a list of constants
 * e.g. to create a combo box with it */
GList *helpings_buildglist(char *stringlist[])
{
	int x;
	GList *list=NULL;
	
	x=0;
	for (x=0;stringlist[x]!=NULL;x++)
	  {
		  list=g_list_append(list,stringlist[x]);
	  }
	;
	
	return list;
}
;

/* return a pointer to the n-th line of a string containing a complex
 * output with CRs and LFs - return NULL if line is not present */
char *helpings_getlinestart(char *s,int n)
{
	char *linestart;
	char *x;
	int cl;
	
	cl=1;linestart=s;x=linestart;
	while ((cl<n)&&((x-s)<strlen(s)))
	  {
		  x=linestart;
		  while ((*x!=13)&&(*x!=10)) x++;
		  if ((*x==13)||(*x==10)) x++; /* allow one more CR */		  
		  linestart=x;
		  cl++;
	  }
	;
	if (cl!=n) linestart=NULL;
	
	return linestart;
}
;

/* get line no. n - returns "" if not found */
char *helpings_getlineno(char *s,int n)
{
	char *beginline;
	char *endline;
	char *newstring;
	
	newstring=(char*)malloc(strlen(s)+1);
	beginline=helpings_getlinestart(s,n);
	if (beginline!=NULL)
	  {		  	
		  strcpy(newstring,beginline);
		  
		  endline=newstring;
		  while ((*endline!=13)&&(*endline!=10))
		      endline++;
		  *endline=0;
	  }
	else
	  {
		  strcpy(newstring,"");
	  }
	;
	return newstring;
}
;

/* get the n-th value occurring in a string */
float helpings_getvalueinstring(char *s,int n)
{
	int cv;
	char *x;
	char *nmbstart;
	float num;
	
	cv=0;x=s;nmbstart=x;
	while ((cv<n)&&((x-s)<strlen(s)))
	  {
		  while ((*x<'0')||(*x>'9')) x++;
		  nmbstart=x;
		  while ((*x>='0')&&(*x<='9')) x++;
		  cv++;
	  }
	;
#ifdef DEBUG	
	printf("getting number from %s\n",nmbstart);
#endif
	if (cv==n) /* if number was found */
	    sscanf(nmbstart,"%f",&num);
	else
	    return num=-1;
	
	return num;
}
;


void helpings_formatnumber(char *buf,int bufsize,long long unsigned int number)
/* Fills the Buffer with an ascii representation of the number.
 * every 3 digits will be seperated by a '.'  */
{ 
	int n=1,d=0;
	buf[bufsize-1]=0;/* 0-terminated */
	do
	  {
		  ++d;
		  if ((d%3==1)&&(d!=1)) 
		      buf[bufsize-(++n)]='.';
		  buf[bufsize-(++n)]='0'+number%10; 
		  number/=10;
	  }
	while ((number>0)&&(n<bufsize));

	for(d=0;d<n;d++)
	  {
		  buf[d]=buf[bufsize-n+d];
	  };
};
	
/* convert a given number of seconds into an ascii representation 
 * of a "clock counter" */
char *helpings_secs2hms(int secs,int verbose)
{
   char *result;
   result=(char*)&buffer;
   if (verbose)
     sprintf(result,_("%02i hour(s) %02i min. %02i sec."),
	     secs/3600,
	     (secs%3600)/60,
	     secs%60
	     );
   else                   
     sprintf(result,"%02i:%02i:%02i",
	     secs/3600,
	     (secs%3600)/60,
	     secs%60
	     );
   return result;
};

/* compare a word to a list of words separated by "sep" and return true if
 * it was found */
int helpings_listcomp(char *list,char *word,char *sep)
{
   char *wc,*current;
   char *key;
   int match=0;   
   
   /* create a local copy of list */
   wc=(char*)malloc(strlen(list)+strlen(sep)+1);
   strcpy(wc,list);
   strcat(wc,sep);
   
   key=(char*)malloc(strlen(word)+strlen(sep)+1);
   strcpy(key,word);
   strcat(key,sep);   

   for (current=wc;
	*current!=0;
	current++)
     if (!strncasecmp(current,key,strlen(key)))
       match=1;
   
   free(key);free(wc);
   return match;
};

/* get valid location of a file out of a list of possible locations */
char *helpings_locate(char *paths[])
{
   int x;
   int fd;
   char *result=NULL;
   
   for (x=0;paths[x]!=NULL;x++)
     {
	fd=open(paths[x],O_RDONLY);
	if (fd!=-1)
	  {
	     result=paths[x];
	     close(fd);
	  };
     };
   
   return result;
};

/* allocate a new list of strings and translate the list specified as 
 * parameter using gettext(). The list must be NULL-terminated */
char **helpings_translatestringlist(char **list)  
{
   int x;
   int elements=0;
   char **newlist;
   
   while (list[elements]!=NULL)
     elements++;
   
   /* allocate the new string list plus a NULL terminator at the end */
   newlist=(char**)malloc(sizeof(char*)*(elements+1));
   for (x=0;x<elements;x++)
     {
	newlist[x]=(char*)malloc(MAXSTRINGSIZE+1);
	newlist[x][MAXSTRINGSIZE]=0;
	/* avoid possible buffer overflow here */
	strncpy(newlist[x],_(list[x]),1024);
     };
   /* terminate the string list */
   newlist[elements]=NULL;
   
   return newlist;
};

	
   
	  

     
   
   
			
			
