/* the main program of Gnometoaster - it loads all the settings,initializes
 * internal data structures and creates the necessary widgets */

#include "config.h"

#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>

#ifdef HAVE_GNOME
#include <gnome.h>
#else
#include <gtk/gtk.h>
#endif /*HAVE_GNOME*/

#include "main.h"
#include "sems.h"
#include "colors.h"
#include "calc.h"
#include "dircache.h"
#include "configfile.h"
#include "tracklist.h"
#include "helpings.h"

#include "menubar.h"
#include "fillstate.h"
#include "preview.h"

#ifdef HAVE_GNOME
#include "toolbar.h"
#endif

#include "destcontrol.h"
#include "fsedit.h"
#include "tracklist.h"
#include "trackedit.h"
#include "record.h"
#include "icons.h"

#include "source.h"

#include "preferences.h"
#include "layoutconfig.h"
#include "configupdate.h"

#include "isotrack.h"
#include "audiotrack.h"
#include "filetypes.h"
#include "stdfiletrack.h"
#include "cddrives.h"
#include "audio.h"
#include "audio_oss.h"
#ifdef HAVE_ESD
# include "audio_esd.h"
#endif

/* include internationalization support */
#include "int.h"

/* uncomment for debugging */
/* #define DEBUG */

/* contains name and full path to the gnometoaster exec file */
char *execname;

GtkWidget *window; /* GTK:   Toplevel Window
		    * GNOME: Toplevel Gnome Application
		    */

GtkWidget *surroundings; /* VBOX:
			  toolbars,menus,status bars etc. can dock here */

GtkWidget *downbox; /* GtkHBox to dock everything that should be below
		     * the Main Window (fillstate,preview,...)
		     * should maybe get undefined if in gnome mode */

GtkTooltips *tooltips;

char *CRLF;

GtkWidget *destination; /* a "Notebook" for the "destinations" */


void delete_event(GtkWidget *widget,GdkEvent *event,gpointer data)
{
	gtk_main_quit();
}
;


void main_quit()
{
	gtk_main_quit();
}
;

int main(int argc,char **argv)
{
   GtkWidget *mainscreen;
   
   GtkWidget *trackedit;	
   GtkWidget *fsedit;
   GtkWidget *record;
   
   GtkWidget *source;
   char *titletext;

/* initialize internationalization support if enabled */
#ifdef ENABLE_NLS
# ifndef HAVE_GNOME   
   setlocale(LC_ALL,"");
# endif        
   bindtextdomain(PACKAGE,LOCALEDIR);
   textdomain(PACKAGE);
#endif

   /* remember name of exec file */
   execname=(char*)malloc(strlen(argv[0])+1);
   strcpy(execname,argv[0]);
   
   CRLF=(char*)malloc(3);
   CRLF[0]=13;
   CRLF[1]=10;
   CRLF[2]=0;
#ifdef HAVE_GNOME
   gnome_init("gtoaster",VERSION,argc,argv);
#else
   gtk_init(&argc,&argv);
#endif
   
   /* ignore SIGPIPE. This is necessary because sometimes
    * you just can't avoid a SIGPIPE occurring when one of the
    * client programs exits unexpectedly. */
   signal(SIGPIPE,SIG_IGN);

   /* initialize semaphore code */
   sems_init();
   
#ifdef DEBUG	
   printf ("main.c: initializing preferences widget...\n");
#endif
   /* load preferences before anything else to avoid complications... */
   preferences_init();
   
   dircache_loadcache(varman_replacevars_copy(dynamic_defs,"$HOME/.gtoaster.dircache"));
   
   layoutconfig_init();
   
#ifdef DEBUG	
        printf ("main.c: creating Main window...\n");
#endif
	titletext=(char*)malloc(255); 
	strcpy(titletext,"GnomeToaster ");
	strncat(titletext,VERSION,255);
#ifdef HAVE_GNOME 
	window=gnome_app_new("gtoaster",titletext);
#else /*ifdef HAVE_GNOME */
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window),titletext);
#endif /*ifdef (else) HAVE_GNOME*/
	free(titletext);
       	gtk_widget_set_usize(GTK_WIDGET(window),INITSIZE_X,INITSIZE_Y);
	gtk_signal_connect(GTK_OBJECT(window),"delete_event",
			   GTK_SIGNAL_FUNC(delete_event),NULL);
	
        layoutconfig_widget_show(GTK_WIDGET(window),"mainwindow");
      	
   
#ifdef DEBUG	
        printf ("main.c: initializing calc,colors,iso/audio-track,filetype registry,drives...\n");
#endif
	colors_init();
   
     	/* create set of tooltips */
       	tooltips=gtk_tooltips_new();
   	gtk_tooltips_set_colors(tooltips,&Blue,&White);   
   
	calc_init();
   	tracklist_init();
	isotrack_init();
	audiotrack_init();
	filetypes_init();
	stdfiletrack_init();
	cddrives_init(); /* do execute this before source_init() */
   
   	audio_init();
   #ifdef HAVE_OSS
   	audio_oss_init();
   #endif
   #ifdef HAVE_ESD
     	audio_esd_init();
   #endif
	
	/* surroundings is the main Gnometoaster widget just below its window
	 * It is inserted in two different ways depending on the presence
	 * of Gnome here */
#ifdef DEBUG	
        printf ("main.c: creating surroundings...\n");
#endif
	surroundings=gtk_vbox_new(0,0);
   	gtk_widget_show(surroundings);
#ifdef HAVE_GNOME
	gnome_app_set_contents(GNOME_APP(window),surroundings);
#else 
	gtk_container_add(GTK_CONTAINER(window),surroundings);
#endif 

   	/* downbox is used to dock fillstate bar and preview player
	 * (generally,at the moment,by the gtk version once fillstate
	 * and preview player have been made floating freely in the gnome
	 * version */
   	downbox=gtk_hbox_new(0,0);
   	gtk_widget_show(downbox);
   	gtk_box_pack_end(GTK_BOX(surroundings),downbox,0,0,0);
   
   
#ifdef DEBUG	
        printf ("main.c: creating menubar...\n");
#endif
	menubar_create();
		    
#ifdef DEBUG
        printf ("main.c: creating toolbar (gnome-only) ...\n");
#endif
#ifdef HAVE_GNOME /* No Toolbar for GTK (yet?) */
	toolbar_create();
#endif /* ifdef HAVE_GNOME*/
		    
	mainscreen=gtk_vpaned_new();
	gtk_box_pack_start(GTK_BOX(surroundings),mainscreen,1,1,1);

	source=source_create();
       	gtk_paned_pack1(GTK_PANED(mainscreen),source,1,1);
	gtk_widget_show(source);
	
#ifdef DEBUG	
        printf ("main.c: creating destination section...\n");
#endif
	destination=destination_create();

	fsedit=fsedit_create();
	gtk_widget_show(fsedit);
	
	trackedit=trackedit_create();
	gtk_widget_show(trackedit);
	
	record=record_create();
	gtk_widget_show(record);
	
	destination_add(GTK_NOTEBOOK(destination),fsedit,fsedit_xpm);
	destination_add(GTK_NOTEBOOK(destination),trackedit,trackedit_xpm);
	destination_add(GTK_NOTEBOOK(destination),record,record_xpm);
		
       	gtk_paned_pack2(GTK_PANED(mainscreen),destination,1,1);
	gtk_widget_show(destination);

	gtk_paned_compute_position(GTK_PANED(mainscreen),INITSIZE_Y,300,180);
	gtk_paned_set_position(GTK_PANED(mainscreen),2*(int)(INITSIZE_Y/3)); 
	gtk_widget_show(mainscreen);

#ifdef DEBUG	
        printf ("main.c: creating fillstate display...\n");
#endif
	/* this is the progress widget displaying the fill state of a cd
	 * at the bottom of the gnometoaster window */
	fillstate_create();
	
   	preview_create();
   
	/* those two have to be called *after* the widgets have been created
	 * because they set the default position of the selection cursor */
	source_init();
	fsedit_init();
   
   /* look for essential configuration updates.
    * do this here because by now all configuration data should have
    * been loaded */
   configupdate_run();
	
   gtk_main();
   
   fsedit_destroy();
   trackedit_destroy();
   dircache_savecache(varman_replacevars_copy(dynamic_defs,"$HOME/.gtoaster.dircache"));
   preferences_save();
   
   /* free gnometoaster's semaphore set */
   sems_destroy();
   
   return 0;
}
;
	
