/* this file is an attempt to define a menu system applicable for both the gtk
 * and the Gnome version . The main goal of this file is to create a concept
 * that can be used easily by both Gtk and Gnome. The functions defined 
 * here decide wether the gnome or the gtk variant is to be used on the
 * HAVE_GNOME flag defined in config.h */

#ifndef MENUSYS_H
#define MENUSYS_H

#include "config.h"
#include "int.h"

#ifdef HAVE_GNOME
#include "gnome.h"
#else
#include "gtk/gtk.h"
#endif

/* the "handmade" menustructure of the gtk version is not as complicated as
 * its corresponding gnome structure. The following macros take care
 * of that fact by expanding into either the gtk or the gnome menu form. */
#ifdef HAVE_GNOME

typedef GnomeUIInfo menusys_menu;

#define MENUSYS_ITEM(label,tooltip,callback,xpm_data)           GNOMEUIINFO_ITEM(label,tooltip,callback,xpm_data)
#define MENUSYS_ITEM_STOCK(label,tooltip,callback,stock_id)     GNOMEUIINFO_ITEM_STOCK(label,tooltip,callback,stock_id)
#define MENUSYS_ITEM_NONE(label,tooltip,callback)               GNOMEUIINFO_ITEM_NONE(label,tooltip,callback)
#define MENUSYS_ITEM_DATA(label,tooltip,callback,data,xpm_data) GNOMEUIINFO_ITEM_DATA(label,tooltip,callback,data,xpm_data)
#define MENUSYS_ITEM_SUBTREE(label,tree)                        GNOMEUIINFO_SUBTREE(label,tree)
#define MENUSYS_ITEM_SUBTREE_STOCK(label,tree,stock_id)         GNOMEUIINFO_SUBTREE_STOCK(label,tree,stock_id)
#define MENUSYS_ITEM_END                                        GNOMEUIINFO_END
#define MENUSYS_ABOUT_ITEM(callback,data)                       GNOMEUIINFO_MENU_ABOUT_ITEM(callback,data)
#define MENUSYS_EXIT_ITEM(callback,data)                        GNOMEUIINFO_MENU_EXIT_ITEM(callback,data)
#define MENUSYS_PREFERENCES_ITEM(callback,data)                 GNOMEUIINFO_MENU_PREFERENCES_ITEM(callback,data)
#define MENUSYS_FILE_TREE(tree)                                 GNOMEUIINFO_MENU_FILE_TREE(tree)
#define MENUSYS_EDIT_TREE(tree)                                 GNOMEUIINFO_MENU_EDIT_TREE(tree)
#define MENUSYS_HELP_TREE(tree)                                 GNOMEUIINFO_MENU_HELP_TREE(tree)
#else

/* as gtks version of comfortable menu creation,the so-called menu-factory,
 * is far too different from what gnome does,we have to create our
 * own definition here and additionally a few functions to parse that structure
 * later on */
typedef struct 
{
	gchar *title;
	gchar *tooltip;
	gpointer callback;
	gpointer data;
	gpointer pixmapdata;
} menusys_menu;
	
#define MENUSYS_SUBTREE NULL
#define MENUSYS_ITEM(label,tooltip,callback,xpm_data)           {label,tooltip,callback,NULL,xpm_data}
#define MENUSYS_ITEM_STOCK(label,tooltip,callback,stock_id)     {label,tooltip,callback,NULL,NULL}
#define MENUSYS_ITEM_NONE(label,tooltip,callback)               {label,tooltip,callback,NULL,NULL}
#define MENUSYS_ITEM_DATA(label,tooltip,callback,data,xpm_data) {label,tooltip,callback,data,xpm_data}
#define MENUSYS_ITEM_SUBTREE(label,tree)                        {label,NULL,MENUSYS_SUBTREE,tree,NULL}
#define MENUSYS_ITEM_SUBTREE_STOCK(label,tree,stock_id)         {label,NULL,MENUSYS_SUBTREE,tree,NULL}
#define MENUSYS_ITEM_END                                        {NULL,NULL,NULL,NULL,NULL}
#define MENUSYS_ABOUT_ITEM(callback,data)                       {N_("About"),N_("Program informations"),callback,data,NULL}
#define MENUSYS_EXIT_ITEM(callback,data)                        {N_("Exit"),N_("Exit program"),callback,data,NULL}
#define MENUSYS_PREFERENCES_ITEM(callback,data)                 {N_("Preferences"),N_("Edit Preferences"),callback,data,NULL}
#define MENUSYS_FILE_TREE(tree)                                 {N_("File"),N_("File menu"),NULL,tree,NULL}
#define MENUSYS_EDIT_TREE(tree)                                 {N_("Edit"),N_("Edit menu"),NULL,tree,NULL}
#define MENUSYS_HELP_TREE(tree)                                 {N_("Help"),N_("Help menu"),NULL,tree,NULL}
#endif

/* The gtk and gnome implementations of the following functions differ,
 * but their interface is the same */

/* set the programs main menu bar */
void menusys_setmenubar(menusys_menu*);
/* attach a popup menu to a widget */
void menusys_attachpopupmenu(GtkWidget*,menusys_menu*,gpointer data);

#endif // MENUSYS_H
