/* this file contains handling routines and 
 * data structures for multisession */

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>

#include "virtualdir.h"
#include "varman.h"
#include "preferences.h"
#include "fileman.h"
#include "piping.h"
#include "fsedit.h"
#include "updatehandlers.h"

/* uncomment for debugging */
/* #define DEBUG */

/* contains the directory structure of the last session of NULL if not
 * present */
virtualdir_dir *multisession_lastsession=NULL;

GList *multisession_updatehandlers=NULL;

int multisession_mkdircall(char *dirname,char *path,gpointer data)
{
   int result;   
   char *realdir;

#ifdef DEBUG
   printf ("multisession_mkdircall: %s in %s\n",dirname,path);
#endif
   
   realdir=(char*)malloc(MAXPATHLENGTH);
   strcpy(realdir,FSEDIT_DESTPATH);
   if (strlen(realdir)>0)
     {	
	if (realdir[strlen(realdir)-1]!='/')
	  strcat(realdir,"/");
     }
   else
     strcpy(realdir,"/");
   strcat(realdir,&path[1]);
   /* create directory in the real directory structure */
   result=fileman_defaultmkdir(dirname,
			       realdir,data);
   free(realdir);
   
   virtualdir_addentry(multisession_lastsession,
		       virtualdir_create(dirname,S_IFDIR,0),
		       path);
   return result;
};
   
int multisession_addfilecall(char *filename,char *path,gpointer data)
{
   char *f;
   struct stat buf;
   
   lstat(filename,&buf);
   
   f=(char*)malloc(255);
   fileman_strippath(filename,f);
   
#ifdef DEBUG
   printf ("multisession_addfilecall: %s to %s as %s,size %i\n",
	   filename,
	   path,
	   f,
	   (int)buf.st_size);
#endif
   
   virtualdir_addentry(multisession_lastsession,
		       virtualdir_create(f,
					 buf.st_mode,
					 buf.st_size),
		       path);
   free(f);
   return 1;
};

/* delete ms informations */
void multisession_delete()
{
   if (multisession_lastsession!=NULL){      
      virtualdir_deletestructure(multisession_lastsession);
      multisession_lastsession=NULL;
   };
   updatehandlers_call(multisession_updatehandlers);
};   

#define GETMSINFOBUFSIZE 1024
/* import the last session of a ms cd */
void multisession_import()
{
   int mountpid;
   char *call;
   int status;
   GList *linkcount=NULL;
   
   char buffer[GETMSINFOBUFSIZE];
   
   int mounted;

   /* if there was another session already imported,delete it */
   multisession_delete();
     
   /* attempt to mount the last session */
   call=varman_replacevars_copy(global_defs,varman_getvar(global_defs,
							  "isotrack_mount"));
   mountpid=piping_create(call,NULL,NULL,NULL);
   waitpid(mountpid,&status,0);
   /* could filesystem actually be mounted by this call ? */
   mounted=(WEXITSTATUS(status)==0);
   free(call);
   
   /* Create root directory for previous session */
   multisession_lastsession=virtualdir_create("Files of last session",
					      0,0);
   /* import the previous session */
   fileman_adddirectory_generic(varman_getvar(global_defs,"rec_mountpoint"),
				"/",
				&linkcount,
				1,
				multisession_mkdircall,
				multisession_addfilecall,
				NULL);					 
   
   /* unmount only if filesystem was actually mounted by the above call
    * otherwise,fs might already have been mounted,in which case we don't
    * want to confuse the user by unmounting it */
   if (mounted)
     {
	call=varman_replacevars_copy(global_defs,varman_getvar(global_defs,
							       "isotrack_umount"));
	mountpid=piping_create(call,NULL,NULL,NULL);
	waitpid(mountpid,&status,0);
	free(call);
     };

   /* get multisession informations from recorder */
   call=varman_replacevars_copy(global_defs,
				varman_getvar(global_defs,"rec_getmsinfo"));
   piping_create_getoutput(call,
			   (char*)&buffer,
			   GETMSINFOBUFSIZE,
			   PIPING_WATCHSTDOUT);
   /* cut at first linefeed */
   if (strchr((char*)&buffer,13)!=NULL)
     *strchr((char*)&buffer,13)=0;
   if (strchr((char*)&buffer,10)!=NULL)
     *strchr((char*)&buffer,10)=0;   
   /* store msinfo in dynamic vartab */
   varman_setvar(dynamic_defs,"cdr_msinfo",(char*)&buffer);
   free(call);
   
#ifdef DEBUG
   printf ("multisession_import: got msinfo %s\n",
	   varman_getvar(dynamic_defs,"cdr_msinfo"));
#endif
   
   updatehandlers_call(multisession_updatehandlers);
};
