/* Gnometoaster's semaphore handling code
 * it's complexity actually deserves a separate file,esp. as it'll be easier
 * to find a starting point in the attempt to convert gnometoaster to other
 * platforms that way */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <stdio.h>
#include <unistd.h>

/* uncomment for debugging */
/* #define DEBUG */

#include "main.h"
#include "sems.h"

int sems_key;
int sems_count=0;

/* create a new semaphore set of num semaphores */
int sems_create(int num)
{
   int result;
   int ftokr;   
   char x=0;
  
   /* this construct makes sure that we get either our own set of 
    * semaphores or none at all. */
   do
     {
	ftokr=ftok(execname,x);
#ifdef DEBUG
	if (ftokr==-1)
	  perror("sems_create: calling ftok()");
	printf("sems_create: ftokr=%i,execname=%s\n",ftokr,execname);
#endif
	if (ftokr==-1) 
	  ftokr=x;
	result=semget(ftokr,num,0600|IPC_CREAT|IPC_EXCL);
#ifdef DEBUG
	if (result==-1)
	  perror("sems_create: getting semaphore set");
	printf("sems_create: set identifier=%i\n",result);
#endif
	x++;
     }
   while ((result==-1)&&(x>0));
    
   /* mark all semaphores of the set as available */
   if (result!=-1)
     for (x=0;x<num;x++)
       semctl(result,x,SETVAL,1);
		
   return result;
};

/* the following functions can be called externally */

/* init the semaphore code and allocate a set of semaphores for gnometoaster */
void sems_init()
{
   sems_key=sems_create(SEMS_MAXCOUNT);
   if (sems_key==-1)
     {
	printf ("sems_init: couldn't get semaphore set. exiting\n");
	exit(-1);
     };
#ifdef DEBUG
   printf ("sems_init: key for semaphore set is %i\n",sems_key);
#endif
};

/* get a new semaphore,quits gnometoaster if no more semaphores are available
 * Semaphores cannot be freed. you'll get a semaphore for life. */
int sems_allocate()
{
   if (sems_count==SEMS_MAXCOUNT)
     {
	printf ("sems_allocate: number of available semaphores has been exceeded.\n"
		"               Please increase SEMS_MAXCOUNT in sems.h\n");
	exit(-1);
     };
#ifdef DEBUG
   printf ("sems_allocate: allocated semaphore %i\n",sems_count);
#endif
   return (sems_count++);
};

/* lock a semaphore */
void sems_lock(int semnum)
{
   struct sembuf sops;
   int result;
   
#ifdef DEBUG
   printf ("sems_lock: pid=%i requesting semaphore %i\n",getpid(),semnum);
#endif
   sops.sem_num=semnum;
   sops.sem_op=-1;
   sops.sem_flg=0;   
   result=semop(sems_key,&sops,1);
#ifdef DEBUG
   if (result==-1)
     perror ("sems_lock: semop()");
   printf ("sems_lock: locked semaphore %i (pid=%i)\n",semnum,getpid());
#endif
};

/* unlock a semaphore */
void sems_unlock(int semnum)
{
   struct sembuf sops;
   int result;

#ifdef DEBUG
   printf ("sems_unlock: unlocking semaphore %i (pid=%i)\n",semnum,getpid());
#endif
      
   sops.sem_num=semnum;
   sops.sem_op=1;
   sops.sem_flg=0;
   result=semop(sems_key,&sops,1);
#ifdef DEBUG
   if (result==-1)
     perror ("sems_unlock: semop()");
#endif
};

/* free our semaphore set as semaphores are global constructs which do not
 * get freed automatically on exit */
void sems_destroy()
{
   int result;
#ifdef DEBUG
   printf ("sems_destroy: freeing semaphore set\n");
#endif
   result=semctl(sems_key,0,IPC_RMID,0);
#ifdef DEBUG
   if (result==-1)
     perror ("sems_destroy: semctl()");
#endif
};

