# Module: HandlePartitions.tk
# 27.1.96 T.Niederreiter
#
# External called functions:
# - selectimagepartition { w }: select your image-partition
#
# - updateselimagetextbox { }: updates the image-part-textbox
# 
# - selectimagemntpnt { w }: select image-mountpoint
#
# - CheckImagePartition { w }: Check status of image-partition 
#


# This procedure creates inside the main frame of the select-partition
# window a new frame for a harddrive and puts its partition as selectable
# buttons inside.

proc makepartframe_sel { w blkdev blkname i } {
global partinfo

	set fixedfont "-*-fixed-medium-*-*--15-*-*-*-*-*-*-*"

	tixLabelFrame $w.$i -label $blkname
	pack $w.$i -ipadx 5 -ipady 3	

	set f [$w.$i subwidget frame]
	tixSelect $f.sel -allowzero true -radio true \
		-orientation vertical -command "resetselection" 
	pack $f.sel

	global selimgpart_$i
	set selimgpart_$i {}
	set j 0 
	while { $partinfo($j,0) != "x" } {
	        if { [string range $partinfo($j,0) 0 7] == $blkdev } {
			set sizemb [expr $partinfo($j,1) / 1024]
			set tmpout [format "%-10s %5sMB \[%2s %-25s\]" \
				$partinfo($j,0) \
			 	$sizemb $partinfo($j,2) $partinfo($j,3)]
			$f.sel add $j -text $tmpout -font $fixedfont
		}
		incr j
	}
	$f.sel config -variable selimgpart_$i 
	pack $w.$i
}


# Create a new window, prompting the user to select a partition
# that will be used as storage for image-files.

proc selectimagepartition { w nowsetpart } {
global partinfo
global diskinfo

	upvar #0 $nowsetpart NOWPART

	frame $w.header
	label $w.header.text -text "Select Image-Partition" -relief sunken \
		-borderwidth 2 -anchor c
	pack $w.header.text -fill x -expand 1 -ipady 10 -pady 5
	pack $w.header -fill x -expand 1 

	tixScrolledWindow $w.mid -height 400
	pack $w.mid -expand 1 -fill both  

	set f [$w.mid subwidget window]

	set i 0
	# loop through the diskinfo-array
	while { $diskinfo($i,0) != "x" } {
		makepartframe_sel $f $diskinfo($i,0) $diskinfo($i,1) $i
		incr i
	}

	# Preselect the button that corresponds to nowsetpart 
	set j 0
 	while { $NOWPART != $partinfo($j,0) && $partinfo($j,0) != "x" } {
		incr j
	}

	if { $partinfo($j,0) != "x" } {
		# Partition valid, set button 
		# by simulating a mouseklick on it
		resetselection $j 1	
	}	

	tixButtonBox $w.box -orientation horizontal
	$w.box add ok -text "OK" -width 5 \
		-command "selbox:ok_cmd $w $nowsetpart"
	$w.box add cancel -text "Cancel" -width 5 -command "destroy $w"
	pack $w.box -fill x -expand 1
	update
}


# Execucted by the OK-button 

proc selbox:ok_cmd { w nowsetpart } {
eval global [info globals selimgpart*]
global partinfo

	update

	upvar #0 $nowsetpart NOWPART

	set tmplist {}
	set NOWPART "" 

	foreach i [info globals selimgpart*] {
		eval set varvalue \$$i
		lappend tmplist $varvalue
	}
	# we have now several lists with the number of the buttons
	# concat them to a single list
	# Do this twice due some list-incompatibilites in newer tcl/tk

	set tmplist [eval concat $tmplist]
	set tmplist [eval concat $tmplist]

	# there should be only one partition in the tmplist,
	# but too avoid errors, we always select the last element
	# in list.
	foreach i $tmplist {
		set NOWPART $partinfo($i,0)
	}

	#update select-image-partition-textbox
	update
	updateselimagetextbox $nowsetpart

	destroy $w 
}

# This procedure allows that several selection-clusters work like
# one. Works only with "radio true", "allowzero true"-selections.
# Everytime the user presses a button in the selection, this 
# procedure is called with the ID of the button and if it was 
# selected of deselected.
# We then reset all selections (nothing selected) and force
# all selection-variables to that ID of the button pressed.
# One one selection this will work. 
# With the catch-command we prevent error-messages we would bet
# from all other selections.

proc resetselection { button sel } {
eval global [info globals selimgpart*]

	if { $sel == 1 } {
		foreach i [info globals selimgpart*] {
			set $i ""
			catch { set $i $button }
		}
	}
}

# Updates the Display in the Image-Partition-Textbox according
# to content of $nowsetpart
# If the partition in nowsetpart is not valid, then set it to none
# and delete any text in the textbox.

proc updateselimagetextbox { nowsetpart } {
global partinfo
global diskinfo

	upvar #0 $nowsetpart NOWPART
	upvar #0 TMP_$nowsetpart WIDGET

	set diskdev [string range $NOWPART 0 7]
	set j 0
	set blkname ""
	while { $diskinfo($j,0) != "x" } {
		if { $diskinfo($j,0) == $diskdev } {
			set blkname $diskinfo($j,1)
		}
		incr j
	}

	set j 0
 	while { $NOWPART != $partinfo($j,0) && $partinfo($j,0) != "x" } {
		incr j
	}

	if { $partinfo($j,0) == "x" } {
		# Partition not valid, set to none
		set NOWPART ""
		$WIDGET configure -text " \n "
		return
	}
	
	set sizemb [expr $partinfo($j,1) / 1024]
	set tmpout [format "%-10s %5sMB \[%-20s\]" $partinfo($j,0) \
		 $sizemb [string range $partinfo($j,3) 0 19]]
	$WIDGET configure -text "$blkname\n$tmpout"

	update
}


# Creates a window with a directory-listing. Prompts the user
# to select the Image-Mountpoint.

proc selectimagemntpnt { w nowmnt } {

	label $w.header -text "Select Image-Mountpoint" -relief sunken \
		-borderwidth 2 -anchor c
	pack $w.header -fill x -expand 1 -ipadx 10 -ipady 10 -pady 5

	tixDirTree $w.dir -directory "/"
	pack $w.dir -fill x -expand 1

	tixButtonBox $w.box -orientation horizontal
	$w.box add ok -text "OK" -width 5 -command "mntpntbox:ok_cmd $w $nowmnt"
	$w.box add cancel -text "Cancel" -width 5 -command "destroy $w"
	pack $w.box -fill x -expand 1

}


# Called by OK-Button of selectimagemntpnt

proc mntpntbox:ok_cmd { w nowmnt } {

	upvar #0 $nowmnt NOWMNT

	set NOWMNT [$w.dir cget -directory]
	update
	destroy $w
}


# File-Selector-Box for prompting the user to enter a filename
# for the logfile.

proc selectlogfilename { w tmp } {
global efdlg_filename

	if { ![info exists efdlg_filename] } {
		set efdlg_filename ""
	}

	label $w.header -text "Select Log-Filename" -relief sunken \
		-borderwidth 2 -anchor c -width 40 
	pack $w.header -fill x -expand 1 -ipadx 10 -ipady 10 -pady 5

	tixFileSelectBox $w.dlg -browsecmd efdlg:select_file \
		-command efdlg:select_file \
		-pattern {*.log} 
	pack $w.dlg -fill x -expand 1


	tixButtonBox $w.box -orientation horizontal
	$w.box add ok -text "OK" -width 5 -command "efdlg:okcmd $w"
	$w.box add cancel -text "Cancel" -width 5 -command "destroy $w"
	pack $w.box -fill x -expand 1

	update
}

# Update the global variable storing the actual selection everytime
# the user clicks on a filename in the box

proc efdlg:select_file { file } {
global efdlg_filename

	set efdlg_filename $file

}

# Called by OK-Button from File-Selector-Box

proc efdlg:okcmd { w } {
global XCDR_LOGNAME
global efdlg_filename

	set XCDR_LOGNAME $efdlg_filename
	update
	destroy $w
}

# Checks the status of the Image-Partition and mount/umount it.
# Returns: 0 = Unknown Partition, not mounted
#          1 = ISO9660-Image on Partition, not mounted
#          2 = Ext2-Partition, mounted on mountpoint

proc CheckImagePartition { w } {
global IMAGE_MNTPNT
global IMAGE_PART
global partinfo

	set i 0
	set mntpnt [ getmountpnt $IMAGE_PART ] 

        # check if the image-device is mounted on the right dir
        set actmntdev [checkmountpnt $IMAGE_MNTPNT]
        if { $actmntdev != $IMAGE_PART && $actmntdev != "" } {
 
                # try to umount that dir
                set mstat [doumount $actmntdev]
		if { $mstat == 0 } {
			# umount failed?
                	puts "Unrecoverable Error: On the Image-Mountdirectory $IMAGE_MNTPNT "
                	puts "   is $actmntdev mounted instead of $IMAGE_PART"
			puts "-> Failed to umount $actmntdev"
			exit
		}
        }

	# Partition is mounted
	if { $mntpnt != "" } {
		# Mounted on right mountpoint ?
		if { $mntpnt != $IMAGE_MNTPNT } {
			puts "Error: The Image-Partition $IMAGE_PART is mounted"
			puts "on $mntpnt instead of the $IMAGE_MNTPNT"
			puts "Exiting..."
			exit
		}

		# Check if mounted-partition is ISO9660
		if { [isiso $IMAGE_PART] } {
			Msg_MountedISO .mntiso $w
			if { [doumount $IMAGE_PART] } {
				Msg_Umounted .umntok $w $IMAGE_PART
			} else {
				Msg_FatalUmntFail .umntnok $w
				exit
			}
			return 1
		} else {
		# Not ISO9660 -> Then its most likely ext2
		#	puts "Found mounted FS on /..."
			return 2
		}
	} else {
	# Not Mounted
		if { [isiso $IMAGE_PART] } {
			# puts "Partition contains an ISO9660-Image"
			return 1
		} else {
			# Try to mount partition 
			if { [domount $IMAGE_PART $IMAGE_MNTPNT] } {
				Msg_Mounted .mntd $w $IMAGE_PART $IMAGE_MNTPNT
				return 2
			} else {
				# Type is unknown
			#	puts "mount failed"
				return 0
			}
		}
	}	 
	return 0	;# Should never be reached
}

