/*  AlsaSubscriber.cpp - Subscriber class to interface with AlsaDAC
 *  Copyright (C) 1998 Andy Lo A Foe <andy@alsa-project.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "AlsaSubscriber.h"
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/resource.h>
#include <fcntl.h>
#include <sched.h>


AlsaSubscriber::AlsaSubscriber()
{
	the_dac = NULL;
	the_ID = -1;
}

AlsaSubscriber::~AlsaSubscriber()
{
	if (the_dac && the_dac->IsInStream(the_ID))
		ExitStream();
	Unsubscribe();
}


void AlsaSubscriber::Subscribe(AlsaDAC *dac)
{
	the_dac = dac;
}


void AlsaSubscriber::Unsubscribe()
{
	if (the_dac && the_dac->IsInStream(the_ID)) { 
		//printf("calling RemoveStreamer(%d) from Unsubscribe()\n", the_ID);
		the_dac->RemoveStreamer(the_ID);
	}	
	the_dac = NULL;
	the_ID = -1;
}


void AlsaSubscriber::EnterStream(streamer_type str, void *arg)
{
	if (the_dac) {
		the_ID = the_dac->AddStreamer(str, arg, 0);
		the_dac->StartStreaming();
	}
}


void AlsaSubscriber::ExitStream()
{
	if (the_dac && the_dac->IsInStream(the_ID)) {
		//printf("calling RemoveStreamer(%d)\n", the_ID);
		if (!the_dac->RemoveStreamer(the_ID)) {
			printf("ERROR! Failed to remove streamer\n");
		} else {
			the_ID = -1;
		}	
	}			
}


bool AlsaSubscriber::IsStreaming()
{
	return (the_dac ? the_dac->IsInStream(the_ID) : false);
}

