/*
 * EVENTS.C extace source file
 * 
 * /GDK/GNOME sound (esd) system output display program
 * 
 * Copyright (C) 1999 by Dave J. Andruczyk 
 * 
 * Based upon Code written by The Rasterman and DrMike from redhat.com
 * Re-hacked to look good by The Rasterman (Michael Fullbright)
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You use this program at your own risk.
 */

#include <config.h>
#include <globals.h>
#include <protos.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <dirent.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk_imlib.h>
#include <esd.h>

gint button_notify_event (GtkWidget *widget, GdkEventButton *event)
{
    int x,y;
    int result;
    x = event->x;
    y = event->y;
    if(event->state & (GDK_BUTTON1_MASK))
    {
	pt_lock = 0;
	one_to_fix = 0;
	spec_drag = 0;
#ifdef DND_DEBUG
	g_print("BUTTON 1 RELEASED!! releasing lock\n");
#endif
	return TRUE;
    }
    if(event->state & (GDK_BUTTON2_MASK))
    {
	/* do something related to letting go of button two (colormap button) */
#ifdef DND_DEBUG
	g_print("BUTTON 2 RELEASED!! releasing lock\n");
#endif
	return TRUE;
    }

    if (event->button == 1 ) /* If your press button 1 (left one) */
    {
	result = test_if_close(x,y);
	if (result > 0)
	{
#ifdef DND_DEBUG
	    g_print("mouse is close enough to an endpoint\n");
	    g_print("setting lock\n");
#endif
	    pt_lock = 1;
	    one_to_fix = result;
	    if (result == CHANGE_SPEC_START)
	    {
		spec_drag = 1;
	    }

	}
	else 
	{
#ifdef DND_DEBUG
	    g_print("mouse is NOT close enough to an endpoint\n");
	    g_print("releasing lock\n");
#endif
	    pt_lock = 0;
	    one_to_fix = 0;
	    spec_drag = 0;
	}
    }
    if (event->button == 2 ) /* If your press button 2 (middle one) */
    {
	if (!grad_win_present)
	    init_colortab();	/* create gradient window */
    }
    if ((event->button == 3 ) && (mode == SPECGRAM)) /* If your press button 3 (right one) */
    {
	result = test_on_line(x,y); /* find out if the place we click is
				     * on the "drawing" line of the display.
				     * This place is where the images is being
				     * drawn "from". (i.e. start of spectragram)
				     */
	if (result == ON_THE_LINE)
	{
	    g_print("We did!! \n");
	}
	else
	{
	    g_print("We didn't... \n");
	}
    }


    return TRUE;
}
gint motion_notify_event (GtkWidget *widget, GdkEventMotion *event)
{
    int x, y;
    GdkModifierType state;

    if (event->is_hint)
    {
	gdk_window_get_pointer (event->window, &x, &y, &state);
    }
    else
    {
	x = event->x;
	y = event->y;
	state = event->state;
    }

    if (pt_lock)
    {
	switch (one_to_fix)
	{
	    case CHANGE_X_START:
		{
#ifdef DND_DEBUG
		g_print("Changing start point\n");
#endif
		change_x_start(x,y);
		break;
		}
	    case CHANGE_X_END:
		{
#ifdef DND_DEBUG
		    g_print("Changing end point\n");
#endif
		    change_x_end(x,y);
		    break;
		}
	    case CHANGE_SPEC_START:
		{
#ifdef DND_DEBUG
		    g_print("Changing Spectrogram Start point\n");
#endif
		    change_spec_start(x);
		}
	    default:
		break;
	}
    }
    return TRUE;
}

int test_on_line(int x_fed, int y_fed)
{ /* nothing here yet. we gotta write is first... :) */
   if (mode != SPECGRAM)
      return(OFF_THE_LINE); 
    {
	if (abs(((width*spec_start) - x_fed)) < 20)
	    return (ON_THE_LINE);
    }
    return (OFF_THE_LINE);
}

int test_if_close(int x_fed, int y_fed)
{
    struct point 
    {
	gint x;
	gint y;
    }start,end;
    gint x_rel=0;
    gint y_rel=0;

    // Must pass both X and Y tests to be "captured", if both points pass
    // then we're in trouble... :( (meaning both start and end)

    switch (mode)
    {
	case (LAND_3D):
	    {
		start.x = (x3d_start*x_draw_width);
		start.y = ((1.0-y3d_start)*y_draw_height);
		end.x = (x3d_end*x_draw_width);
		end.y = ((1.0-y3d_end)*y_draw_height);
		x_rel = x_fed - x_border - abs(x3d_scroll); 
		if (x3d_scroll < 0)
		    x_rel -= x3d_scroll;
		y_rel = y_fed - 3*y_border - (abs(z3d_scroll)/2);

		// tests to see if the mouse pointer is close to an end of an

		if (abs((start.x-x_rel)) < 20)
		{
		    if (abs((start.y-y_rel)) < (20 + abs(z3d_scroll/2)))
		    {
			return (CHANGE_X_START);
		    }
		}
		else if (abs((end.x-x_rel)) < 20)
		{
		    if (abs((end.y-y_rel)) < 20 + levels[0])
		    {
			return (CHANGE_X_END);
		    }
		}

		break;
	    }
	case (SPIKE_3D):
	    {
		start.x = (xdet_start*x_draw_width);
		start.y = ((1.0-ydet_start)*y_draw_height);
		end.x = xdet_end*x_draw_width;
		end.y = (1.0-ydet_end)*y_draw_height;
		x_rel = x_fed - x_border - xdet_scroll/2; 
		if (xdet_scroll < 0)
		    x_rel += xdet_scroll;
		y_rel = y_fed-3*y_border - abs((zdet_scroll/2));

		// tests to see if the mouse pointer is close to an end of an
		 
		if (abs((start.x-x_rel)) < 40)
		{
		    if (abs((start.y-y_rel)) < 40)
		    {
#ifdef DND_DEBUG
    			g_print("Start det found\n");
#endif
			return (CHANGE_X_START);
		    }
		}
		else if (abs((end.x-x_rel)) < 40)
		{
		    if (abs((end.y-y_rel)) < 40)
		    {
#ifdef DND_DEBUG
		    g_print("End det found\n");
#endif
			return (CHANGE_X_END);
		    }
		}
		break;
	    }
	case SPECGRAM:
	    {
		if (abs(((width*spec_start) - x_fed)) < 20)
		    return (CHANGE_SPEC_START);
		break;
	    }
    }

    return -1;
}

void change_spec_start(gint new_x)
{
    spec_start = (float)new_x/(float)width;
    if (spec_start < 0.0)
	spec_start = 0.0;
    if (spec_start > (1.0- (55.0/(float)width)))
	spec_start = 1.0 - (55.0/(float)width);
    display_markers = 1;
}

void change_x_start(gint x_rel, gint y_rel)
{
    y_rel -= 3.5*y_border;
    switch (mode)
    {
	case (LAND_3D):
	    x_rel -= x_border + x3d_scroll/2;
	    break;
	case (SPIKE_3D):
	    x_rel -= x_border;
	    break;
    }

    if (x_rel > x_draw_width)
	x_rel = x_draw_width;
    if (x_rel < x_offset/2)
	x_rel = x_offset/2;
    if (y_rel > y_draw_height)
	y_rel = y_draw_height;
    if (y_rel < y_offset/2)
	y_rel = y_offset/2;
    switch (mode)
    {
	case (LAND_3D):
	    {
		x3d_start = abs(abs(0.5*x3d_scroll)-(gfloat)x_rel)/(gfloat)x_draw_width;
		y3d_start = 1.0-(abs(abs(0.5*z3d_scroll)-(gfloat)y_rel)/(gfloat)y_draw_height);
		/* Removed from panel
		GTK_ADJUSTMENT (x3d_start_ptr)->value = x3d_start*100;
		GTK_ADJUSTMENT (y3d_start_ptr)->value = y3d_start*100;
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (x3d_start_ptr));
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (y3d_start_ptr));
		*/
		break;
	    }
	case (SPIKE_3D):
	    {
		xdet_start = abs(abs(0.5*xdet_scroll)-(gfloat)x_rel)/(gfloat)x_draw_width;
		ydet_start = 1.0-(abs(abs(0.5*zdet_scroll)-(gfloat)y_rel)/(gfloat)y_draw_height);
		/* removed from panel
		GTK_ADJUSTMENT (xdet_start_ptr)->value = xdet_start*100;
		GTK_ADJUSTMENT (ydet_start_ptr)->value = ydet_start*100;
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (xdet_start_ptr));
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (ydet_start_ptr));
		*/
		break;
	    }
    }
}

void change_x_end(gint x_rel, gint y_rel)
{
    y_rel -= 3.5*y_border;
    switch (mode)
    {
	case (LAND_3D):
	    x_rel -= x_border + x3d_scroll/2;
	    break;
	case (SPIKE_3D):
	    x_rel -= x_border;
	    break;
    }

    if (x_rel > x_draw_width)
	x_rel = x_draw_width;
    if (x_rel < x_offset/2)
	x_rel = x_offset/2;
    if (y_rel > y_draw_height)
	y_rel = y_draw_height;
    if (y_rel < y_offset/2)
	y_rel = y_offset/2;
    switch (mode)
    {
	case (LAND_3D):
	    {
		x3d_end = abs(abs(0.5*x3d_scroll)-(gfloat)x_rel)/(gfloat)x_draw_width;
		y3d_end = 1.0-(abs(abs(0.5*z3d_scroll)-(gfloat)y_rel)/(gfloat)y_draw_height);
		/* removed from panel
		GTK_ADJUSTMENT (x3d_end_ptr)->value = x3d_end*100;
		GTK_ADJUSTMENT (y3d_end_ptr)->value = y3d_end*100;
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (x3d_end_ptr));
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (y3d_end_ptr));
		*/
		break;
	    }
	case (SPIKE_3D):
	    {
		xdet_end = abs(abs(0.5*xdet_scroll)-(gfloat)x_rel)/(gfloat)x_draw_width;
		ydet_end = 1.0-(abs(abs(0.5*zdet_scroll)-(gfloat)y_rel)/(gfloat)y_draw_height);
		/* removed from panel
		GTK_ADJUSTMENT (xdet_end_ptr)->value = xdet_end*100;
		GTK_ADJUSTMENT (ydet_end_ptr)->value = ydet_end*100;
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (xdet_end_ptr));
		gtk_adjustment_value_changed(GTK_ADJUSTMENT (ydet_end_ptr));
		*/
		break;
	    }
    }

}
