// frameview.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Specialized DataView which contains a single FrameGraph instance, and 
// forwards display messages on to that member.

#ifndef FRAMEVIEW_H
#ifdef __GNUG__
#pragma interface
#endif
#define FRAMEVIEW_H

#include "dataview.h"

class HScale;
class VBox;
class Panner;
class Event;
class Perspective;
class Data;
class Range;
class Controller;
class ChannelGraph;
class EditStatusDelegate;

class FrameView : public DataView {
	typedef DataView Super;
public:
	FrameView(Controller *, ViewInfo &);
	redefined void Reconfig();
	
	// methods invoked by menu items

	redefined void verticalZoom();
	redefined void verticalUnZoom();
	redefined void resetVerticalRange();
	redefined void setChannelRange();
	redefined void shiftChannelViewUp();
	redefined void shiftChannelViewDown();
	redefined void toggleGraphMode() {}

	// redefined to avoid hiding

	redefined void setVisibleFrameRange() { DataView::setVisibleFrameRange(); }
	redefined void setInsertPoint() { DataView::setInsertPoint(); }
	redefined void setEditRegion() { DataView::setEditRegion(); }
	redefined void setInsertPoint(int, const Range&, boolean scroll=true);
	redefined void setEditRegion(const Range&, const Range&, boolean scroll=true);
	redefined Range getHorizScaleRange();
	redefined Range getVisibleFrameRange();
	redefined void setVisibleFrameRange(const Range &);
	redefined Range getChannelRange();
	redefined void setChannelRange(const Range &);
	redefined boolean keyCommand(unsigned long cmd);

	redefined boolean frameScaleInFrames();
protected:
	redefined void Resize();
private:
	friend Controller;
	friend EditStatusDelegate;

	redefined const char* plotWidthAttribute() { return "FramePlotSize"; }
	redefined void initPerspective();
	redefined void checkPerspective();
	redefined Perspective* getVerticalPerspective();
	redefined void constrainVerticalView(Perspective &);
	redefined int horizScaleRightSpacer();
	void Init();
	void doZoom(double factor);
	void setVerticalUnitsDecibel(boolean);
	
	Interactor* verticalScroller;
};

#endif
