// new.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#if defined(USE_CUSTOM_NEW) || !defined(NO_NEW_HANDLER)
#include <new.h>
#endif

#include "localdefs.h"

#ifndef NO_NEW_HANDLER
extern "C" {
static void
mxv_new_handler() {
	fprintf(stderr, "mxv: memory allocation failure.\n");
	exit(1);
}
}
#endif

void
setMemoryHandler() {
#ifndef NO_NEW_HANDLER
	set_new_handler(mxv_new_handler);
#endif
}

#ifdef USE_CUSTOM_NEW

void *
operator new(size_t size) {
	void *mem = 0;
	while((mem = (void *) malloc(size)) == 0) {
#ifndef NO_NEW_HANDLER
		if(__new_handler)
			(*__new_handler) ();
		else
#endif
			return 0;
	}
#ifdef PRINT_MALLOC
	fprintf(stderr, "%x alloced for size %d\n", mem, size);
#endif
	return mem;
}

extern void
operator delete(void *ptr) {
	if(ptr) {
		free(ptr);
#ifdef PRINT_FREE
		fprintf(stderr, "%x freed.\n", ptr);
#endif
	}
}

#endif /* USE_CUSTOM_NEW */

