/*
 * Functions for modifying the mp3 files.
 * GPL'ed, check COPYRIGHT
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include "mp3info.hxx"

bool Mpfile::mpopen(char *fname, bool write)
{
    struct stat fi;
    openwrite = write;

    if (fname == NULL)
	fname = filename;
    if (write) {
	file = fopen(fname, "r+");
    } else {
	file = fopen(fname, "r");
    }
    if (file != NULL) {
	fstat(fileno(file), &fi);
	filelen = fi.st_size;
    } else {
	return (false);
    }
    strncpy(filename, fname, FILENAME_LEN);
    return (true);
}

void Mpfile::mpclose()
{
    if (file)
	fclose(file);
    file = NULL;
}

bool Mpfile::execute(char *format)
{
    char runner[STD_BUF_LEN];

    mpformat(runner, format, STD_BUF_LEN, 1);

    if (runner[0]) {
	mpclose();
	system(runner);
    }
    return true;
}

bool Mpfile::frename(char *format)
{
    char newname[STD_BUF_LEN];
    char dirbuff[STD_BUF_LEN];
    char *p;
    int ok = false;

    mpformat(newname, format, STD_BUF_LEN, 0);
    if (newname[0]) {
	/* OS/2 hangs here, unfortunately, unless we close it fist */
	mpclose();
	ok = rename(filename, newname);
	if (ok) {
	    ok = errno;
	    if (ok == EXDEV) {
		fprintf(stderr, "Rename not allowed across filesystems\n");
	    } else if (ok == ENOENT) {
		strcpy(dirbuff, newname);
		p = dirbuff;
		if (*p == '/')
		    p++;
		while ((p = strchr(p, '/'))) {
		    *p = 0;
		    mkdir(dirbuff, 0755);
		    *p = '/';
		    p++;
		}
		ok = rename(filename, newname);
	    }
	}
	if (ok == 0)
	    strcpy(filename, newname);
	return (ok == 0);
    }
    return (true);
}

Mpfile::Mpfile()
{
    filelen = 0;
    filename[0] = 0;
    length = 0;
    tag = new Tag;
    layer = new Layer;
    hastag = false;
    haslayer = false;
}

Mpfile::~Mpfile()
{
    delete(layer);
    delete(tag);
    if (filename[0] && file)
	fclose(file);
}

bool Mpfile::initfile(bool gettag)
{
    int bitrate;
    if (!(layer->get(file))) {
	haslayer = false;
	return (false);
    }
    haslayer = true;
    if (gettag)
	hastag = tag->get(file);

    bitrate=layer->bitrate();
    if (bitrate) 
      length = filelen / (bitrate * 125);
    else
      length = 0;
    return (true);
}


bool Mpfile::writetag()
{
    return (tag->set(file));
}

bool Mpfile::wipetag()
{
    return (tag->wipe(file, filelen));
}

void Mpfile::tagcopy(Tag * from)
{
    tag->copy(from);
    hastag = true;
}

