/*
 * Parse and print std header.
 * GPL'ed, check COPYRIGHT
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include "mp3info.hxx"

bool Mpfile::parseif(char what)
{
    switch (what) {
    case 'T':
	return (hastag);
	break;
    case 'H':
	return (haslayer);
	break;
    case 'a':
	return (tag->artist[0]);
	break;
    case 'n':
	fprintf(stderr, "Warning: Using old %%In for Tag Title, use %%It.");
	return (tag->title[0]);
	break;
    case 't':
	return (tag->title[0]);
	break;
    case 'l':
	return (tag->album[0]);
	break;
    case 'y':
	return (tag->year[0]);
	break;
    case 'c':
	return (tag->comment[0]);
	break;
    case 'C':
	return (layer->error_protection);
	break;
    case 'O':
	return (layer->copyright);
	break;
    case 'o':
	return (layer->original);
	break;
    case 'S':
	return (layer->stereo);
	break;
    default:
	fprintf(stderr, "Warning: If-Format unknown.");
	return (0);
    }
}

bool Mpfile::mpformat(char *out, char *format, size_t maxlen, int canslash)
{
    char *from = format;
    char formatting[256];
    char unslashed[256];
    int ifnest = 0;
    int ifinc = 0;
    size_t to = 0;
    char *form;
    void *data;
    char *p;
    char *u;
    data = NULL;
    while ((from[0] != 0) && (to < maxlen)) {
	if (from[0] == '%') {
	    from++;
	    switch (from[0]) {
	    case 'I':
		from++;
		if (from[0] == 'E') {
		    if (ifnest == ifinc)
			ifinc--;
		    ifnest--;
		} else {
		    if ((ifinc == ifnest) && parseif(from[0]))
			ifinc++;
		    ifnest++;
		}
		break;
	    case '!':
		from++;
		if (from[0] == 'E') {
		    if (ifnest == (ifinc + 1))
			ifinc++;
		    else if (ifnest == ifinc)
			ifinc--;
		} else {
		    if ((ifinc == ifnest) && !parseif(from[0]))
			ifinc++;
		    ifnest++;
		}
		break;
	    default:
		form = formatting;
		*form++ = '%';
		while (((*from >= '0') && (*from <= '9')) || (*from == '-') || (*from == '.'))
		    *form++ = *from++;
		*form = 0;
		if (ifnest == ifinc) {
		    switch (from[0]) {
		    case 'a':
			*form = 's';
			data = (void *) tag->artist;
			break;
		    case 't':
			*form = 's';
			data = (void *) tag->title;
			break;
		    case 'n':
			fprintf(stderr, "Warning: Using old binding %%n for TAG TITLE. Use %%t.");
			*form = 's';
			data = (void *) tag->title;
			break;
		    case 'l':
			*form = 's';
			data = (void *) tag->album;
			break;
		    case 'y':
			*form = 's';
			data = (void *) tag->year;
			break;
		    case 'c':
			*form = 's';
			data = (void *) tag->comment;
			break;
		    case 'g':
			*form = 's';
			data = (void *) tag->genre;
			break;
		    case '#':
			*form = 'i';
			data = (void *) tag->gennum;
			break;
		    case 'v':
			*form = 's';
			data = (void *) layer->version_num();
			break;
		    case 'V':
			*form = 's';
			data = (void *) layer->version_name();
			break;
		    case 'L':
			*form = 's';
			data = (void *) layer->layer_name();
			break;
		    case 'A':
			*form = 'i';
			data = (void *) layer->lay;
			break;
		    case 'C':
			*form = 'i';
			data = (void *) layer->error_protection;
			break;
		    case 'b':
			*form = 'i';
			data = (void *) layer->bitrate();
			break;
		    case 'F':
			*form = 'u';
			data = (void *) layer->sfreq();
			break;
		    case 'M':
			*form = 's';
			data = (void *) layer->mode_name();
			break;
		    case 'O':
			*form = 'i';
			data = (void *) layer->copyright;
			break;
		    case 'o':
			*form = 'i';
			data = (void *) layer->original;
			break;
		    case 'm':
			*form++ = 'l';
			*form = 'u';
			data = (void *) (length / 60);
			break;
		    case 's':
			*form++ = 'l';
			*form = 'u';
			data = (void *) (length % 60);
			break;
		    case 'S':
			*form++ = 'l';
			*form = 'u';
			data = (void *) length;
			break;
		    case 'N':
			form = formatting;
			*form = '\n';
			break;
		    case 'f':
			*form = 's';
			data = (void *) filename;
			break;
		    case 'B':
			*form = 's';
			p = strrchr(filename, '/');
			if (p)
			    data = (void *) (p + 1);
			else
			    data = (void *) filename;
			break;
		    case 'i':
			*form = 'u';
			data = (void *) filelen;
			break;
		    case 'E':
			form = formatting;
			*form++ = '\x1B';
			*form = '[';
			break;
		    default:
			form = formatting;
			*form = *from;
		    }
		    form++;
		    *form = 0;
                    if (!canslash && (formatting[1]=='s')) {
                       strcpy(unslashed, (char *) data);
                       u=unslashed;
                       while (*u) { 
                         if (*u=='/') *u='_';
                         u++;
                       }
                       data=(void *)unslashed;
                    }
		    to += sprintf(&out[to], formatting, data);
		}
	    }
	} else {
	    if (ifnest == ifinc) {
		out[to] = from[0];
		to++;
	    }
	}
	from++;
    }
    if (to > maxlen)
	to = maxlen;
    out[to] = 0;
    if (to >= maxlen)
	fprintf(stderr, "Warning: Output too large, cut.");
    return (to != 0);
}
