/* Headers for mp3info
 * GPL'ed, check COPYRIGHT
 */
#define FORMAT_LEN 512
#define STD_BUF_LEN 2048
#define PLAY_BUF_LEN 4096
#define DECODER "l3dec"
#define DECODEOPTS "-sti","-sto","-sa"
#define AUDIO "/dev/dsp"
#define FILENAME_LEN 256

/* MPEG Header Definitions - Mode Values */

#define         MPG_MD_STEREO           0
#define         MPG_MD_JOINT_STEREO     1
#define         MPG_MD_DUAL_CHANNEL     2
#define         MPG_MD_MONO             3

#define         MPG_MD_LR_LR             0
#define         MPG_MD_LR_I              1
#define         MPG_MD_MS_LR             2
#define         MPG_MD_MS_I              3


/* ID3 TAG Format, Space-filled (grr) */

typedef struct {
    char tag[3];
    char title[30];
    char artist[30];
    char album[30];
    char year[4];
    char comment[30];
    unsigned char genre;
} tag;

class Tag {
    public:
    Tag();
    bool get(FILE * file);
    bool set(FILE * file);
    bool wipe(FILE * file, size_t size);
    void copy(Tag * from);
    void printgenres(int format);

    char title[31];
    char artist[31];
    char album[31];
    char year[5];
    char comment[31];
    char genre[31];
    int gennum;
};

class Layer {
    public:
    char *mode_name();
    char *layer_name();
    char *version_name();
    char *version_num();
    unsigned int bitrate();
    unsigned int sfreq();
    bool get(FILE * file);
    int version;
    int lay;
    int error_protection;
    int bitrate_index;
    int sampling_frequency;
    int padding;
    int extension;
    int mode;
    int mode_ext;
    int copyright;
    int original;
    int emphasis;
    int stereo;
};


class Mpfile {
    public:
    Mpfile();
    ~Mpfile();
    bool mpopen(char *name, bool write);
    void mpclose();
    bool initfile(bool gettag);
    void calc();
    bool mpformat(char *dest, char *format, size_t maxlen, int canslash);
    bool frename(char *format);
    bool execute(char *format);
    bool writetag();
    bool wipetag();
#ifdef PLAYER
    bool play(int threads);
#endif
    void tagcopy(Tag * from);

    Tag *tag;
    Layer *layer;
    bool hastag;
    bool haslayer;

    protected:
    bool openwrite;
    bool parseif(char what);
    FILE *file;
    size_t filelen;
    char filename[FILENAME_LEN];
    unsigned long length;
};

/* From tag.c */
extern char *genres[];
extern int genre_largest;
