/* Copyright (c) 1997-1999 Miller Puckette.
* For information on usage and redistribution, and for a DISCLAIMER OF ALL
* WARRANTIES, see the file, "LICENSE.txt," in this distribution.  */

/* dialogs.  LATER, deal with the situation where the object goes 
away before the panel does... */

#include "m_pd.h"
#include <stdio.h>
#ifdef UNIX
#include <unistd.h>
#endif

/* --------------------- graphics responder  ---------------- */

/* make one of these if you want to put up a dialog window but want
to be protected from getting deleted and then having the dialog call
you back.  In this design the calling object doesn't have to keep the
address of the dialog window around; instead we keep a list of all
open dialogs.  Every object that might have dialogs checks down this
list and breaks off any dialogs that migh later have sent messages to
it.  Only when the dialog window itself closes do we delete the object. */

static t_class *gfxstub_class;

typedef struct _gfxstub
{
    t_pd x_pd;
    t_pd *x_owner;
    void *x_key;
    t_symbol *x_sym;
    struct _gfxstub *x_next;
} t_gfxstub;

static t_gfxstub *gfxstub_list;

void gfxstub_new(t_pd *owner, void *key, const char *cmd)
{
    char buf[MAXPDSTRING];
    char namebuf[80];
    t_gfxstub *x;
    t_symbol *s;
    if (strlen(cmd) + 84 > MAXPDSTRING)
    	return;
    x = (t_gfxstub *)pd_new(gfxstub_class);
    sprintf(namebuf, "gfxstub%x", (t_int)x);

    s = gensym(namebuf);
    pd_bind(&x->x_pd, s);
    x->x_owner = owner;
    x->x_sym = s;
    x->x_key = key;
    x->x_next = gfxstub_list;
    gfxstub_list = x;
    sprintf(buf, cmd, s->s_name);
    sys_gui(buf);
}

static void gfxstub_offlist(t_gfxstub *x)
{
    t_gfxstub *y1, *y2;
    if (gfxstub_list == x)
    	gfxstub_list = x->x_next;
    else for (y1 = gfxstub_list; y2 = y1->x_next; y1 = y2)
    	if (y2 == x) 
    {
	y1->x_next = y2->x_next;
	break;
    }
}

    /* if the owner disappears, we still may have to stay around until our
    dialog window signs off.  LATER add a feature to delete the dialog
    window automatically. */
void gfxstub_deleteforkey(void *key)
{
    t_gfxstub *y;
    for (y = gfxstub_list; y; y = y->x_next)
    {
    	if (y->x_key == key)
	{
	    y->x_owner = 0;
	    gfxstub_offlist(y);
	    y = gfxstub_list;
	}
    }
}

    /* this one comes down from the GUI to say the dialog window closed. */
static void gfxstub_signoff(t_gfxstub *x)
{
    gfxstub_offlist(x);
    pd_free(&x->x_pd);
}

    /* anything else is a message from the dialog window to the owner;
    just forward it. */
static void gfxstub_anything(t_gfxstub *x, t_symbol *s, int argc, t_atom *argv)
{
    if (x->x_owner)
    	pd_typedmess(x->x_owner, s, argc, argv);
}

static void gfxstub_free(t_gfxstub *x)
{
    pd_unbind(&x->x_pd, x->x_sym);
}

static void gfxstub_setup(void)
{
    gfxstub_class = class_new(gensym("gfxstub"), (t_newmethod)gfxstub_new,
    	(t_method)gfxstub_free,
    	sizeof(t_gfxstub), CLASS_PD, 0);
    class_addanything(gfxstub_class, gfxstub_anything);
    class_addmethod(gfxstub_class, (t_method)gfxstub_signoff,
    	gensym("signoff"), 0);
}

/* -------------------------- openpanel ------------------------------ */

static t_class *openpanel_class;

typedef struct _openpanel
{
    t_object x_obj;
    t_symbol *x_s;
} t_openpanel;

static void *openpanel_new(void)
{
    char buf[50];
    t_openpanel *x = (t_openpanel *)pd_new(openpanel_class);
    sprintf(buf, "d%x", (t_int)x);
    x->x_s = gensym(buf);
    pd_bind(&x->x_obj.ob_pd, x->x_s);
    outlet_new(&x->x_obj, &s_symbol);
    return (x);
}

static void openpanel_bang(t_openpanel *x)
{
    sys_vgui("pdtk_openpanel %s\n", x->x_s->s_name);
}

static void openpanel_symbol(t_openpanel *x, t_symbol *s)
{
    outlet_symbol(x->x_obj.ob_outlet, s);
}

static void openpanel_free(t_openpanel *x)
{
    pd_unbind(&x->x_obj.ob_pd, x->x_s);
}

static void openpanel_setup(void)
{
    openpanel_class = class_new(gensym("openpanel"),
    	(t_newmethod)openpanel_new, (t_method)openpanel_free,
    	sizeof(t_openpanel), 0, A_DEFFLOAT, 0);
    class_addbang(openpanel_class, openpanel_bang);
    class_addsymbol(openpanel_class, openpanel_symbol);
}

/* -------------------------- savepanel ------------------------------ */

static t_class *savepanel_class;

typedef struct _savepanel
{
    t_object x_obj;
    t_symbol *x_s;
} t_savepanel;

static void *savepanel_new(void)
{
    char buf[50];
    t_savepanel *x = (t_savepanel *)pd_new(savepanel_class);
    sprintf(buf, "d%x", (t_int)x);
    x->x_s = gensym(buf);
    pd_bind(&x->x_obj.ob_pd, x->x_s);
    outlet_new(&x->x_obj, &s_symbol);
    return (x);
}

static void savepanel_bang(t_savepanel *x)
{
    sys_vgui("pdtk_savepanel %s\n", x->x_s->s_name);
}

static void savepanel_symbol(t_savepanel *x, t_symbol *s)
{
    outlet_symbol(x->x_obj.ob_outlet, s);
}

static void savepanel_free(t_savepanel *x)
{
    pd_unbind(&x->x_obj.ob_pd, x->x_s);
}

static void savepanel_setup(void)
{
    savepanel_class = class_new(gensym("savepanel"),
    	(t_newmethod)savepanel_new, (t_method)savepanel_free,
    	sizeof(t_savepanel), 0, A_DEFFLOAT, 0);
    class_addbang(savepanel_class, savepanel_bang);
    class_addsymbol(savepanel_class, savepanel_symbol);
}

/* -------------------------- setup routine ------------------------------ */

void x_gui_setup(void)
{
    gfxstub_setup();
    openpanel_setup();
    savepanel_setup();
}
