
#include "OSS.h"
#include "libxmms/configfile.h"

OSSConfig oss_cfg;

void oss_init(void)
{
	ConfigFile *cfgfile;
	gchar *filename;

	memset(&oss_cfg, 0, sizeof (OSSConfig));

	oss_cfg.audio_device = 0;
	oss_cfg.mixer_device = 0;
	oss_cfg.buffer_size = 3000;
	oss_cfg.prebuffer = 25;
	// Master-PCM select  C.Pitchford
	oss_cfg.use_master=0;
	
	filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	if ((cfgfile = xmms_cfg_open_file(filename)))
	{
		xmms_cfg_read_int(cfgfile, "OSS", "audio_device", &oss_cfg.audio_device);
		xmms_cfg_read_int(cfgfile, "OSS", "mixer_device", &oss_cfg.mixer_device);
		xmms_cfg_read_int(cfgfile, "OSS", "buffer_size", &oss_cfg.buffer_size);
		xmms_cfg_read_int(cfgfile, "OSS", "prebuffer", &oss_cfg.prebuffer);
		xmms_cfg_read_boolean(cfgfile, "OSS", "use_master", &oss_cfg.use_master);
		xmms_cfg_free(cfgfile);
	}
}
