#include <ctime>

#include <fstream>

#include "data.hh"


namespace aspell {

  namespace writable_base {

    class WritableBaseCode {
    protected:
      string suffix;
      string compatibility_suffix;

      string cur_file_name;
      time_t cur_file_date;

      string compatibility_file_name;

      WritableBaseCode(const char * s, const char * cs)
	: suffix(s), compatibility_suffix(cs) {}
      virtual ~WritableBaseCode() {}

      virtual void save(ostream &, const string &) = 0;
      virtual void merge(istream &, const string &, 
			 const Config * config = 0) = 0;

      void save2(fstream &, const string &);
      void update(fstream &, const string &);
      void save(bool do_update);
      void update_date(fstream &);
      void load(const string &, const Config *);
      void merge(const string &);
      void save_as(const string &);
    };

    template <typename Base>
    class WritableBase : public Base, public WritableBaseCode 
    {
    public:
      WritableBase(const char * s, const char * cs) 
	: WritableBaseCode(s,cs) {}

      void load(const string & f, const Config * c) { 
	WritableBaseCode::load(f,c);
      };
      void merge(const string & f) {
	WritableBaseCode::merge(f);
      };
      void save_as(const string & f) {
	WritableBaseCode::save_as(f);
      }
      void synchronize() {
	WritableBaseCode::save(true);
      }
      void save_noupdate() {
	WritableBaseCode::save(false);
      }
      const char * file_name() const {
	return cur_file_name.c_str();
      }
    };
  }
}
