
#include <strstream>
#include <fstream>

#include "string_map.hh"
#include "trim_space.hh"
#include "file_exceps.hh"

#include <hash_map>
#include "hash_string_s.hh"
#include "copy_ptr-t.hh"

#include "as_config.h"

namespace autil {

  template CopyPtr<StringMap::Data>;

  //
  // Utility Functions
  //

  static string trim_comments(const string & data) {
    string temp;
    string::const_iterator i = data.begin();
    string::const_iterator end = data.end();
    while (i != end && *i != '#') {temp += *i; ++i;}
    return temp;
  }

  static bool getdata_pair(istream & in, string & key, string & data, char d) {
    string temp;
    if (!getline(in,temp,d)) return false;
    temp = trim_comments(temp);
    istrstream s(temp.c_str());
    if (!(s >> key)) return getdata_pair(in,key,data,d);
    data = "";
    do {
      if (!getline(s,temp)) temp = "";
      data += temp + " ";
    } while (temp[temp.size()-1]=='\\');
    data = trim_space(data);
    return true;
  }

  //
  // StringMap Internal Classes
  //

#ifdef LONG_SYMBOLS_WORKAROUND
  
  class SM_String : public string {
  public:
    SM_String() {}
    SM_String(const string & s) : string(s) {}
    SM_String(const char * s) : string(s)   {}
  };

  class StringMap::Data 
    : public hash_map<SM_String,SM_String,HashString<SM_String> > 
  {};

#else

  class StringMap::Data : public hash_map<string, string> {};

#endif

  struct StringMap::Parms {
    typedef Ref                  Value;
    typedef Data::const_iterator Iterator;

    static const StringMap::Value empty;
    Iterator                      end;

    Parms(Iterator e) : end(e) {}
    bool endf(Iterator e)   const {return e==end;}
    Value end_state()       const {return empty;}
    Value deref(Iterator i) const {return reinterpret_cast<Value>(*i);}
  };

  const StringMap::Value StringMap::Parms::empty;

  // 
  // String map methods
  //

  StringMap::VirEmul * StringMap::elements() const {
    return new MakeVirEmulation<Parms>(data->begin(), Parms(data->end()));
  }


  StringMap::StringMap() {
    data = new Data();
  }

  StringMap::StringMap(const StringMap & other) {
    data = other.data;
  }

  StringMap::~StringMap() {}

  void StringMap::merge(const StringMap & other) {
    Data::const_iterator i   = other.data->begin();
    Data::const_iterator end = other.data->end();
    while (i != end) {
      replace(i->first, i->second);
      ++i;
    }
  }

  void StringMap::read_in_stream(istream & in, char delim, AddAction a) {
    string key,value;
    while (getdata_pair(in, key, value, delim)) {
      if (a == Replace) 
	replace(key, value);
      else
	insert(key,value);
    }
  }

  void StringMap::read_in_file(const string & file, AddAction a) {
    ifstream in(file.c_str());
    if (in.rdstate() & ios::badbit) 
      throw CantReadFile(file);
    read_in_stream(in, '\n', a);
  }

  void StringMap::read_in_string(const string & str, AddAction a) {
    istrstream in(str.c_str());
    read_in_stream(in, ';', a);
  }

  void StringMap::write_to_stream(ostream & out) const {
    Data::const_iterator i = data->begin();
    Data::const_iterator e = data->end();
    while ( i != e ) {
      out << i->first << '\t' << i->second << endl;
      ++i;
    }
  }

  void StringMap::write_to_file(const string & file) const {
    ofstream out(file.c_str());
    if (out.rdstate() & ios::badbit) 
      throw CantWriteFile(file);
    write_to_stream(out);
  }

  const string & StringMap::lookup (const string & key) const {
    static const string empty_string;
    Data::const_iterator i = data->find(key);
    if (i == data->end()) 
      return empty_string;
    else 
      return i->second;
  }

  string & StringMap::find( const string & key) {
    return (*data)[key];
  }

  bool StringMap::have(const string & key) const {
    return data->count(key);
  }

  void StringMap::clear() {
    data = new Data();
  }

  void StringMap::insert(const string & key, const string & value) {
    data->insert(Data::value_type(key,value));
  }

  void StringMap::replace(const string & key, const string & value) {
    (*data)[key] = value;
  }

  void StringMap::remove(const string & key) {
    data->erase(key);
  }

}
