## -*- perl -*-
## ----------------------------------------------------------------------
## DebianDoc_SGML/Locale/Alias.pm: locale aliases for i18n support
## ----------------------------------------------------------------------
## Copyright (C) 1998,1999,2000 Ardo van Rangelrooij
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## package interface definition
package DebianDoc_SGML::Locale::Alias;
use strict;
use vars qw( @ISA @EXPORT );
use Exporter;
@ISA = qw( Exporter );
@EXPORT = qw( %locale_aliases );

## ----------------------------------------------------------------------
## locale alias definitions
use vars qw( %locale_aliases );
%locale_aliases = (
		   ''			 => 'en_US.ISO8859-1',
		   'C'			 => 'en_US.ISO8859-1',
		   'POSIX'		 => 'en_US.ISO8859-1',
		   'cs'			 => 'cs_CZ.ISO8859-2',
		   'cs_CZ'		 => 'cs_CZ.ISO8859-2',
		   'cs_CZ.ISO8859-2'	 => 'cs_CZ.ISO8859-2',
		   'da'			 => 'da_DK.ISO8859-1',
		   'da_DK'		 => 'da_DK.ISO8859-1',
		   'da_DK.ISO8859-1'	 => 'da_DK.ISO8859-1',
		   'de'			 => 'de_DE.ISO8859-1',
		   'de_DE'		 => 'de_DE.ISO8859-1',
		   'de_DE.ISO8859-1'	 => 'de_DE.ISO8859-1',
		   'en'			 => 'en_US.ISO8859-1',
		   'en_US'		 => 'en_US.ISO8859-1',
		   'en_US.ISO8859-1'	 => 'en_US.ISO8859-1',
		   'es'			 => 'es_ES.ISO8859-1',
		   'es_ES'		 => 'es_ES.ISO8859-1',
		   'es_ES.ISO8859-1'	 => 'es_ES.ISO8859-1',
		   'fi'			 => 'fi_FI.ISO8859-1',
		   'fi_FI'		 => 'fi_FI.ISO8859-1',
		   'fi_FI.ISO8859-1'	 => 'fi_FI.ISO8859-1',
		   'fr'			 => 'fr_FR.ISO8859-1',
		   'fr_FR'		 => 'fr_FR.ISO8859-1',
		   'fr_FR.ISO8859-1'	 => 'fr_FR.ISO8859-1',
		   'hr'			 => 'hr_HR.ISO8859-2',
		   'hr_HR'		 => 'hr_HR.ISO8859-2',
		   'hr_HR.ISO8859-2'	 => 'hr_HR.ISO8859-2',
		   'it'			 => 'it_IT.ISO8859-1',
		   'it_IT'		 => 'it_IT.ISO8859-1',
		   'it_IT.ISO8859-1'	 => 'it_IT.ISO8859-1',
		   'ja'			 => 'ja_JP.eucJP',
		   'ja_JP'		 => 'ja_JP.eucJP',
		   'ja_JP.ujis'		 => 'ja_JP.eucJP',
		   'ja_JP.eucJP'	 => 'ja_JP.eucJP',
		   'ko'			 => 'ko_KR.eucKR',
		   'ko_KR'		 => 'ko_KR.eucKR',
		   'ko_KR.eucKR'	 => 'ko_KR.eucKR',
		   'nl'			 => 'nl_NL.ISO8859-1',
		   'nl_NL'		 => 'nl_NL.ISO8859-1',
		   'nl_NL.ISO8859-1'	 => 'nl_NL.ISO8859-1',
		   'pl'			 => 'pl_PL.ISO8859-2',
		   'pl_PL'		 => 'pl_PL.ISO8859-2',
		   'pl_PL.ISO8859-2'	 => 'pl_PL.ISO8859-2',
                   'pt'                  => 'pt_PT.ISO8859-1',
		   'pt_BR'               => 'pt_BR.ISO8859-1',
		   'pt_BR.ISO8859-1'     => 'pt_BR.ISO8859-1',
		   'pt_PT'               => 'pt_PT.ISO8859-1',
		   'pt_PT.ISO8859-1'     => 'pt_PT.ISO8859-1',
		   'ru'			 => 'ru_RU.KOI8-R',
		   'ru_RU'		 => 'ru_RU.KOI8-R',
		   'ru_RU.KOI8-R'	 => 'ru_RU.KOI8-R',
		   'sk'			 => 'sk_SK.ISO8859-2',
		   'sk_SK'		 => 'sk_SK.ISO8859-2',
		   'sk_SK.ISO8859-2'	 => 'sk_SK.ISO8859-2',
		   'zh_CN'		 => 'zh_CN.GB2312',
		   'zh_CN.GB2312'	 => 'zh_CN.GB2312',
		   'zh_TW'		 => 'zh_TW.Big5',
		   'zh_TW.Big5'		 => 'zh_TW.Big5',
		   'zh_HK'		 => 'zh_TW.Big5',
		   'zh_HK.Big5' 	 => 'zh_TW.Big5',
		   );

## ----------------------------------------------------------------------
## don't forget this
1;

## ----------------------------------------------------------------------
