<!-- ....................................................................... -->
<!-- XHTML 1.1 Basic Table Module  ......................................... -->
<!-- file: xhtml11-tableb-1.mod

     This module subsets XHTML 1.1, a modular variant of XHTML 1.0.
     Copyright 1998-1999 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: @(#)xhtml11-tableb-1.mod 1.6 99/08/26 SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

     PUBLIC "-//W3C//ELEMENTS XHTML 1.1 Basic Tables 1.0//EN"
     SYSTEM "xhtml11-tableb-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Basic Tables

        table, caption, tr, th, td

     This table module declares elements and attributes defining
     a table model based fundamentally on features found in the
     widely-deployed HTML 3.2 table model.  While this module
     mimics the content model and table attributes of HTML 3.2
     tables, the element types declared herein also includes all
     HTML 4.0 common and most of the HTML 4.0 table attributes.
-->

<!-- The border attribute sets the thickness of the frame
     around the table. The default units are screen pixels.
-->

<!-- horizontal alignment attributes for cell contents
-->
<!ENTITY % CellHAlign.attrib
     "align        ( left
                   | center
                   | right )                #IMPLIED"
>

<!-- vertical alignment attributes for cell contents
-->
<!ENTITY % CellVAlign.attrib
     "valign       ( top
                   | middle
                   | bottom )               #IMPLIED"
>

<!-- table: Table Element .............................. -->

<!ENTITY % Table.element  "INCLUDE" >
<![%Table.element;[
<!ENTITY % Table.content
     "( caption?, tr+ )"
>
<!ELEMENT table  %Table.content; >
<!-- end of Table.element -->]]>

<!ENTITY % Table.attlist  "INCLUDE" >
<![%Table.attlist;[
<!ATTLIST table
      %Common.attrib;
      width        %Length.datatype;        #IMPLIED
      border       %Pixels.datatype;        #IMPLIED
      cellspacing  %Length.datatype;        #IMPLIED
      cellpadding  %Length.datatype;        #IMPLIED
>
<!-- end of Table.attlist -->]]>

<!-- caption: Table Caption ............................ -->

<!ENTITY % Caption.element  "INCLUDE" >
<![%Caption.element;[
<!ENTITY % Caption.content
     "( #PCDATA | %Inline.mix; )*"
>
<!ELEMENT caption  %Caption.content; >
<!-- end of Caption.element -->]]>

<!ENTITY % Caption.attlist  "INCLUDE" >
<![%Caption.attlist;[
<!ENTITY % CaptionAlign.attrib
     "align        ( top | bottom )         #IMPLIED"
>

<!ATTLIST caption
      %Common.attrib;
      %CaptionAlign.attrib;
>
<!-- end of Caption.attlist -->]]>

<!-- tr: Table Row ..................................... -->

<!ENTITY % Tr.element  "INCLUDE" >
<![%Tr.element;[
<!ENTITY % Tr.content  "( th | td )+" >
<!ELEMENT tr  %Tr.content; >
<!-- end of Tr.element -->]]>

<!ENTITY % Tr.attlist  "INCLUDE" >
<![%Tr.attlist;[
<!ATTLIST tr
      %Common.attrib;
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>
<!-- end of Tr.attlist -->]]>

<!-- th: Table Header Cell ............................. -->

<!-- th is for header cells, td for data,
     but for cells acting as both use td
-->

<!ENTITY % Th.element  "INCLUDE" >
<![%Th.element;[
<!ENTITY % Th.content
     "( #PCDATA | %Flow.mix; )*"
>
<!ELEMENT th  %Th.content; >
<!-- end of Th.element -->]]>

<!ENTITY % Th.attlist  "INCLUDE" >
<![%Th.attlist;[
<!ATTLIST th
      %Common.attrib;
      abbr         %Text.datatype;          #IMPLIED
      axis         CDATA                    #IMPLIED
      headers      IDREFS                   #IMPLIED
      rowspan      %Number.datatype;        '1'
      colspan      %Number.datatype;        '1'
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>
<!-- end of Th.attlist -->]]>

<!-- td: Table Data Cell ............................... -->

<!ENTITY % Td.element  "INCLUDE" >
<![%Td.element;[
<!ENTITY % Td.content
     "( #PCDATA | %Flow.mix; )*"
>
<!ELEMENT td  %Td.content; >
<!-- end of Td.element -->]]>

<!ENTITY % Td.attlist  "INCLUDE" >
<![%Td.attlist;[
<!ATTLIST td
      %Common.attrib;
      abbr         %Text.datatype;          #IMPLIED
      axis         CDATA                    #IMPLIED
      headers      IDREFS                   #IMPLIED
      rowspan      %Number.datatype;        '1'
      colspan      %Number.datatype;        '1'
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>
<!-- end of Td.attlist -->]]>

<!-- end of xhtml11-tableb-1.mod -->
