/*  <PROJECT NAME>
 *  Copyright (C) <YEAR> <AUTHORS>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include "gladesig.h"
#include "gladesrc.h"

GtkWidget*
get_widget                             (GtkWidget       *widget,
                                        gchar           *widget_name)
{
  GtkWidget *found_widget;

  if (widget->parent)
    widget = gtk_widget_get_toplevel (widget);
  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

/* This is an internally used function to set notebook tab widgets. */
static void
set_notebook_tab                       (GtkWidget       *notebook,
                                        gint             page_num,
                                        GtkWidget       *widget)
{
  GtkNotebookPage *page;
  GtkWidget *notebook_page;
  
  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
  notebook_page = page->child;
  gtk_widget_ref (notebook_page);
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
                            widget, page_num);
  gtk_widget_unref (notebook_page);
}

GtkWidget*
create_winWordInspector ()
{
  GtkWidget *winWordInspector;
  GtkWidget *vbox2;
  GtkWidget *labelWord;
  GtkWidget *hseparator1;
  GtkWidget *scrolledwindow2;
  GtkWidget *hbox1;
  GtkWidget *labelDef;
  GtkWidget *alignment2;
  GtkWidget *vscrollbar2;
  GtkWidget *hseparator4;
  GtkWidget *buttonOK;

  winWordInspector = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (winWordInspector), "winWordInspector", winWordInspector);
  gtk_signal_connect (GTK_OBJECT (winWordInspector), "destroy",
                      GTK_SIGNAL_FUNC (do_delwindow),
                      NULL);
  gtk_window_set_title (GTK_WINDOW (winWordInspector), "Word Inspector");

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (winWordInspector), "vbox2", vbox2);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (winWordInspector), vbox2);
  gtk_widget_set_sensitive (vbox2, FALSE);

  labelWord = gtk_label_new ("Word Goes Here.");
  gtk_object_set_data (GTK_OBJECT (winWordInspector), "labelWord", labelWord);
  gtk_widget_show (labelWord);
  gtk_box_pack_start (GTK_BOX (vbox2), labelWord, FALSE, TRUE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (winWordInspector), "hseparator1", hseparator1);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator1, FALSE, TRUE, 0);
  gtk_widget_set_sensitive (hseparator1, FALSE);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (winWordInspector), "scrolledwindow2", scrolledwindow2);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (vbox2), scrolledwindow2, TRUE, TRUE, 0);
  gtk_widget_set_usize (scrolledwindow2, 450, 282);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (winWordInspector), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), hbox1);

  labelDef = gtk_text_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (winWordInspector), "labelDef", labelDef);
  gtk_widget_show (labelDef);
  gtk_box_pack_start (GTK_BOX (hbox1), labelDef, TRUE, TRUE, 0);
  gtk_signal_connect_after (GTK_OBJECT (labelDef), "button_press_event",
                            GTK_SIGNAL_FUNC (on_labelDef_button_release_event),
                            NULL);
  gtk_signal_connect (GTK_OBJECT (labelDef), "button_press_event",
                      GTK_SIGNAL_FUNC (on_labelDef_button_release_event_before),
                      NULL);

  alignment2 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_object_set_data (GTK_OBJECT (winWordInspector), "alignment2", alignment2);
  gtk_widget_show (alignment2);
  gtk_box_pack_start (GTK_BOX (hbox1), alignment2, FALSE, TRUE, 0);

  vscrollbar2 = gtk_vscrollbar_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 0, 0, 0, 0)));
  gtk_object_set_data (GTK_OBJECT (winWordInspector), "vscrollbar2", vscrollbar2);
  gtk_widget_show (vscrollbar2);
  gtk_container_add (GTK_CONTAINER (alignment2), vscrollbar2);

  hseparator4 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (winWordInspector), "hseparator4", hseparator4);
  gtk_widget_show (hseparator4);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator4, FALSE, FALSE, 0);

  buttonOK = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (winWordInspector), "buttonOK", buttonOK);
  gtk_widget_show (buttonOK);
  gtk_box_pack_start (GTK_BOX (vbox2), buttonOK, FALSE, FALSE, 0);
  gtk_widget_set_usize (buttonOK, 329, 38);
  GTK_WIDGET_SET_FLAGS (buttonOK, GTK_CAN_DEFAULT);
  gtk_widget_grab_focus (buttonOK);
  gtk_widget_grab_default (buttonOK);
  gtk_signal_connect_object (GTK_OBJECT (buttonOK), "clicked",
                             GTK_SIGNAL_FUNC (do_quit),
                             GTK_OBJECT (winWordInspector));

  return winWordInspector;
}

GtkWidget*
create_winWordFinder ()
{
  GtkWidget *winWordFinder;
  GtkWidget *vbox3;
  GtkWidget *table1;
  GtkWidget *entryWord;
  GtkWidget *label3;
  GtkWidget *buttonClose;
  GtkWidget *hseparator3;
  GtkWidget *label4;
  GtkWidget *buttonSearch;

  winWordFinder = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (winWordFinder), "winWordFinder", winWordFinder);
  gtk_signal_connect (GTK_OBJECT (winWordFinder), "destroy",
                      GTK_SIGNAL_FUNC (do_delwindow),
                      NULL);
  gtk_window_set_title (GTK_WINDOW (winWordFinder), "Word Finder");

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (winWordFinder), "vbox3", vbox3);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (winWordFinder), vbox3);
  gtk_widget_set_usize (vbox3, -1, 109);
  gtk_widget_set_sensitive (vbox3, FALSE);

  table1 = gtk_table_new (4, 3, FALSE);
  gtk_object_set_data (GTK_OBJECT (winWordFinder), "table1", table1);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox3), table1, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (table1, FALSE);

  entryWord = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (winWordFinder), "entryWord", entryWord);
  gtk_widget_show (entryWord);
  gtk_table_attach (GTK_TABLE (table1), entryWord, 1, 2, 1, 2,
                    GTK_SHRINK, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  GTK_WIDGET_SET_FLAGS (entryWord, GTK_CAN_DEFAULT);
  gtk_widget_grab_focus (entryWord);
  gtk_signal_connect (GTK_OBJECT (entryWord), "activate",
                      GTK_SIGNAL_FUNC (on_buttonSearch_clicked),
                      entryWord);

  label3 = gtk_label_new ("Search For...");
  gtk_object_set_data (GTK_OBJECT (winWordFinder), "label3", label3);
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table1), label3, 0, 3, 0, 1,
                    GTK_SHRINK | GTK_FILL, GTK_SHRINK, 0, 0);
  gtk_widget_set_usize (label3, 212, 21);
  gtk_widget_set_sensitive (label3, FALSE);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);

  buttonClose = gtk_button_new_with_label ("Close");
  gtk_object_set_data (GTK_OBJECT (winWordFinder), "buttonClose", buttonClose);
  gtk_widget_show (buttonClose);
  gtk_table_attach (GTK_TABLE (table1), buttonClose, 0, 3, 3, 4,
                    0, 0, 0, 0);
  gtk_widget_set_usize (buttonClose, 104, 29);
  gtk_signal_connect_object (GTK_OBJECT (buttonClose), "clicked",
                             GTK_SIGNAL_FUNC (do_quit),
                             GTK_OBJECT (winWordFinder));

  hseparator3 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (winWordFinder), "hseparator3", hseparator3);
  gtk_widget_show (hseparator3);
  gtk_table_attach (GTK_TABLE (table1), hseparator3, 0, 3, 2, 3,
                    GTK_EXPAND, GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (hseparator3, -1, 23);
  gtk_widget_set_sensitive (hseparator3, FALSE);

  label4 = gtk_label_new ("  ");
  gtk_object_set_data (GTK_OBJECT (winWordFinder), "label4", label4);
  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table1), label4, 0, 1, 1, 2,
                    GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_widget_set_usize (label4, 22, -1);
  gtk_widget_set_sensitive (label4, FALSE);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);

  buttonSearch = gtk_button_new_with_label ("Search");
  gtk_object_set_data (GTK_OBJECT (winWordFinder), "buttonSearch", buttonSearch);
  gtk_widget_show (buttonSearch);
  gtk_table_attach (GTK_TABLE (table1), buttonSearch, 2, 3, 1, 2,
                    GTK_EXPAND, GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (buttonSearch, 65, 33);
  GTK_WIDGET_SET_FLAGS (buttonSearch, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (buttonSearch);
  gtk_signal_connect (GTK_OBJECT (buttonSearch), "clicked",
                      GTK_SIGNAL_FUNC (on_buttonSearch_clicked),
                      entryWord);

  return winWordFinder;
}

