/*
  libc-extension.c --  compensate for lacking libc functions.

  source file of the flowerlib

  (c)  1997--1998 Han-Wen Nienhuys <hanwen@cs.uu.nl>
       Jan Nieuwenhuizen <janneke@gnu.org>
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "libc-extension.h"

#define DIRSEP '/'

#if ! HAVE_BASENAME
char*
basename (char const *name)
{
   char* p = strrchr (name, DIRSEP);
   if (p)
     name = p + 1;
   return (char*)name;
}

#endif

#if ! HAVE_DIRNAME
char*
dirname (char *name)
{
   char* p = strrchr (name, DIRSEP);
   if (p)
     *p = 0;
   else
     strcpy (name, ".");
   return name;
}
#endif

#if ! HAVE_SNPRINTF
int 
snprintf (char *str, size_t s, char const *format, ...)
{
  va_list ap;
  int i;
  (void)s;
  va_start (ap, format);
  i = vsprintf (str, format, ap);
  va_end (ap);
  return i;
}
#endif

#if ! HAVE_VSNPRINTF
int 
vsnprintf (char *str, size_t s, char const *format, va_list args)
{
  int i;
  (void)s;
  i = vsprintf (str, format, args);
  return i;
}
#endif

