#
# FILE:
# country.sql
#
# FUNCTION:
# Create and populate the country code & currency code table 
# of the Airports database.
#
# This table containsthe following fields:
#    country      -- The fully-qualified, properly capitalized
#                    name of the country.
#                    This name is currently in English only, and
#                    uses only the ASCII characterset. It 
#                    could/should be changed to unicode.
#
#    countrycode  -- The two-letter ISO standard country code.
#
#    currencycode -- The three-letter ISO standard currency code
#                    for the currency used in this country. 
#                    (This field is not currently used).
#
# NOTES:
# The codes, both for curency and for the countries, are the 
# official ISO standard codes, to the best of my knowledge.
#
# WARNING: 
# This script deletes the current database, replacing it
# with that below.
#
# HISTORY:
# Linas Vepstas March 1995
#

# kill old table
DROP TABLE countries
\g

# CREATE TABLE countries (
#    country char (100) NOT NULL,
#    countrycode char (2) PRIMARY KEY
#    currencycode char (3) 
# ) 
# \g

CREATE TABLE countries (
   country char (100) NOT NULL,
   countrycode char (2) NOT NULL,
   currencycode char (3) 
) 
\g

CREATE INDEX idxcntry ON countries (countrycode)
\g

# Missing Countries -- 
# Scotland 
# Wales
# Northern Ireland  Bali 
# West Indies is this the same as St. Lucia ???
# French Corsica -- is this the same as madagascar ???


INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Afghanistan', 'AF', 'AFA') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Albania', 'AL', 'ALL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Algeria', 'DZ', 'DZD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Andorra', 'AD', 'FRF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Angola', 'AO', 'AOR')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Anquilla', 'AI', 'XCD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Antarctica', 'AQ', 'USD')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Antigua and Barbuda', 'AG', 'XCD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Argentina', 'AR', 'ARS') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Armenia', 'AM', 'AMD')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Aruba', 'AW', 'AWG') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Australia', 'AU', 'AUD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Austria', 'AT', 'ATS') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Azerbaijan', 'AZ', 'AZM')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Bahamas', 'BS', 'BSD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Bahrain', 'BH', 'BHD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Bangladesh', 'BD', 'BDT') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Barbados', 'BB', 'BBD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Belarus', 'BY', 'BYB') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Belgium', 'BE', 'BEF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Belize', 'BZ', 'BZD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Benin', 'BJ', 'XOF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Bermuda', 'BM', 'BMD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Bhutan', 'BT', 'BTN') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Bolivia', 'BO', 'BOB') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Bosnia Herzegovina', 'BA', 'BAD')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Botswana', 'BW', 'BWP') 
\g

# hack missing currency code for BV
INSERT INTO countries
(country,  countrycode)
VALUES
('Bouvet Island', 'BV')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Brazil', 'BR', 'BRL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('British Indian Ocean Territory', 'IO', 'USD')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('British Virgin Islands', 'VG', 'USD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Brunei Darussalam', 'BN', 'BND') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Bulgaria', 'BG', 'BGL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Burkina Faso', 'BF', 'XOF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Burundi', 'BI', 'BIF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Kampuchea (Cambodia)', 'KH', 'KHR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Cameroon', 'CM', 'XAF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Canada', 'CA', 'CAD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Cape Verde Island', 'CV', 'CVE') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Cayman Islands', 'KY', 'KYD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Central African Republic', 'CF', 'XAF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Chad', 'TD', 'XAF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Chile', 'CL', 'CLP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('People\'s Republic of China', 'CN', 'CNY') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Christmas Island', 'CX', 'AUD')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Cocos (Keeling) Islands', 'CC', 'AUD')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Colombia', 'CO', 'COP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Comoros Islands', 'KM', 'KMF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Congo Republic', 'CG', 'XAF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Cook Islands South Pacific', 'CK', 'NZD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Costa Rica', 'CR', 'CRC') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Croatia (Hrvatska)', 'HR', 'HRK')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Cuba', 'CU', 'CUP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Netherlands Antilles --  Curacao Bonaire Saba St Eustatius St Martin', 'AN', 'ANG') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Cyprus', 'CY', 'CYP') 
\g

# hack missing currency code for CS
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Czechoslovakia (former)', 'CS', '') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Czech Republic', 'CZ', 'CZK')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Denmark', 'DK', 'DKK') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Djibouti', 'DJ', 'DJF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Dominica', 'DM', 'XCD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Dominican Republic', 'DO', 'DOP') 
\g

# hack missing currency code for DD
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('East Germany', 'DD', '') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Ecuador', 'EC', 'ECS') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Egypt', 'EG', 'EGP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('El Salvador', 'SV', 'SVC') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Equatorial Guinea', 'GQ', 'XAF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Eritrea', 'ER', 'ETB')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Estonia', 'EE', 'EEK')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Ethiopia', 'ET', 'ETB') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('European Corp', 'XE', 'XEU') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Faeroe Islands', 'FO', 'DKK')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Falkland Islands (Malvinas)', 'FK', 'FKP')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Federated States of Micronesia', 'FM', 'USD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Fiji', 'FJ', 'FJD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Finland', 'FI', 'FIM') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('France', 'FR', 'FRF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('French Guiana', 'GF', 'FRF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('French Polynesia', 'PF', 'XPF') 
\g

# hack missing currency code for TF
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('French Southern Territories', 'TF', '')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Gabon', 'GA', 'XAF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Gambia', 'GM', 'GMD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Georgia', 'GE', 'GEL')
\g

# hack missing currency code for GS
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('South Georgia and South Sandwich Islands', 'GS', '')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Germany', 'DE', 'DEM') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Ghana', 'GH', 'GHC') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Gibraltar', 'GI', 'GIP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Greece', 'GR', 'GRD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Greenland', 'GL', 'DKK') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Grenada', 'GD', 'XCD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Guadeloupe St. Barthelemy', 'GP', 'FRF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Guam', 'GU', 'USD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Guatemala', 'GT', 'GTQ') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Guinea', 'GN', 'GNF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Guinea Bissau', 'GW', 'GWP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Guyana', 'GY', 'GYD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Haiti', 'HT', 'HTG') 
\g

# hack missing currency code for HM
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Heard and McDonald Islands', 'HM', '')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Honduras', 'HN', 'HNL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Hong Kong', 'HK', 'HKD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Hungary', 'HU', 'HUF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Iceland', 'IS', 'ISK') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('India', 'IN', 'INR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Indonesia', 'ID', 'IDR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Iran', 'IR', 'IRR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Iraq', 'IQ', 'IQD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Republic of Ireland', 'IE', 'IEP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Israel', 'IL', 'ILS') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Italy', 'IT', 'ITL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Cote d\'Ivoire (Ivory Coast)', 'CI', 'XOF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Jamaica', 'JM', 'JMD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Japan', 'JP', 'JPY') 
\g

# hack missing currency code for JT
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Johnston Island', 'JT', '') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Jordan', 'JO', 'JOD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Kazakhstan', 'KZ', 'KZT')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Kenya', 'KE', 'KES') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Republic of Kiribati', 'KI', 'AUD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('North Korea', 'KP', 'KPW') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Republic of Korea (South Korea)', 'KR', 'KPW') 
\g

# hack missing currency code for PC
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Koror Kosrae Kwajalein Majuro Ponape Rota Saipan Tinian Truk Yap', 'PC', '')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Kuwait', 'KW', 'KWD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Kyrgyzstan', 'KG', 'KGS')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Laos', 'LA', 'LAK') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Latvia', 'LV', 'LVL')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Lebanon', 'LB', 'LBP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Lesotho', 'LS', 'LSL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Liberia', 'LR', 'LRD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Libya', 'LY', 'LYD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Liechtenstein', 'LI', 'CHF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Lietuva (Lithuania)', 'LT', 'LTL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Luxembourg', 'LU', 'LUF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Macao', 'MO', 'MOP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Macedonia', 'MK', 'MKD')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Malagasy (Madagascar)', 'MG', 'MGF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Malawa (Malawi)', 'MW', 'MWK') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Malaysia', 'MY', 'MYR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Maldive Island', 'MV', 'MVR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Mali', 'ML', 'XOF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Malta', 'MT', 'MTL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Marshall Islands', 'MH', 'USD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Martinique', 'MQ', 'FRF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Mauritania', 'MR', 'MRO') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Mauritius', 'MU', 'MUR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Mayotte', 'YT', 'FRF')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Mexico', 'MX', 'MXN') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Miquelon St. Pierre', 'PM', 'FRF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Republic of Moldova', 'MD', 'MDL')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Monaco', 'MC', 'FRF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Mongolia', 'MN', 'MNT') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Montserrat', 'MS', 'XCD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Morocco', 'MA', 'MAD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Mozambique', 'MZ', 'MZM') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Myanmar (Burma)', 'MM', 'MMK') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Namibia', 'NA', 'NAD')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Nauru', 'NR', 'AUD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Nepal', 'NP', 'NPR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Netherlands', 'NL', 'NLG') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Nevis and St. Kitts', 'KN', 'XCD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('New Caledonia', 'NC', 'XPF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('New Zealand (Aotearoa)', 'NZ', 'NZD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Nicaragua', 'NI', 'NIO') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Niger', 'NE', 'XOF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Nigeria', 'NG', 'NGN') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Niue', 'NU', 'NZD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Norfolk Island', 'NF', 'AUD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Northern Mariana Islands', 'MP', 'USD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Norway', 'NO', 'NOK') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Oman', 'OM', 'OMR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('U.S. Minor Outlying Pacific Islands', 'UM', 'USD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Pakistan', 'PK', 'PKR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Palau Islands', 'PW', 'USD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Panama', 'PA', 'PAB') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Papua New Guinea', 'PG', 'PGK') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Paraguay', 'PY', 'PYG')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Peru', 'PE', 'PES') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Philippines', 'PH', 'PHP') 
\g

# hack missing currency code for PN
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Pitcairn', 'PN', '')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Poland', 'PL', 'PLN') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Portugal', 'PT', 'PTE') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Puerto Rico', 'PR', 'USD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Qatar', 'QA', 'QAR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Reunion Island', 'RE', 'FRF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Romania', 'RO', 'ROL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Russian Federation Asia', 'XU', 'RUR')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Russian Federation Europe', 'RU', 'RUR')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Rwanda', 'RW', 'RWF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('American Samoa', 'AS', 'USD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Western Samoa', 'WS', 'WST') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('St. Helena', 'SH', 'SHP')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('San Marino', 'SM', 'ITL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Sao Tome and Principe', 'ST', 'STD')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Saudi Arabia', 'SA', 'SAR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Senegal', 'SN', 'XOF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Seychelles', 'SC', 'SCR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Sierra Leone', 'SL', 'SLL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Singapore', 'SG', 'SGD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Slovak Republic', 'SK', 'SKK')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Slovenia', 'SI', 'SIT')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Solomon Islands', 'SB', 'SBD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Somalia', 'SO', 'SOS') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('South Africa', 'ZA', 'ZAR') 
\g

# hack missing currency code for YD
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('South Yemen', 'YD', '') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Spain', 'ES', 'ESP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Sri Lanka', 'LK', 'LKR') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Saint Lucia', 'LC', 'XCD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Saint Vincent and the Grenadines', 'VC', 'XCD')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Sudan', 'SD', 'SDD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Suriname', 'SR', 'SRG') 
\g

# hack missing currency code for SJ
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Svalbard and Jan Mayen Islands', 'SJ', '')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Swaziland', 'SZ', 'SZL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Sweden', 'SE', 'SEK') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Switzerland', 'CH', 'CHF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Syria', 'SY', 'SYP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Taiwan', 'TW', 'TWD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Tajikistan', 'TJ', 'TJR')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Tanzania', 'TZ', 'TZS') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Thailand', 'TH', 'THB') 
\g

# hack missing currency code for TP
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('East Timor', 'TP', '')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Tobago and Trinidad', 'TT', 'TTD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Togo', 'TG', 'XOF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Tokeleu', 'TK', 'NZD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Tonga Island South Pacific', 'TO', 'TOP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Tunisia', 'TN', 'TND') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Turkey', 'TR', 'TRL') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Turkmenistan', 'TM', 'TMM')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Turks and Caicos Islands', 'TC', 'USD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Tuvalu Island', 'TV', 'AUD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Uganda', 'UG', 'UGX') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Ukraine', 'UA', 'UAH')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('United Kingdom', 'GB', 'GBP') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('United States of America', 'US', 'USD') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('United Arab Emirates', 'AE', 'AED') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('United Kingdom', 'UK', 'GBP')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Uruguay', 'UY', 'UYU') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Uzbekistan', 'UZ', 'UZS')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Virgin Islands (US)', 'VI', 'USD') 
\g

# hack missing currency code for SU
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('USSR (former)', 'SU', '') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Vanuatu', 'VU', 'VUV') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Vatican City State (Holy See)', 'VA', 'ITL')
\g

# hack alert -- old database, possibly corrupted, says venezuala is VF
# new database says VE so which is it? I think new is right, but ...
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Venezuela', 'VF', 'VEB') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Venezuela', 'VE', 'VEB') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Socialist Republic of Vietnam', 'VN', 'VND') 
\g

# hack alert -- old database says wallis is QF, new one says WF
# so which is it? (I think WF is right)
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Wallis and Futuna Islands', 'QF', 'XPF') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Wallis and Futuna Islands', 'WF', 'XPF') 
\g

# hack missing currency code for EH
INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Western Sahara', 'EH', '')
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Yemen Arab Republic', 'YE', 'YER') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Yugoslavia', 'YU', 'YUM') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Zaire', 'ZR', 'ZRN') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Zambia', 'ZM', 'ZMK') 
\g

INSERT INTO countries
(country,  countrycode, currencycode)
VALUES
('Zimbabwe', 'ZW', 'ZWD')
\g

# ------------------- end of file  -------------------------
