#include "gnc-helpers.h"

#include <g-wrap.h>
#include "gnc.h"
#include "Group.h"
#include "messages.h"


SCM
gnc_timespec2timepair(Timespec t) {
  SCM secs;
  SCM nsecs;

  /* secs should use gh_longlong2scm,
   * but that doesn't seem to be working */
  secs = gh_long2scm(t.tv_sec);
  nsecs = gh_long2scm(t.tv_nsec);
  return(gh_cons(secs, nsecs));
}

Timespec
gnc_timepair2timespec(SCM x) {
  Timespec result;

  /* secs should use gh_scm2longlong,
   * but that doesn't seem to be working */
  result.tv_sec = gh_scm2long(gh_car(x));
  result.tv_nsec = gh_scm2long(gh_cdr(x));
  return(result);
}

int
gnc_timepair_p(SCM x) {
  return(gh_pair_p(x) && gh_exact_p(gh_car(x)) && gh_exact_p(gh_cdr(x)));
}

Timespec
gnc_transaction_get_date_posted(Transaction *t) {
  Timespec result;
  xaccTransGetDateTS(t, &result);
  return(result);
}

Timespec
gnc_transaction_get_date_entered(Transaction *t) {
  Timespec result;
  xaccTransGetDateEnteredTS(t, &result);
  return(result);
}

Timespec
gnc_split_get_date_reconciled(Split *s) {
  Timespec result;
  xaccSplitGetDateReconciledTS(s, &result);
  return(result);
}

void
gnc_transaction_set_date_posted(Transaction *t, const Timespec d) {
  xaccTransSetDateTS(t, &d);
}

void
gnc_transaction_set_date_entered(Transaction *t, const Timespec d) {
  xaccTransSetDateEnteredTS(t, &d);
}

void
gnc_transaction_set_date(Transaction *t, Timespec ts)
{
  xaccTransSetDateTS(t, &ts);
}

char *
gnc_gettext_helper(const char *string)
{
  return _(string);
}

static int
gnc_scm_traversal_adapter(Transaction *t, void *data)
{
  POINTER_TOKEN pt;
  SCM scm_trans, result;
  SCM thunk = *((SCM *) data);

  pt = make_POINTER_TOKEN("Transaction*", t);
  scm_trans = POINTER_TOKEN_to_SCM(pt);

  result = gh_call1(thunk, scm_trans);

  if (result == SCM_BOOL_F)
    return(GNC_F);
  else
    return(GNC_T);
}

gncBoolean
gnc_scmGroupStagedTransactionTraversal(AccountGroup *grp,
                                       unsigned int new_marker,
                                       SCM thunk)
{
  return xaccGroupStagedTransactionTraversal(grp, new_marker,
                                             gnc_scm_traversal_adapter,
                                             &thunk);
}

gncBoolean
gnc_scmAccountStagedTransactionTraversal(Account *a,
                                         unsigned int new_marker,
                                         SCM thunk) 
{
  return xaccAccountStagedTransactionTraversal(a, new_marker,
					       gnc_scm_traversal_adapter,
                                               &thunk);
}
