/********************************************************************\
 * top-level.c -- top-level ui functions for gnucash                *
 * Copyright (C) 1997 Robin D. Clark                                *
 * Copyright (C) 1998,1999 Linas Vepstas                            *
 * Copyright (C) 1998 Rob Browning                                  *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
\********************************************************************/

#include <stdlib.h>

#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <X11/Xmu/Editres.h>
#include <assert.h>
#include <guile/gh.h>

#include "config.h"

#include "FileBox.h"
#include "Group.h"
#include "top-level.h"
#include "MainWindow.h"
#include "FileDialog.h"
#include "messages.h"
#include "Session.h"
#include "TransLog.h"
#include "Destroy.h"
#include "util.h"

/** PROTOTYPES ******************************************************/

/** GLOBALS *********************************************************/

/* This static indicates the debugging module that this .o belongs to.  */
static short module = MOD_GUI;

int  realized = False;   /* Has the toplevel been realized? */

XtAppContext app;

static gncUIWidget ui_data = NULL;

static int motif_is_running = False;
static int motif_is_terminating = False;
static int motif_is_initialized = False;

int
gnucash_ui_is_running() {
  return motif_is_running;
}

int
gnucash_ui_is_terminating() {
  return motif_is_terminating;
}

gncUIWidget 
gnc_get_ui_data (void) 
{
  return(ui_data);
}

void
gnc_ui_destroy_all_subwindows (void)
{
  xaccGroupWindowDestroy(gncGetCurrentGroup());
}

void
gnc_ui_shutdown (void) 
{
  ENTER ("gnucash_ui_shutdown\n");

  if (motif_is_running && !motif_is_terminating) {
    motif_is_terminating = True;
    gnc_ui_destroy_all_subwindows();
    XtUnrealizeWidget(ui_data);

    while (XtAppPending(app) & XtIMXEvent)
      XtAppProcessEvent(app, XtIMXEvent);
  }
  LEAVE ("gnucash_ui_shutdown\n");
}

void gnc_ui_destroy (void)
{
  ENTER ("gnucash_ui_destroy\n");
  if (!motif_is_initialized)
    return;

  if (ui_data != NULL) {
    XtDestroyWidget(ui_data);
    ui_data = NULL;
  }

  if (app) {
    XtDestroyApplicationContext(app);
    app = NULL;
  }
  LEAVE ("gnucash_ui_destroy\n");
}

/** FALLBACK RESOURCES **********************************************/
/* NOTE: These will eventually be moved out into a site-default file,
 *       but default-resources are here for now, for convenience */
String fbRes[] = {
  "*Foreground:               black",
  "*Background:               grey",
  "*fontList:                 -*-helvetica-bold-r-normal--*-120-*-*-*-*-*-*",
  "*text.fontList:            -*-helvetica-medium-r-normal--*-100-*-*-*-*-*-*",
  /* Help stuff" */
  "*help*geometry:            530x480-0-0",
/*  "*help*View*Background:     #ffffff",  */
  /* MenuBar stuff: */
  "*menubar*marginHeight:     1",
  "*menubar*marginWidth:      1",

  /* Register window account type specific stuff: */ 
  "*regbank.oddRowBackground:      #aaccff",
  "*regcash.oddRowBackground:      #ccffcc",
  "*regasset.oddRowBackground:     #aaffcc",
  "*regcredit.oddRowBackground:    #ffffaa",
  "*regliability.oddRowBackground: #ffcccc",
  "*ledportfolio.oddRowBackground: #ccffff",
  "*regmutual.oddRowBackground:    #ccffff",
  "*regincome.oddRowBackground:    #aaccff",
  "*regexpense.oddRowBackground:   #ffcccc",
  "*regequity.oddRowBackground:    #ffffaa",
  "*ledgportfolio.evenRowBackground:grey",
  "*regmutual.evenRowBackground:   grey",

  /* Other register window account stuff: */
  "*reg*fontList:            -*-helvetica-medium-r-normal--*-100-*-*-*-*-*-*",
  "*reg*evenRowBackground:   white",
  "*reg*shadowType:          SHADOW_IN",
  "*reg*shadowThickness:     1",
  "*reg*cellShadowThickness: 1",
  "*reg*cellShadowType:      SHADOW_IN",
  "*reg*cellMarginWidth:     1",
  "*reg*cellMarginHeight:    0",

  /* Reconcile window matrices stuff: */
  "*recn*fontList:            -*-helvetica-medium-r-normal--*-100-*-*-*-*-*-*",
  "*recn*.oddRowBackground:   white",
  "*recn*.evenRowBackground:  white",
  "*recn*shadowType:          SHADOW_ETCHED_IN",
  "*recn*shadowThickness:     1",
  "*recn*cellShadowThickness: 1",
  "*recn*cellShadowType:      SHADOW_ETCHED_IN",
  "*recn*cellMarginWidth:     0",
  "*recn*cellMarginHeight:    0",

  /* combobox -- don't want the cell to be outlined */
  "*reg*combocell*shadowThickness:     0",
  "*reg*combocell*list*shadowThickness:     1",  /* we *do* want the combobox scroll bar to show, thoguh */
  "*reg*combocell*list*thickness:     24",  /* slider width ignored ... why ??? */
  "*reg*combocell*list*VertScrollBar*width:     24",  /* slider width ignored ... why ??? */
  "*reg*combocell*list*troughColor:    #9999aa",  /* ignored -- why ???*/

  /* generic buttons  -- make sure that hitting enter does what you want */
  // its broken, I don't know why, what a hassle 
  //  "*Ok*baseTranslations:                     \n"
  // "       <Key>Return:  ArmAndActivate() \n"
  // "       <Key>y:  ArmAndActivate() ",
  NULL,
  };


/* These gnucash_lowlev and gnucash_ui functions are just hacks to get
   the guile stuff up and running.  Expect a more formal definition of
   what they should do soo, and expect that the open/select functions
   will be merged with the code in FMB_OPEN in MainWindow.c */

int
gnucash_ui_init()
{
  int fake_argc = 1;
  char *fake_argv[] = {"gnucash"};

  ENTER ("gnucash_ui_init\n");

  /* We're going to have to have other ways to handle X and GUI
     specific args... */

  if (!motif_is_initialized) {
    ui_data = XtVaOpenApplication( &app, "GnuCash", NULL, 0,
				   &fake_argc, fake_argv, fbRes,
				   topLevelShellWidgetClass,
				   NULL );

    XtAddEventHandler( ui_data, (EventMask) 0, True,
		       _XEditResCheckMessages, NULL );

    /* Make main window */
    mainWindow();

    motif_is_initialized = True;
  }

  LEAVE ("gnucash_ui_init\n");

  return 0;
}
  

int
gnc_ui_main()
{
  XEvent event;

  /* Initialize motif */
  gnucash_ui_init();

  /* Draw toplevel */
  assert (ui_data);
  gnc_refresh_main_window();
  XtRealizeWidget(ui_data);
  realized = TRUE;

  motif_is_running = True;

  XtAppLock(app);

  while (!motif_is_terminating) {
    XtAppNextEvent(app, &event);
    XtDispatchEvent(&event);
  }

  XtAppUnlock(app);

  motif_is_running = False;
  motif_is_terminating = False;

  return 0;
}

/* hack alert -- all we do below is rename some functions ... fix this someday */

int
gnucash_ui_open_file(const char datafile[]) 
{
  gncFileOpenFile (datafile);
  return (1);
}
  
int
gnucash_ui_select_file() 
{
  gncFileOpen();
  return (1);
}

/* ============================= END OF FILE ============================= */
