/*
  KON - Kanji ON Linux Console -
  Copyright (C) 1992, 1993 Takashi MANABE (manabe@tut.ac.jp)
  
  KON is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  KON is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  */

#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<sys/types.h>
#include	<sys/file.h>
#include	<string.h>
#include	<ctype.h>
#include	<sys/ipc.h>
#include	<sys/shm.h>
#include	<sys/socket.h>
#include	<errno.h>

#include	<interface.h>
#include	<fnld.h>

unsigned char *LoadFontFile();

extern struct fontInfo fi;

void
main(argc, argv)
int argc;
char *argv[];
{
    int i, n;
    FILE *fp = stdin;
    enum {ST_ARG, ST_UNLOAD, ST_TYPE} st=ST_ARG;
    char *path, *type, *p;
    u_char *font;
    int forceLoad=1;

    path = NULL;
    if ((p = index(argv[0], '.')) != NULL) type = p + 1;
    for (i = 1; i < argc; i ++) {
	p = argv[i];
	switch(st) {
	case ST_UNLOAD:
	    if (isxdigit(*p)) {
		sscanf(p, "%X", &n);
		fprintf(stderr, "%s> unload %X(%s)\n", argv[0], n,
			(n & CHR_DBC) ?
			fDRegs[n&~CHR_DFLD].registry:
			fSRegs[n&~CHR_SFLD].registry);
		UnloadShmem(n | CHR_SFLD);
		break;
	    }
	    st = ST_ARG;
	case ST_ARG:
	    if (*p == '-') {
		++p;
		switch(*p) {
		case 'n':
		    forceLoad = 0;
		    break;
		case 'u':
		    st = ST_UNLOAD;
		    break;
		case 't':
		    st = ST_TYPE;
		    break;
		case 'i':
		    ShowFont();
		    exit(0);
		    break;
		}
	    } else path = argv[i];
	    break;
	case ST_TYPE:
	    type = p;
	    st = ST_ARG;
	    break;
	}
    }
    if (st == ST_UNLOAD) exit(0);

    font = LoadFontFile(path, type, forceLoad);

    if (font == NULL) {
	fprintf(stderr, "%s> Can not load font.\n", argv[0]);
	exit(EOF);
    }
    if (fp != stdin) fclose(fp);
    exit(SetFont(argv[0], font, &fi));
}
