/* # skkinput (Simple Kana-Kanji Input)
 * skksvect.c --- 
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>

#include "skkmain.h"
#include "skksvect.h"

/*
 * Хѿ
 */
static VectorIndex *vNodeHashTable[ VNODEHASHSIZE ] ;

/*
 * ץȥ
 */
static int isExistVectorIndexNode( SkkinpSearchVector *sNode, int pos,
				   int length ) ;
static int add_VectorHashTable( SkkinpSearchVector *sNode, int pos,
				int length ) ;
static void clearVectorHashTable( void ) ;

int cmpCandidate( SkkinpSearchVector *sNode1, int pos1, int len1,
		  SkkinpSearchVector *sNode2, int pos2, int len2 ) ;

/*
 * ꥹȤޤ뤴Ȳؿ
 */
void free_SkkinpSearchVector( SkkinpSearchVector **top )
{
  SkkinpSearchVector *node, *nNode ;

  node = *top ;
  while( node != NULL ){
    nNode = node->next ;
    free( node ) ;
    node  = nNode ;
  }
  *top = NULL ;
  return ;
}

/*
 * ΡɤѤݤؿ
 */
SkkinpSearchVector *makeNewSkkinpSearchVectorNode( void )
{
  SkkinpSearchVector *node ;
  node = ( SkkinpSearchVector *)malloc( sizeof( SkkinpSearchVector ) ) ;
  node->next = NULL ;

  if( node == NULL ){
    fprintf( stderr, "FATAL : Memory exhausted.\n" ) ;
    exit( 1 ) ;
  }
  /* äȤ򤹤롣*/
  node->used = 0 ;
  node->next = NULL ;
  node->text[ 0 ] = '\0' ;
  return node ;
}

/*
 * Search Vector ˿Ρɤդäؿ
 */
SkkinpSearchVector *add_SkkinpSearchVector
( SkkinpSearchVector *topp,  char *str,
  SkkinpSearchVector **rnode, int *pos )
{
  SkkinpSearchVector *node ;
  int length = strlen( str ), overlen ;

  /* Ƭ NULL äˤƬݤ롣*/
  if( topp == NULL ){
    topp = node = makeNewSkkinpSearchVectorNode() ;
  } else {
    node = topp ;
    /* ֺǸΥΡɤդ롣*/
    while( node->next != NULL )
      node = node->next ;
  }
  if( rnode != NULL )
    *rnode = node ;
  if( pos != NULL )
    *pos = node->used ;
  /* դäʸ󤬶ǤʤΤʤġ*/
  while( length > 0 ){
    if( node->used < TEXTMAXLEN ){
      /* ХåեκǸդä롣*/
      strncat( node->text, str, TEXTMAXLEN - node->used ) ;
    }
    /* ХåեʸȤƽü롣*/
    node->text[ TEXTMAXLEN ] = '\0' ;
    /* Хåեդ褦ʻ֤ȯΤɤǧ롣*/
    overlen = node->used + length - TEXTMAXLEN ;
    if( overlen > 0 ){
      /* copyˤʤʸγϰ֤򤺤餹ĥХŦ by sigoto */
      str       += TEXTMAXLEN - node->used ;
      /* ΥΡɤϺǸޤǻȤäȡ*/
      node->used = TEXTMAXLEN ;
      /* 줬ĤäƤʸȡ*/
      length     = overlen ;
      /* դƤΤʤ顢Хåեݤ롣*/
      node->next = makeNewSkkinpSearchVectorNode() ;
      /* ݤۤϻѤƤʤΤǡޤä顣*/
      node = node->next ;
      node->used = 0 ;
    } else {
      /* դƤʤСʾʸäɬפʤΤǡ*
       * 롼פȴ롣*/
      node->used += length ;
      length     = 0 ;
      break ;
    }
  }
  return topp ;
}
/*
*/
/*
 * ѴΥǥåѤƤؿ
 */
void free_VectorIndex( VectorIndex **top )
{
  VectorIndex *node, *nNode ;
  node = *top ;
  while( node != NULL ){
    nNode = node->next ;
    free( node ) ;
    node  = nNode ;
  }
  *top = NULL ;
  return ;
}

/*
 * ΡɤѤݤؿ
 */
VectorIndex *alloc_NewVectorIndexNode( void )
{
  VectorIndex *node = ( VectorIndex * )malloc( sizeof( VectorIndex ) ) ;
  node->next = NULL ;

  if( node == NULL ){
    fprintf( stderr, "FATAL : Memory exhausted.\n" ) ;
    exit( 1 ) ;
  }
  return node ;
}

/*
 * ѴΥǥåؿ
 * ----
 * Ф֤äΤϤʸʤΤǡڤФƴɬ
 * 롣
 */
static VectorIndex *add_vectorIndexNode
( VectorIndex *vitop, SkkinpSearchVector *sNode,
  int pos, int length, int *number_of_candidates )
{
  VectorIndex *vNode, *vNodeNxt ;

  /* Ʊʸ¸ߤ뤫ɤȽꤹ롣*/
  if( isExistVectorIndexNode( sNode, pos, length ) )
    /* ƱʸȤ¸ߤƤΤǡϼΤƤ롣*/
    return vitop ;

  /* ϥå˲ä롣*/
  add_VectorHashTable( sNode, pos, length ) ;

  /* ΡɤΰƬ뤫̵򸫤롣*/
  if( vitop == NULL ){
    /* ΡɤΰƬ̵ä硣*/
    vitop = vNode = alloc_NewVectorIndexNode() ;
    vNode->prev = NULL ;
    vNode->next = NULL ;
  } else {
    vNode = vitop ;
    /* ǤʤäˤϡꥹȤΰֺǸܤ*/
    while( vNode->next != NULL )
      vNode = vNode->next ;
    /* ֺǸΥΡɤդˤϡ */
    vNodeNxt       = alloc_NewVectorIndexNode() ;
    vNodeNxt->next = NULL ;
    vNodeNxt->prev = vNode ;
    vNode->next    = vNodeNxt ;
    vNode          = vNodeNxt ;
  }
  /* ȤƤ SkkInputVector*/
  vNode->node     = sNode ;
  vNode->next     = NULL ;
  /* ȤƤʸĹ*/
  vNode->length   = length ;
  /* SkkInputVector->text Ǥΰ֡*/
  vNode->position = pos ;
  /* ȯο1䤹*/
  ++ *number_of_candidates ;
  return vitop ;
}

/*
 * Search Vector ʸڤФѤؿ
 * ----
 * ѴθΤѤ롣
 */
VectorIndex *makeSearchVectorIndex
( SkkinpSearchVector *top, int *totalnum, int flag )
{
  int doubleQuoteCheck, slashCheck ;
  int pPos, pos, count, i, number_of_candidates ;
  SkkinpSearchVector *node, *pNode ;
  VectorIndex *vitop = NULL ;
  char *ptr ;

  /* ǥåνΤѤɽѿν*/
  pPos  = 1 ;
  pos   = 1 ;		/* ϰֺǽΰ֤ˤϡ뤿ᡣ*/
  pNode = node  = top ;
  ptr   = node->text + pos ;	/* ϰֺǽΰ֤ˤϡ뤿ᡣ*/
  count = 0 ;
  doubleQuoteCheck = False ;
  slashCheck       = 0 ;
  number_of_candidates = 0 ;
  
  /* ǥå롣*/
  for( i = 0 ; i < TEXTMAXLEN ; i ++ ){
    /* ֥륯Ȥ̵뤹򤳤ǳǧ롣*/
    if( *ptr == '\\' ){
      slashCheck = 2 ;
    }
    /* Double Quote δ֤ա*/
    if( *ptr == 0x22 && slashCheck > 0 ){
      /* Ƥ Double Quote ȤȤϡconcat ľǤȽ *
       * 롣ǡ򳫻ϰ֤ˤƤޤ                  */
      if( doubleQuoteCheck == False ){
	pPos  = pos ;
	pNode = node ;
	count = 0 ;
	doubleQuoteCheck = True ;
      } else {
	doubleQuoteCheck = False ;
      }
      /* ֤ΰư*/
      ptr   ++ ;
      pos   ++ ;
      count ++ ;
      continue ;
    }
    /* ʳʸä顢ǽ뤳Ȥˤʤ롣*/
    switch( *ptr ){
      /* ϸȸδ֤ɬ¸ߤ롣*/
    case '/' :
      /* ΡɤĲä롣*/
      if( pPos < pos ){
	vitop = add_vectorIndexNode
	  ( vitop, pNode, pPos, count, &number_of_candidates ) ;
      }
      /* ڤӡݥ󥿤䤹*/
      ptr ++ ;
      pos ++ ;
      /* (Ĥޤ꺣ξ)"/" դ pPos ˵롣*/
      pPos  = pos ;
      /* ΥΡɤ򵭲Ƥ*/
      pNode = node ;
      count = 0 ;
      break ;
      /* ʸνüդƤޤäν*/
    case '\n' :
    case '\r' :
    case '\0' :
      node = node->next ;
      if( node == NULL )
	goto ex_makeindex ;
      /* ʸХåեɤߤ˹Ԥ*/
      ptr = node->text ;
      pos = 0 ;
      i   = 0 ;
      break ;
    default :
      /* ʳʸϲؤ¹Ԥ롣*/
      ptr ++ ;
      count ++ ;
      pos ++ ;
      if( slashCheck > 0 )
	slashCheck -- ;
      break ;
    }
  }
ex_makeindex:
  *totalnum = number_of_candidates ;
  /* ϥåϥꥢƤΡ */
  if( flag )
    /* Ѥϥåơ֥򥯥ꥢ롣*/
    clearVectorHashTable() ;
  return vitop ;
}

/*
 * Search Vector ʸڤФѤؿ
 * ----
 * ѴθΤѤ롣
 */
int copyCandidate
( char *dest, SkkinpSearchVector *sNode, int position, int length )
{
  int count ;
  char *sptr ;

  sptr = sNode->text +position ;

  /* concat ̵뤵פȤޤ*/
  if( *sptr == 0x22 )
    return 0 ;

  /* ʳʤ麣ϤʤȤʤ褦Ǥޤ*/
  count = 0 ;
  while( count < length ){
    switch( *sptr ){
    case '/' :
      *dest = '\0' ;
      return count ;
    case '\0' :
      sNode = sNode->next ;
      if( sNode == NULL ){
	*dest = '\0' ;
	return count ;
      }
      sptr = sNode->text ;
      break ;
    default :
      *dest ++ = *sptr ++ ;
      count ++ ;
    }
  }
  *dest = '\0' ;
  return count ;
}

/*
 * ϥåơ֥ؿưɬٸƤ֤ȡ
 */
void initVectorHashTable( void )
{
  int i ;
  /* ϥåơ֥ NULL ǽ롣*/
  for( i = 0 ; i < VNODEHASHSIZE ; i ++ )
    vNodeHashTable[ i ] = NULL ;
  return ;
}

static void clearVectorHashTableSub( VectorIndex *node )
{
  /* λҶƤġ*/
  if( node->prev != NULL ){
    clearVectorHashTableSub( node->prev ) ;
    node->prev = NULL ;
  }
  if( node->next != NULL ){
    clearVectorHashTableSub( node->next ) ;
    node->next = NULL ;
  }
  node->node = NULL ;
  node->position = 0 ;
  node->length = 0 ;
  /* ʬȤơĽλ롣*/
  free( node ) ;
  return ;
}

/*
 * ϥåơ֥öؿ
 *-----
 * Ѵλ٤˸ƤФɬפ뤬ġϷ빽ʥȤˤʤ
 * Ȼפ
 */
static void clearVectorHashTable( void )
{
  int i ;
  /* ϥåơ֥˸롣*/
  for( i = 0 ; i < VNODEHASHSIZE ; i ++ ){
    if( vNodeHashTable[ i ] == NULL )
      continue ;
    clearVectorHashTableSub( vNodeHashTable[ i ] ) ;
    vNodeHashTable[ i ] = NULL ;
  }
  return ;
}

/*
 * skkinpsearchvector ĤθӤؿ
 *----
 * strcmp  skkinpsearchvector ξˤΤΤȻפäƲ
 */
int cmpCandidate( SkkinpSearchVector *sNode1, int pos1, int len1,
		  SkkinpSearchVector *sNode2, int pos2, int len2 )
{
  int i, ret, len ;
  char *ptr1, *ptr2 ;

  /* Ĺ⡢û롼פ뤳Ȥˤʤ롣Ĺ㤦ä * 
   * Ƥɬ̵ĤȤ줽 Tree Search ɬ  *
   * פʤΡ*/
  len = ( len1 < len2 )? len1 : len2 ;

  /* ӳϰ֡*/
  ptr1 = sNode1->text + pos1 ;
  ptr2 = sNode2->text + pos2 ;

  for( i = 0 ; i < len ; i ++ ){
    /* ХåեκǸޤƤޤäˤϡΥΡɤ򸫤롣*/
    if( *ptr1 == '\0' ){
      if( sNode1->next != NULL ){
	sNode1 = sNode1->next ;
      } else {
	/* Хåեμ򸫤褦ˤ⡢⤦Ǥߤġȡ *
	 * ʸ¸ߤʤȤȤˤʤ롣ǡ̤Ф *
	 * ʤȤʤȡĤĤޤ i == len ˤʤäƤʤȤ *
	 * ϡϤޤޤ³ȤȤ顢֤ͤξ *
	 * */
	return (-1) ;
      }
      ptr1 = sNode1->text ;
    }
    /* ХåեκǸޤƤޤäˤϡΥΡɤ򸫤롣*/
    if( *ptr2 == '\0' ){
      if( sNode2->next != NULL ){
	sNode2 = sNode2->next ;
      } else {
	/* Хåեμ򸫤褦ˤ⡢⤦Ǥߤġȡ *
	 * ʸ¸ߤʤȤȤˤʤ롣ǡ̤Ф *
	 * ʤȤʤȡĤĤޤ i == len ˤʤäƤʤȤ *
	 * ϡϤޤޤ³ȤȤ顢֤ͤξ *
	 * */
	return 1 ;
      }
      ptr2 = sNode2->text ;
    }
    /* κ롣*/
    if( ( ret = *ptr1 - *ptr2 ) )
      return ret ;
    /* θܤ*/
    ptr1 ++ ;
    ptr2 ++ ;
  }
  /* ʬ꤬Ʊʸä顢ɤ͡*/
  if( len1 == len2 )
    return 0 ;
  /* ʬĹäƤȤϡʬ礭Ρ*/
  if( len1 > len2 )
    return 1 ;
  /* ʬûä顢ʬΡ*/
  return (-1) ;
}

/*
 * ϥåơ֥ʬڤ˸äؿ
 */
static int add_VectorHashTable( SkkinpSearchVector *sNode, int pos,
				int length )
{
  int num = VHASHFUNCTION( sNode, pos ) ;
  VectorIndex *vNode = vNodeHashTable[ num ] ;

  /* ʸ¸ߤʤä*/
  if( vNode == NULL ){
    /* ΡɤΰƬ̵ä硣*/
    vNodeHashTable[ num ] = vNode = alloc_NewVectorIndexNode() ;

  } else {
    /* ˲餫θ䤬¸ߤƤġ*/
    while( 1 ){
      num = cmpCandidate( vNode->node, vNode->position, vNode->length,
			  sNode, pos, length ) ;
#ifdef DEBUG
      /* ޤƱΤȤϻפʤĤä顢顼*/
      if( num == 0 ){
	fprintf( stderr, "Warning : You're adding the same node to hash\
table.\n" ) ; 
	return 1 ;
      }
#endif
      /* ̤򸫤롣*/
      if( num < 0 ){
	/* ϡλҶ򸫤ʤȤʤ*/
	if( vNode->next == NULL ){
	  /* λҶʤä顢زä롣*/
	  vNode->next = alloc_NewVectorIndexNode() ;
	  vNode = vNode->next ;
	  break ;
	} else {
	  /* λҶ顢λҶĴ٤롣*/
	  vNode = vNode->next ;
	}
      } else {
	/* ϡλҶ򸫤ʤȤʤ*/
	if( vNode->prev == NULL ){
	  /* λҶʤä顢زä롣*/
	  vNode->prev = alloc_NewVectorIndexNode() ;
	  vNode = vNode->prev ;
	  break ;
	} else {
	  /* λҶ顢λҶĴ٤롣*/
	  vNode = vNode->prev ;
	}
      }
    }
  }
  /* ɬդäѤˤäĤΤǡҶϤʤ*/
  vNode->next = vNode->prev = NULL ;
  /* ¾ξղä롣*/
  vNode->node     = sNode ;
  vNode->position = pos ;
  vNode->length   = length ;
  return 0 ;
}

/*
 * ϥåơ֥Ĵ٤ơ˸䤬¸ߤƤ뤫ɤå
 * ؿ
 */
static int isExistVectorIndexNode( SkkinpSearchVector *sNode, int pos,
				   int length )
{
  int ret ;
  VectorIndex *vNode =
    vNodeHashTable[ VHASHFUNCTION( sNode, pos ) ] ;
  /* ʸ¸ߤʤä*/
  if( vNode == NULL )
    return False ;
  /* ϥåؿˤ֤餵ꥹȤ򸡺롣*/
  while( vNode != NULL ){
    ret = cmpCandidate( vNode->node, vNode->position, vNode->length,
			sNode, pos, length ) ;
    /* Ʊθ䤬¸ߤ*/
    if( ret == 0 )
      return True ;
    /* ʬڤˤʤäƤΤǡ̤򸫤ƻޤΤɤĴ٤롣*/
    if( ret < 0 ){
      /* 󸡺褦ȤƤϿƤ *
       * ʸɤ礭硣*/
      vNode = vNode->next ;
    } else {
      /* 󸡺褦ȤƤϿƤ *
       * ʸɤ硣*/
      vNode = vNode->prev ;
    }
  }
  return False ;
}

#ifdef DEBUG
void dump_skkinpSearchVector( SkkinpSearchVector *node )
{
  while( node != NULL ){
    printf( "%s\n", node->text ) ;
    node = node->next ;
  }
  return ;
}
#endif
