;;; tc-mazegaki.el --- mazegaki henkan in T-Code

;; Copyright (C) 1996--1999 Kaoru Maeda, Yasushi Saito and KITAJIMA Akira.

;; Author: Kaoru Maeda <maeda@src.ricoh.co.jp>
;;	Yasushi Saito <yasushi@is.s.u-tokyo.ac.jp>
;;	KITAJIMA Akira <kitajima@ics.es.osaka-u.ac.jp>
;; Maintainer: KITAJIMA Akira <kitajima@ics.es.osaka-u.ac.jp>
;; Created: 30 Apr 1996
;; Version: $Id: tc-mazegaki.el,v 2.0.6.1 1999/09/27 14:39:01 akira Exp $
;; Keywords: wp

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.

;;; Code:

(require 'tc)
(require 'tc-sysdep)

(defgroup mazegaki-henkan nil
  "򤼽Ѵ"
  :group 'tcode)

;;; ޥǤѿ

(defvar tcode-mazegaki-reverse-yomi-jisho nil
  "* ɤߤΤޤޤθʤ nilոʤ nil ʳˤ롣")
(defvar tcode-mazegaki-dictionary-name
  (concat tcode-data-directory "mazegaki"
	  (if tcode-mazegaki-reverse-yomi-jisho ".rev" ".dic"))
  "* 򤼽ѴΥѥ̾")
(defvar tcode-mazegaki-dictionary-backup-name
  (concat tcode-mazegaki-dictionary-name ".BAK")
  "* 򤼽ѴΥХååץեΥѥ̾
nil ʤХååפʤ")

(defcustom tcode-mazegaki-yomi-max 10 "* 򤼽Ѵɤߤκʸ"
  :group 'mazegaki-henkan)

(defvar tcode-mazegaki-terminate-char-list
  (mapcar (function (lambda (ch) (tcode-string-to-char ch)))
	  '("" "" "" "" "" "" "" "" ""))
  "* 򤼽Ѵɤߤ˴ޤޤʤ2ХʸΥꥹȡ")

(defcustom tcode-mazegaki-init-hook nil
  "* ǽ tc-mazegaki.el ɤȤ˸ƤФ hook"
  :type 'hook :group 'mazegaki-henkan)

(defvar tcode-mazegaki-command-summary-alist
  '(("̤" . tcode-mazegaki-relimit-left)
    ("Ф" . tcode-mazegaki-relimit-right)
    (""   . tcode-mazegaki-kakutei)
    ("᤹"   . tcode-mazegaki-restore-yomi-and-quit)
    ("ɽޤϽ̤" . tcode-mazegaki-select-kouho-or-relimit)
    ("Ͽ&" . tcode-mazegaki-toroku-and-kakutei))
  "* `tcode-mazegaki-command-summary' ɽ뵡ǽ alist")

(defvar tcode-mazegaki-enable-variable-yomi-postfix t
  "* nil ǤʤȤѸѴǤ롣")

(defvar tcode-mazegaki-prefix-mark
  (if (or (tcode-nemacs-p)
	  (tcode-mule-1-p)
	  (and (boundp 'window-system)
	       (not window-system)))
      ""
    (prog1
	(make-face 'mazegaki-henkan)
      (set-face-underline-p 'mazegaki-henkan t)))
  "* 򤼽Ѵλɽ뤷
ʸʸޤ face (mule2 ʾޤ XEmacs ξΤͭ)
ʤФʤʤ")

(defvar tcode-mazegaki-priority-list
; 
;  0  1  2  3  4    5  6  7  8  9
; 10 11 12 13 14   15 16 17 18 19
; 20 21 22 23 24   25 26 27 28 29
; 30 31 32 33 34   35 36 37 38 39
  '(27 22 26 23 28 21 25 24 29 20
    17 12 16 13 18 11 15 14 19 10
    37 32 36 33 38 31 35 34 39 30)
  "* ¤٤Ȥΰ֡
ΥꥹȤˤʤϻѤʤ")

(defvar tcode-mazegaki-alternative-select-left-keys
  '(10 11 12 13 14
    20 21 22 23 24
    30 31 32 33 34)
  "* 2Ĥ椫1־Ρ¦֥Υꥹȡ")
(defvar tcode-mazegaki-alternative-select-right-keys
  '(15 16 17 18 19
    25 26 27 28 29
    35 36 37 38 39)
  "* 2Ĥ椫1־Ρ¦֥Υꥹȡ")
(defvar tcode-mazegaki-alternative-left-first t
  "* 2Ĥ椫1־ˡ¦˼1֤ɤ")

(defvar tcode-mazegaki-complete-max 10
  "* 䴰κݤ˰οκ͡
䤬Ͱʾʤ䴰ϹԤʤ")

(defconst tcode-mazegaki-katuyou-gobi ""
  "* ɤߤѤˡѸɽˤĤʸ")

(defvar tcode-mazegaki-katuyou-gobi-max 4
  "* ɤߤγѸκʸ")

(defcustom tcode-mazegaki-gakusyu-kouho-offset 4
  "* ؽȤˡؽоݳȤʤο
ߤɤߤˤĤơ򤵤줿ν֤οʲʤСؽʤ"
  :group 'mazegaki-henkan)

(defvar tcode-mazegaki-splitter "/"
  "* ϿκݤΡɤߤӴζڤɽɽ")

;;; ¾ѿ

(defvar tcode-mazegaki-buffer nil "򤼽񤭼Хåե")

(defvar tcode-mazegaki-yomi-list nil
  "ѴϻǥˤäʸΥꥹȡ
ľʸ car cadrʲƱ͡
 `tcode-mazegaki-yomi-max' ʸޤǡ")

(defvar tcode-mazegaki-current-yomi-length 0
  "ѴоݤȤʤäƤʸĹ
\(length tcode-mazegaki-yomi-list\)ʲǤ롣")
(defvar tcode-mazegaki-current-offset 0
  "`tcode-mazegaki-yomi-list' βܤʸɤߤȤߤʤ")

(defvar tcode-mazegaki-yomi-fixed-p nil
  "ĹɤѴʤ nilǤʤʤ t
Ĥޤꡢfjפ֤ɤߤϤ줿ˤϤѿͤ t Ǥꡢ
ʳξ nil Ǥ롣")

(defvar tcode-mazegaki-input-map nil "򤼽ѴΥޥåס")
(defvar tcode-mazegaki-mode nil "򤼽Ѵ椫ɤ")

(defvar tcode-old-map nil "򤼽Ѵľ˻ȤäƤ local map")

(defvar tcode-mazegaki-yomi-postfix ""
  "ѴоݳȤФ줿ʸ")

(defvar tcode-mazegaki-henkan-overlay nil
  "򤼽ѴѴоݤɽ overlay")
(make-variable-buffer-local 'tcode-mazegaki-henkan-overlay)

(defvar tcode-mazegaki-katuyou-only nil
  "Ѵ椫ɤ")

(defvar tcode-mazegaki-in-katuyou nil
  "ѤɤߤѴоݤȤƤ뤫ɤ")

;;;; θѴ

(defmacro tcode-mazegaki-in-minibuffer-p ()
  "ߥߥ˥Хåեˤ뤫ɤɽ"
  (list 'string-match " \\*Mini" (list 'buffer-name (list 'current-buffer))))

(cond ((or (tcode-nemacs-p) (tcode-mule-1-p)))
      ((tcode-xemacs-p)
       (defun tcode-mazegaki-put-henkan-face ()
	 "Ѵϰ֤ point ޤǤꤵ줿 face ˤ롣
face λѿ `tcode-mazegaki-prefix-mark' ꤹ뤳ȤˤԤ"
	 (tcode-mazegaki-delete-henkan-face)
	 (when tcode-in-mazegaki-p
	   (if (not (extentp tcode-mazegaki-henkan-overlay))
	       (progn
		 (setq tcode-mazegaki-henkan-overlay
		       (make-extent (marker-position tcode-in-mazegaki-p)
				    (point)))
		 (set-extent-face tcode-mazegaki-henkan-overlay
				  tcode-mazegaki-prefix-mark))
	     (set-extent-endpoints
	      tcode-mazegaki-henkan-overlay
	      (marker-position tcode-in-mazegaki-p) (point)))))
       (defun tcode-mazegaki-delete-henkan-face ()
	 "򤼽ѴѤ face "
	 (and (extentp tcode-mazegaki-henkan-overlay)
	      (detach-extent tcode-mazegaki-henkan-overlay))))
      (t
       (or (fboundp 'make-overlay) (require 'overlay))
       ;; face ˤѴоΰɽ뤿δؿ
       (defun tcode-mazegaki-put-henkan-face ()
	 "Ѵϰ֤ point ޤǤꤵ줿 face ˤ롣
face λѿ `tcode-mazegaki-prefix-mark' ꤹ뤳ȤˤԤ"
	 (tcode-mazegaki-delete-henkan-face)
	 (when tcode-in-mazegaki-p
	   (if (not (overlayp tcode-mazegaki-henkan-overlay))
	       (progn
		 (setq tcode-mazegaki-henkan-overlay
		       (make-overlay (marker-position tcode-in-mazegaki-p)
				     (point)))
		 (overlay-put tcode-mazegaki-henkan-overlay
			      'face tcode-mazegaki-prefix-mark))
	     (move-overlay
	      tcode-mazegaki-henkan-overlay
	      (marker-position tcode-in-mazegaki-p) (point)))))
       (defun tcode-mazegaki-delete-henkan-face ()
	 "򤼽ѴѤ face "
	 (and (overlayp tcode-mazegaki-henkan-overlay)
	      (delete-overlay tcode-mazegaki-henkan-overlay)))))

;;;###autoload
(defun tcode-mazegaki-switch-to-dictionary ()
  "current-buffer 򤼽񤭼ڤؤ롣
򤼽񤭼񤬤ޤɤ߹ޤƤʤˤɤ߹ࡣ"
  (interactive)
  (if (get-buffer " *mazegaki-dic*")
      (set-buffer tcode-mazegaki-buffer)
    (let ((dic (expand-file-name tcode-mazegaki-dictionary-name)))
      (or (file-exists-p dic)
	  (error "ե %s ¸ߤޤ" dic))
      (message "ե %s ɤ߹..." dic)
      (set-buffer (setq tcode-mazegaki-buffer
			(get-buffer-create " *mazegaki-dic*")))
      (insert-file-contents dic)
      (set-buffer-modified-p nil)
      (message "ե %s ɤ߹...λ" dic)))
  (and (interactive-p)
       (switch-to-buffer tcode-mazegaki-buffer)))

(defun tcode-mazegaki-construct-yomi (len &optional offset postfix)
  "`tcode-mazegaki-yomi-list' 顢Ĺ LEN ɤߤ롣
OFFSET ꤵƤϡOFFSET ʸϳѸȤɤߤˤ
ޤ᤺POSTFIX  nil Ǥʤ `tcode-mazegaki-katuyou-gobi' ֤롣"
  (let ((list (if offset
		  (nthcdr offset tcode-mazegaki-yomi-list)
		tcode-mazegaki-yomi-list))
	(str ""))
    (while (> len 0)
      (setq str  (if tcode-mazegaki-reverse-yomi-jisho
		     (concat str (car list))
		   (concat (car list) str))
	    list (cdr list)
	    len  (1- len)))
    (if postfix
	(if tcode-mazegaki-reverse-yomi-jisho
	    (concat tcode-mazegaki-katuyou-gobi str)
	  (concat str tcode-mazegaki-katuyou-gobi))
      str)))

(defun tcode-mazegaki-list-to-string (list from len)
  "ʸ LIST  FROM  LEN ʸʬʸ롣"
  (let ((str ""))
    (setq list (nthcdr from list))
    (while (> len 0)
      (setq str  (concat (car list) str)
	    list (cdr list)
	    len  (1- len)))
    str))

(defun tcode-mazegaki-skip-blank-backward ()
  "Ƭ  point ޤǤʤ point ιԤι˰ư롣"
  (let ((p (point))
	(fill-prefix-end (and fill-prefix
			      (save-excursion
				(beginning-of-line)
				(and (looking-at (regexp-quote fill-prefix))
				     (match-end 0))))))
    (cond ((bobp)
	   nil)
	  ((null fill-prefix-end)	; fill-prefix ʤ硣
	   (if (or (not (memq (tcode-char-before (point))
			      tcode-ignore-char-list))
		   (save-excursion (beginning-of-line)
				   (or (not (re-search-forward "^\\s *" p t))
				       (/= (point) p))))
	       p
	     ;; ƬζȤФ
	     (forward-line -1)
	     (end-of-line)
	     (if (bobp)
		 nil
	       (point))))
	  ((not (save-excursion
		  (goto-char fill-prefix-end)
		  (tcode-removable-fill-prefix-p)))
					; ľιԤ
					; fill-prefix ǻϤ
					; äƤʤ硣
	   (if (= fill-prefix-end p)
	       nil			; ƤϤʤ
					; fill-prefix
	     p))
	  ((<= p fill-prefix-end)	; fill-prefix ˤ硣
	   (forward-line -1)
	   (end-of-line)
	   (if (bobp)
	       nil
	     (point)))
	  (t				; fill-prefix + ʸξ硣
	   (if (or (not (memq (tcode-char-before (point))
			      tcode-ignore-char-list))
		   (save-excursion
		     (beginning-of-line)
		     (or (not (re-search-forward
			       (concat "^" (regexp-quote fill-prefix) "\\s *")
			       p t))
			 (/= (point) p))))
	       p
	     ;; fill-prefix + ȤФ
	     (forward-line -1)
	     (end-of-line)
	     (point))))))

(defun tcode-mazegaki-get-reverse-yomi-list ()
  " point ˤܸޤϱñĤΥꥹȤ֤
ꥹȤĹϺ `tcode-mazegaki-yomi-max' ʸ"
  (save-excursion
    (let ((ch 0)
	  reverse-list)
      (setq tcode-mazegaki-yomi-postfix ""
	    tcode-mazegaki-yomi-fixed-p tcode-in-mazegaki-p)
      (while (and (< (length reverse-list) tcode-mazegaki-yomi-max)
		  (tcode-mazegaki-skip-blank-backward)
		  (> (setq ch (tcode-char-before (point))) 256)
		  (or (null tcode-in-mazegaki-p)
		      (> (point) (marker-position tcode-in-mazegaki-p)))
		  (or (not (memq ch tcode-mazegaki-terminate-char-list))
		      (null reverse-list)))
	(if (and (null reverse-list)
		 (memq ch tcode-mazegaki-terminate-char-list))
	    ;; `tcode-mazegaki-terminate-char-list' ˤʸȤФ
	    (setq tcode-mazegaki-yomi-postfix
		  (concat (char-to-string ch)
			  tcode-mazegaki-yomi-postfix))
	  ;; ɤߤ
	  (setq reverse-list (nconc reverse-list
				    (list (char-to-string ch)))))
	(tcode-forward-char -1))
      (and (null reverse-list)
	   (not (bobp))
	   (<= ch 255)
	   ;; ե٥åɤ
	   (setq reverse-list
		 (list
		  (buffer-substring
		   (save-excursion
		     (if (= (char-syntax ch) ?w)
			 ;; 
			 (while (and (not (bobp))
				     (= (char-syntax
					 (setq ch (tcode-char-before (point))))
					?w)
				     (<= ch 255))
			   (tcode-forward-char -1))
		       ;; 
		       (tcode-forward-char -1))
		     (point))
		   (point)))))
      reverse-list)))

(defun tcode-mazegaki-search-yomi (yomi)
  "ߤΥХåե YOMI 򸫤Ĥ point ư롣
Ĥʤϡ point Ϥ YOMI ٤˰ư롣"
  (let ((min (point-min))
	(max (point-max))
	str)
    (catch 'found
      (and (eobp)
	   (forward-line -1))
      (while (< min max)
	(cond ((string< (setq str (buffer-substring
				   (prog2
				       (beginning-of-line)
				       (point)
				     (looking-at "^\\([^/]+\\) /"))
				   (match-end 1)))
			yomi)
	       ;; ä礭
	       (forward-line 1)
	       (goto-char (/ (+ (setq min (point)) max) 2)))
	      ((string< yomi str)
	       ;; äȾ
	       (goto-char (/ (+ min (setq max (point))) 2)))
	      ;; Ĥ
	      ((throw 'found (point))))))))

(defun tcode-mazegaki-lookup (new)
  "ߤɤߤûĹɤߤõ
NEW  nil ǤʤСõϤ롣
ĤФɤߤĹ offset ( 0) 򡢤ʤ nil ֤
򤼽񤭼ΥݥȤϤɤߤΤȤ˰ư롣"
  (save-excursion
    (setq tcode-mazegaki-in-katuyou nil)
    (tcode-mazegaki-switch-to-dictionary)
    (let* ((max (length tcode-mazegaki-yomi-list))
	   (min (if tcode-mazegaki-yomi-fixed-p (1- max) 0))
	   (i (if new max (1- tcode-mazegaki-current-yomi-length))))
      (catch 'found
	(while (> i min)
	  (and (tcode-mazegaki-search-yomi (tcode-mazegaki-construct-yomi i))
	       (throw 'found (cons i 0)))
	  (setq i (1- i)))))))

(defun tcode-mazegaki-lookup-variable (new)
  "ߤɤߤûѤĹɤߤõ
NEW  nil ǤʤСõϤ롣
ĤФɤߤĹ offset 򡢤ʤ nil ֤
򤼽񤭼ΥݥȤϤɤߤΤȤ˰ư롣"
  (save-excursion
    (setq tcode-mazegaki-in-katuyou t)
    (tcode-mazegaki-switch-to-dictionary)
    (let* ((max (length tcode-mazegaki-yomi-list))
	   (min 0)
	   (i (if new max tcode-mazegaki-current-yomi-length))
	   (offset (cond (new
			  (cond ((>= (+ i tcode-mazegaki-katuyou-gobi-max)
				     max)
				 (- max i))
				(tcode-mazegaki-yomi-fixed-p
				 -1)
				(t
				 tcode-mazegaki-katuyou-gobi-max)))
			 (tcode-mazegaki-yomi-fixed-p -1)
			 (t (1- tcode-mazegaki-current-offset)))))
      (catch 'found
	(while (> i min)
	  (while (>= offset 0)
	    (and (string-match "^[-]*$"
			       (tcode-mazegaki-construct-yomi offset))
		 (tcode-mazegaki-search-yomi
		  (tcode-mazegaki-construct-yomi i offset t))
		 (throw 'found (cons i offset)))
	    (setq offset (if tcode-mazegaki-yomi-fixed-p -1 (1- offset))))
	  (setq i (1- i)
		offset (cond ((>= (+ i tcode-mazegaki-katuyou-gobi-max)
				  max)
			      (- max i))
			     (tcode-mazegaki-yomi-fixed-p
			      -1)
			     (t
			      tcode-mazegaki-katuyou-gobi-max))))))))

(defun tcode-mazegaki-lookup-reverse (new)
  "ߤɤߤĹûɤߤ򸫤Ĥ롣
ĤФɤߤĹ offset ( 0) 򡢤ʤ nil ֤
򤼽񤭼ΥݥȤϤɤߤΤȤ˰ư롣"
  (save-excursion
    (setq tcode-mazegaki-in-katuyou nil)
    (tcode-mazegaki-switch-to-dictionary)
    (let* ((max (length tcode-mazegaki-yomi-list))
	   (i (cond (new (if tcode-mazegaki-yomi-fixed-p max 1))
		    (tcode-mazegaki-yomi-fixed-p (1+ max))
		    (t (1+ tcode-mazegaki-current-yomi-length)))))
      (catch 'found
	(while (<= i max)
	  (and (tcode-mazegaki-search-yomi (tcode-mazegaki-construct-yomi i))
	       (throw 'found (cons i 0)))
	  (setq i (1+ i)))))))

(defun tcode-mazegaki-lookup-variable-reverse (new)
  "ߤɤߤĹûγѤɤߤ򸫤Ĥ롣
ĤФɤߤĹ offset 򡢤ʤ nil ֤
򤼽񤭼ΥݥȤϤɤߤΤȤ˰ư롣"
  (save-excursion
    (setq tcode-mazegaki-in-katuyou t)
    (tcode-mazegaki-switch-to-dictionary)
    (let* ((max (length tcode-mazegaki-yomi-list))
	   (i (if new 1 tcode-mazegaki-current-yomi-length))
	   (offset (cond (new (cond ((not tcode-mazegaki-yomi-fixed-p)
				     0)
				    ((<= (- max i)
					tcode-mazegaki-katuyou-gobi-max)
				     (- max i))
				    (t
				     max)))
			 ((or tcode-mazegaki-yomi-fixed-p
			      (>= tcode-mazegaki-current-offset
				  tcode-mazegaki-katuyou-gobi-max))
			  max)
			 (t (1+ tcode-mazegaki-current-offset)))))
      (catch 'found
	(while (<= i max)
	  (while (<= (+ i offset) max)
	    (and (string-match "^[-]*$"
			       (tcode-mazegaki-construct-yomi offset))
		 (tcode-mazegaki-search-yomi
		  (tcode-mazegaki-construct-yomi i offset t))
		 (throw 'found (cons i offset)))
	    (setq offset (if (>= offset
				 tcode-mazegaki-katuyou-gobi-max)
			     max
			   (1+ offset))))
	  (setq i (1+ i)
		offset (cond ((not tcode-mazegaki-yomi-fixed-p)
			      0)
			     ((<= (- max i)
				  tcode-mazegaki-katuyou-gobi-max)
			      (- max i))
			     (t max))))))))

(defun tcode-mazegaki-use-mazegaki-map ()
  "ޥåפ `tcode-mazegaki-input-map' ڤؤ롣"
  (setq tcode-mazegaki-mode t)
  (if (eq (current-local-map) tcode-mazegaki-input-map)
      ;; for some reason we failed to restore the old map.
      ;; do nothing here.
      nil
    (setq tcode-old-map (current-local-map))
    (use-local-map tcode-mazegaki-input-map)))

(defun tcode-mazegaki-erase-previous-kouho ()
  "ߥХåեɽƤѴõ롣
ºݤˤϡľΡ֢װʹߤʸõ롣"
  (and tcode-in-mazegaki-p
       (delete-region (marker-position tcode-in-mazegaki-p) (point))))

(defun tcode-mazegaki-beginning (yomi-list i)
  "YOMI-LIST  I ʸɤߤƬ point ֤"
  (save-excursion
    (while (> i 0)
      (tcode-get-prev-nonspace)
      (or (looking-at (regexp-quote (car yomi-list)))
	  (progn (tcode-forward-char 1)
		 (search-backward (car yomi-list))))
      (setq yomi-list (cdr yomi-list)
	    i (1- i)))
    (point)))

;;;###autoload
(defun tcode-mazegaki-henkan (arg &optional postfix)
  " point ˤܸɤߡפȤƸ򤼽Ѵ롣

ARG ϼ̣롣
 * C-u Τߤޤ - Τ
   ѤȤѴ(ɤߤĹϺĹ)
 * 
   ͤɤߤĹȤѴ
   ѴΤϡξϳѤʤ졢
   ξϳѤȤ롣

POSTFIX  nil ǤʤСARG ͤˤ餺ѤȤѴԤ"
  (interactive "*P")
  (setq tcode-mazegaki-katuyou-only (or (eq arg '-)
					(and (integerp arg)
					     (< arg 0))
					(and arg
					     (listp arg))
					postfix))
  (let ((tcode-mazegaki-yomi-max (if (integerp arg)
				     (if (>= arg 0) arg (- arg))
				   tcode-mazegaki-yomi-max)))
    (or (setq tcode-mazegaki-yomi-list (tcode-mazegaki-get-reverse-yomi-list))
	(let (tcode-auto-help)
	  (tcode-mazegaki-kakutei)
	  (error "ɤߤޤ"))))
  (and (integerp arg)
       (or tcode-mazegaki-yomi-fixed-p
	   (= (length tcode-mazegaki-yomi-list)
	      (if (>= arg 0) arg (- arg)))
	   (error "ɤߤûޤ"))
       (setq tcode-mazegaki-yomi-fixed-p t))
  ;; ɤߤ뤫Ĵ١Ѵ롣
  (let ((with-katuyou (and tcode-mazegaki-enable-variable-yomi-postfix
			   (or postfix
			       (not (and (integerp arg)
					 (> arg 0)))))))
    (let* ((tcode-mazegaki-enable-variable-yomi-postfix with-katuyou)
	   (yomi-info (or (and (not tcode-mazegaki-katuyou-only)
			       (tcode-mazegaki-lookup t))
			  (and (or tcode-mazegaki-enable-variable-yomi-postfix
				   tcode-mazegaki-katuyou-only)
			       (tcode-mazegaki-lookup-variable t)))))
      (if yomi-info
	  ;; 䤬Ĥä
	  (prog1
	      (setq tcode-mazegaki-current-yomi-length (car yomi-info)
		    tcode-mazegaki-current-offset (cdr yomi-info))
	    ;; i ʸθƬ˰()Ĥ롣
	    (save-excursion
	      (goto-char (tcode-mazegaki-beginning
			  tcode-mazegaki-yomi-list
			  (if tcode-in-mazegaki-p
			      (length tcode-mazegaki-yomi-list)
			    (+ (car yomi-info) (cdr yomi-info)))))
	      (if tcode-in-mazegaki-p
		  (and (/= (marker-position tcode-in-mazegaki-p) (point))
		       (let (tcode-auto-help)
			 (tcode-mazegaki-kakutei)
			 (error "ɤߤĹޤ")))
		(and (stringp tcode-mazegaki-prefix-mark)
		     (insert tcode-mazegaki-prefix-mark))
		(setq tcode-in-mazegaki-p (point-marker))))
	    (tcode-mazegaki-use-mazegaki-map)
	    (or (stringp tcode-mazegaki-prefix-mark)
		(tcode-mazegaki-put-henkan-face))
	    (tcode-mazegaki-select-kouho-from-table))
	;; 䤬̵ä
	(setq this-command 'tcode-mazegaki-start) ; ϿԤȤѤٹ
	(ding)
	(tcode-verbose-message
	 (tcode-substitute-command-keys
	  (concat "ŬʴϤޤ"
		  " (\\[tcode-mazegaki-toroku-and-kakutei]פϿ)")))
	nil))))

;;;###autoload
(defun tcode-mazegaki-start (arg)
  "򤼽Ѵ򳫻Ϥ롣"
  (interactive "*P")
  (cond (tcode-in-mazegaki-p
	 (or tcode-mazegaki-yomi-list
	     (tcode-mazegaki-get-reverse-yomi-list))
	 (tcode-mazegaki-henkan arg))
	(tcode-use-prefix-mazegaki
	 (tcode-start-fixed-mazegaki))
	((tcode-mazegaki-henkan arg))))

;;;###autoload
(defun tcode-mazegaki-alternative-start (arg)
  "򤼽Ѵ򳫻Ϥ롣ַַա"
  (interactive "*P")
  (call-interactively (if tcode-use-prefix-mazegaki
			  'tcode-mazegaki-henkan
			'tcode-start-fixed-mazegaki)))

;;;; 

(defun tcode-mazegaki-find-kanji-entry ()
  "ߤɤߤ(ǽ)ȥޤǸ򤼽񤭼 point ư롣
Τˤϡpoint ϺǽΥȥƬˤ\"/\"ľ˰ư롣"
  (set-buffer tcode-mazegaki-buffer)
  (beginning-of-line)
  (search-forward " /" nil t))

(defun tcode-mazegaki-get-number-of-kouho ()
  "ߤɤߤθο롣"
  (save-excursion
    (tcode-mazegaki-find-kanji-entry)
    (let ((nok 0)
	  (p (point)))
      (end-of-line)
      (while (search-backward "/" p t)
	(setq nok (1+ nok)))
      nok)))

(defun tcode-mazegaki-get-kouho-list ()
  "ߤɤߤΥꥹȤ롣"
  (save-excursion
    (tcode-mazegaki-find-kanji-entry)
    (let (list)
      (while (not (eolp))
	(setq list (nconc list
			  (list (buffer-substring
				 (point)
				 (prog2
				     (search-forward "/" nil t)
				     (1- (point))))))))
      list)))

(defun tcode-mazegaki-make-kouho-table (kouho-list)
  " KOUHO-LIST ɽ롣
ɽˤ֤ϡѿ `tcode-mazegaki-priority-list' ˽"
  (let ((plist tcode-mazegaki-priority-list)
	(table (make-vector 40 nil)))
    (while (and kouho-list plist)
      (aset table (car plist) (car kouho-list))
      (setq kouho-list (cdr kouho-list)
	    plist (cdr plist)))
    table))

(defun tcode-mazegaki-select (kouho-table nok current-offset
					  &optional msg postfix)
  "KOUHO-TABLE 򤵤롣
NOK (ο) CURRENT-OFFSET 鸽߲ܤɽɽƤ뤫׻롣"
  (let* ((plist-size (length tcode-mazegaki-priority-list))
	 (whole-page (/ (+ nok (1- plist-size)) plist-size))
	 (page (- (1+ whole-page)
		  (/ (+ (- nok current-offset) (1- plist-size)) plist-size)))
	 (whole-table (or (> whole-page 1)
			  ;; ܰʳ˸䤬뤫Ĵ٤
			  (catch 'found
			    (let ((i 0))
			      (while (< i 40)
				(and (aref kouho-table i)
				     (throw 'found t))
				(setq i (if (= i 19) 30 (1+ i)))))))))
    (if whole-table
	(progn
	  (and postfix
	       (setq msg (concat msg "  " postfix)))
	  (and (not (and (tcode-mazegaki-in-minibuffer-p)
			 (null msg)))
	       (message (or msg "")))
	  (tcode-display-help-buffer
	   (tcode-draw-table kouho-table page whole-page) t))
      (let ((kouho-list (mapcar
			 (function
			  (lambda (n)
			    (or (aref kouho-table n)
				"-")))
			 '(20 21 22 23 24 25 26 27 28 29))))
	(message
	 (concat msg
		 (if (= whole-page 1)
		     ""
		   (format "(%d/%d)  " page whole-page))
		 (apply 'format
			(cons "[%s %s %s %s] %s  %s [%s %s %s %s]" kouho-list))
		 "  "
		 postfix)))))
  (let* ((echo-keystrokes 0)
	 (ch (read-char))
	 (key (tcode-get-key-address ch)))
    (if (< key 0)
	ch
      (or (aref kouho-table key)
	  ch))))

(defun tcode-mazegaki-make-table-and-select (&optional msg kouho-list inline)
  "ߤɤߤ򤵤ʸޤʸ()֤"
  (or kouho-list
      (setq kouho-list (tcode-mazegaki-get-kouho-list)))
  (let* ((nok (length kouho-list))
	 (plist-size (length tcode-mazegaki-priority-list))
	 (postfix (and tcode-mazegaki-in-katuyou
		       (concat (tcode-mazegaki-construct-yomi
				tcode-mazegaki-current-yomi-length
				tcode-mazegaki-current-offset)
			       "("
			       (if (zerop tcode-mazegaki-current-offset)
				   tcode-mazegaki-katuyou-gobi
				 (tcode-mazegaki-construct-yomi
					      tcode-mazegaki-current-offset))
			       ")"))))
    (if (<= nok 1)
	(car kouho-list)
      (if (and inline
	       (= nok 2))
	  (let ((left-kouho (if tcode-mazegaki-alternative-left-first
				(car kouho-list)
			      (car (cdr kouho-list))))
		(right-kouho (if tcode-mazegaki-alternative-left-first
				 (car (cdr kouho-list))
			       (car kouho-list))))
	    (tcode-mazegaki-erase-previous-kouho)
	    (insert "{" left-kouho "," right-kouho "}")
	    (and tcode-mazegaki-in-katuyou
		 (insert (tcode-mazegaki-construct-yomi
			  tcode-mazegaki-current-offset)))
	    (or (stringp tcode-mazegaki-prefix-mark)
		(tcode-mazegaki-put-henkan-face))
	    (let* ((c (read-char))
		   (key (tcode-get-key-address c)))
	      (tcode-mazegaki-restore-yomi-and-quit t)
	      (cond ((memq key tcode-mazegaki-alternative-select-left-keys)
		     left-kouho)
		    ((memq key tcode-mazegaki-alternative-select-right-keys)
		     right-kouho)
		    (t
		     c))))
	;; nok >(=) 2
	(save-excursion
	  (let ((current-offset 0)
		(kouho (tcode-mazegaki-select
			(tcode-mazegaki-make-kouho-table kouho-list)
			nok 0 msg postfix)))
	    (while (and (char-or-string-p kouho)
			(not (stringp kouho))
			(or (= kouho ? )
			    (= kouho ?\C-?)))
	      (setq current-offset (if (= kouho ? )
				       (+ current-offset plist-size)
				     (- current-offset plist-size)))
	      (and (>= current-offset nok)
		   (setq current-offset 0))
	      (and (< current-offset 0)
		   (let ((v current-offset))
		     (while (< (setq v (+ v plist-size)) nok)
		       (setq current-offset v))))
	      (setq kouho
		    (tcode-mazegaki-select
		     (tcode-mazegaki-make-kouho-table
		      (nthcdr current-offset kouho-list))
		     nok current-offset msg postfix)))
	    (tcode-auto-remove-help t)
	    kouho))))))

(defun tcode-mazegaki-select-kouho-from-table ()
  "ߤɤߤɽ򤹤롣"
  (interactive "*")
  (let ((selected-kouho (tcode-mazegaki-make-table-and-select
			 (and (not (tcode-mazegaki-in-minibuffer-p))
			      (tcode-verbose-message "(? ǥإ)"))
			 nil t))
	(nok (tcode-mazegaki-get-number-of-kouho)))
    (cond ((stringp selected-kouho)
	   (tcode-mazegaki-erase-previous-kouho)
	   (insert selected-kouho
		   (tcode-mazegaki-list-to-string
		    tcode-mazegaki-yomi-list
		    0
		    tcode-mazegaki-current-offset)
		   tcode-mazegaki-yomi-postfix)
	   (or (stringp tcode-mazegaki-prefix-mark)
	       (tcode-mazegaki-put-henkan-face))
	   (or (and (= nok 1)
		    (or tcode-mazegaki-enable-variable-yomi-postfix
			(not tcode-mazegaki-yomi-fixed-p)))
	       (tcode-mazegaki-kakutei)))
	  ((char-or-string-p selected-kouho)
	   (tcode-redo-command selected-kouho)))))

;;;; ɤߤζڤľγ

(defun tcode-mazegaki-restore-yomi-and-quit (&optional not-quit)
  "ɤߤξ֤ᤷơ򤼽Ѵλ롣
NOT-QUIT  nil ǤʤȤϡɤߤξ֤᤹ǡλϤʤ"
  (interactive "P")
  (tcode-mazegaki-erase-previous-kouho)
  (or not-quit
      (not (stringp tcode-mazegaki-prefix-mark))
      (bobp)
      (save-excursion
	(tcode-forward-char -1)
	(and (looking-at (regexp-quote tcode-mazegaki-prefix-mark))
	     (tcode-delete-char 1))))	; erase ""
  (insert (tcode-mazegaki-list-to-string
	   tcode-mazegaki-yomi-list 0
	   (+ tcode-mazegaki-current-yomi-length
	      tcode-mazegaki-current-offset))
	  tcode-mazegaki-yomi-postfix)
  (or (stringp tcode-mazegaki-prefix-mark)
      (tcode-mazegaki-put-henkan-face))
  (or not-quit
      (progn
	(or (stringp tcode-mazegaki-prefix-mark)
	    (tcode-mazegaki-delete-henkan-face))
	(or (tcode-mazegaki-in-minibuffer-p)
	    (message ""))
	(tcode-do-auto-fill)
	(setq tcode-in-mazegaki-p nil)
	(setq tcode-mazegaki-mode nil)
	(use-local-map tcode-old-map))))

(defun tcode-mazegaki-relimit (length offset)
  "ߤɤߤڤľ򤵤롣
ڤľɤߤϡĹ LENGTH  OFFSET Ȥɽ롣"
  (save-excursion
    (goto-char (marker-position tcode-in-mazegaki-p))
    (and (stringp tcode-mazegaki-prefix-mark)
	 (backward-char 1))
    (let ((old-yomi-total (+ tcode-mazegaki-current-yomi-length
			     tcode-mazegaki-current-offset))
	  (new-yomi-total (+ length offset)))
      (if (<= old-yomi-total new-yomi-total)
	  ;; ޡɤߤä
	  (delete-region
	   (tcode-mazegaki-beginning (nthcdr old-yomi-total
					     tcode-mazegaki-yomi-list)
				     (- new-yomi-total old-yomi-total))
	   (point))
	;; ޡɤߤ
	(insert (tcode-mazegaki-list-to-string
		 tcode-mazegaki-yomi-list
		 new-yomi-total
		 (- old-yomi-total new-yomi-total)))))
    (and (stringp tcode-mazegaki-prefix-mark)
	 (tcode-forward-char 1))	; skip mark
    (setq tcode-in-mazegaki-p (point-marker)))
  (or (stringp tcode-mazegaki-prefix-mark)
      (tcode-mazegaki-put-henkan-face))
  (setq tcode-mazegaki-current-yomi-length length
	tcode-mazegaki-current-offset offset)
  (tcode-mazegaki-restore-yomi-and-quit t)
  (tcode-mazegaki-select-kouho-from-table))

(defun tcode-mazegaki-relimit-right ()
  "ɤߤ̤롣"
  (interactive)
  (let ((p (save-excursion
	     (tcode-mazegaki-switch-to-dictionary)
	     (point)))
	(orig-in-katuyou tcode-mazegaki-in-katuyou)
	(yomi-info (or (and (not tcode-mazegaki-katuyou-only)
			    (not tcode-mazegaki-in-katuyou)
			    (tcode-mazegaki-lookup nil))
		       (and (or tcode-mazegaki-enable-variable-yomi-postfix
				tcode-mazegaki-katuyou-only)
			    (tcode-mazegaki-lookup-variable
			     (not tcode-mazegaki-in-katuyou))))))
    (if yomi-info
	(tcode-mazegaki-relimit (car yomi-info) (cdr yomi-info))
      (save-excursion
	(tcode-mazegaki-switch-to-dictionary)
	(goto-char p))
      (setq tcode-mazegaki-in-katuyou orig-in-katuyou)
      (ding)
      (tcode-verbose-message "ʾɤߤϽ̤ޤ"))))

(defun tcode-mazegaki-relimit-left ()
  "ɤߤ򿭤Ф"
  (interactive)
  (let ((p (save-excursion
	     (tcode-mazegaki-switch-to-dictionary)
	     (point)))
	(orig-in-katuyou tcode-mazegaki-in-katuyou)
	(yomi-info (or (and (or tcode-mazegaki-enable-variable-yomi-postfix
				tcode-mazegaki-katuyou-only)
			    tcode-mazegaki-in-katuyou
			    (tcode-mazegaki-lookup-variable-reverse nil))
		       (and (not tcode-mazegaki-katuyou-only)
			    (tcode-mazegaki-lookup-reverse
			     tcode-mazegaki-in-katuyou)))))
    (if yomi-info
	(tcode-mazegaki-relimit (car yomi-info) (cdr yomi-info))
      (save-excursion
	(tcode-mazegaki-switch-to-dictionary)
	(goto-char p))
      (setq tcode-mazegaki-in-katuyou orig-in-katuyou)
      (ding)
      (tcode-verbose-message "ʾɤߤϿФޤ"))))

(defun tcode-mazegaki-select-kouho-or-relimit ()
  "ɤߤ̤뤫ΰ򤹤롣
ɤߤ̤ΤϡߤθοĤξΤߡ"
  (interactive)
  (if (/= (tcode-mazegaki-get-number-of-kouho) 1)
      (tcode-mazegaki-select-kouho-from-table)
    (cancel-undo-boundary)
    (tcode-mazegaki-relimit-right)))

(defun tcode-mazegaki-gakusyu (kouho)
  "ߤɤߤ KOUHO ؽ롣
ؽϡѿ `tcode-mazegaki-gakusyu-kouho-offset' 
ꤷΤΤΤߡ"
  (save-excursion
    (tcode-mazegaki-find-kanji-entry)
    (and tcode-mazegaki-in-katuyou
	 (setq kouho
	       (substring kouho
			  0
			  (- (length (tcode-mazegaki-construct-yomi
				      tcode-mazegaki-current-offset))))))
    (let ((search-string (concat (regexp-quote kouho) "/")))
      (or (looking-at search-string)
	  (let ((i 1)
		(eol (save-excursion (end-of-line) (point)))
		(latest-point (point)))
	    (and (catch 'found
		   (while (search-forward "/" eol t)
		     (and (= i tcode-mazegaki-gakusyu-kouho-offset)
			  (setq latest-point (point)))
		     (and (looking-at search-string)
			  (throw 'found t))
		     (setq i (1+ i))))
		 (> i tcode-mazegaki-gakusyu-kouho-offset)
		 (progn
		   (delete-region (point) (match-end 0))
		   (goto-char latest-point)
		   (insert kouho ?/))))))))

(defun tcode-mazegaki-kakutei ()
  "򤼽Ѵꤷơ򤼽Ѵ⡼ɤȴ롣"
  (interactive)
  (and tcode-in-mazegaki-p
       (let* ((end (point))
	      (beg (marker-position tcode-in-mazegaki-p))
	      (kakutei (prog1
			   (buffer-substring beg end)
			 (and tcode-kakutei-register
			      (copy-to-register tcode-kakutei-register
						beg end))
			 (and (stringp tcode-mazegaki-prefix-mark)
			      (save-excursion
				(goto-char beg)
				(or (bobp)
				    (progn
				      (tcode-forward-char -1)
				      (and (looking-at
					    (regexp-quote
					     tcode-mazegaki-prefix-mark))
					   (tcode-delete-char 1)))))))))
	 (if overwrite-mode
	     (delete-text-in-column nil (+ (current-column)
					   (string-width kakutei)))
	   (tcode-do-auto-fill))
	 (and (boundp 'self-insert-after-hook)
	      self-insert-after-hook
	      (funcall self-insert-after-hook beg (point)))
	 (tcode-mazegaki-gakusyu kakutei)
	 (and tcode-record-file-name
	      (setq tcode-mazegaki-occurrence
		    (+ (chars-in-string kakutei) tcode-mazegaki-occurrence)))
	 (setq tcode-in-mazegaki-p nil)
	 (setq tcode-mazegaki-mode nil)
	 (use-local-map tcode-old-map)
	 (or (stringp tcode-mazegaki-prefix-mark)
	     (tcode-mazegaki-delete-henkan-face))
	 (or (tcode-mazegaki-in-minibuffer-p)
	     (message ""))
	 (or (string= kakutei "")
	     (setq tcode-help-char
		   (let ((kakutei-chars (tcode-string-to-char-list kakutei)))
		     (while (cdr kakutei-chars)
		       (setq kakutei-chars (cdr kakutei-chars)))
		     (char-to-string (car kakutei-chars)))))
	 (and tcode-auto-help
	      kakutei
	      (not (string= kakutei ""))
	      (tcode-display-direct-stroke
	       (substring kakutei
			  0
			  (and (not (string= tcode-mazegaki-yomi-postfix ""))
			       (- (length tcode-mazegaki-yomi-postfix))))
	       (tcode-mazegaki-construct-yomi
		(+ tcode-mazegaki-current-yomi-length
		   tcode-mazegaki-current-offset)))
	      (tcode-auto-remove-help-char)))))

(defun tcode-mazegaki-kakutei-and-self-insert ()
  "ѴꤷơľϤ줿(=ޥ)Ƽ¹Ԥ롣"
  (interactive)
  (tcode-mazegaki-kakutei)
  (tcode-redo-last-command))

;;;; ϿȺ

(defun tcode-mazegaki-get-yomi-and-kanji (prompt &optional str)
  "򤼽ϿΡɤߡפȡִפŬ롣"
  (let* ((minibuffer-setup-hook
	  ;; avoid referencing undefined variables in NEmacs.
	  (and (boundp 'minibuffer-setup-hook)
	       (cons 'toggle-input-method minibuffer-setup-hook)))
	 (yomi (if tcode-in-mazegaki-p
		   (buffer-substring
		    (marker-position tcode-in-mazegaki-p)
		    (point))
		 (read-from-minibuffer (concat prompt "ɤ ")
				       (if (and str
						(or (tcode-mule-2-p)
						    (tcode-mule-3-p)
						    (tcode-mule-4-p)))
					   (cons str 1)
					 str))))
	 (kanji (read-from-minibuffer
		 (format "%s(ɤ=%s) " prompt yomi))))
    (list yomi kanji)))

(defun tcode-get-yomi-in-dictionary (yomi)
  "YOMI 򼭽ϿޤϤεդѴ롣"
  (if (or (null tcode-mazegaki-reverse-yomi-jisho)
	  (< (tcode-char-width (tcode-string-to-char yomi)) 2))
					; ե٥å
      yomi
    (mapconcat 'char-to-string
	       (nreverse (tcode-string-to-char-list yomi)) "")))

(defun tcode-split-string-by-regexp (string splitter)
  "ʸ STRING ɽ SPLITTER ڤȤʬ䤹롣"
  (let (l)
    (while (string-match splitter string)
      (setq l (nconc l (list (substring string 0 (match-beginning 0))))
	    string (substring string (match-end 0))))
    (nconc l (list string))))

(defun tcode-mazegaki-yomi-combination (yomi-list kanji-list)
  "ɤߤȴȤμȤ߹碌򤹤٤󤹤롣"
  (if (<= (length yomi-list) 1)
      (append kanji-list yomi-list)
    (let ((yomi-car (car yomi-list))
	  (yomi-cdr (cdr yomi-list))
	  (kanji-car (car kanji-list))
	  (kanji-cdr (cdr kanji-list)))
      (if (string= yomi-car kanji-car)
	  (mapcar (function (lambda (a) (concat kanji-car a)))
		  (tcode-mazegaki-yomi-combination yomi-cdr kanji-cdr))
	(nconc
	 (mapcar (function (lambda (a) (concat kanji-car a)))
		 (tcode-mazegaki-yomi-combination yomi-cdr kanji-cdr))
	 (mapcar (function (lambda (a) (concat yomi-car a)))
		 (tcode-mazegaki-yomi-combination yomi-cdr kanji-cdr)))))))

;;;###autoload
(defun tcode-mazegaki-toroku (yomi kanji)
  "ɤ YOMI KANJI ǡʥȥ򤼽񤭼Ͽ롣
Ͽ tǤʤ nil ֤
ɤߤӴ `tcode-mazegaki-splitter' ǶڤäƤˤϡ
Ȥ߹碌ɤߤ٤ƤˤĤϿ롣"
  (interactive (tcode-mazegaki-get-yomi-and-kanji "Ͽ"))
  (and (interactive-p)
       (> (string-width yomi) tcode-mazegaki-yomi-max)
       (message (concat "ɤߡ%sפĹ(%d) `tcode-mazegaki-yomi-max' "
			"ͤĶƤޤ")
		yomi (string-width yomi))
       (setq tcode-mazegaki-yomi-max (string-width yomi)))
  (let ((yomi-list (tcode-split-string-by-regexp yomi
						 tcode-mazegaki-splitter)))
    (if (> (length yomi-list) 1)
	;; multi pattern
	(let ((kanji-list
	       (tcode-split-string-by-regexp kanji
					     tcode-mazegaki-splitter)))
	  (or (= (length yomi-list) (length kanji-list))
	      (error "ڤְäƤޤ"))
	  (setq yomi-list (tcode-mazegaki-yomi-combination
			   yomi-list kanji-list)
		kanji (car yomi-list)
		yomi-list (cdr yomi-list))
	  (mapcar (function (lambda (yomi)
			      (tcode-mazegaki-toroku yomi kanji)))
		  yomi-list))
      (save-excursion
	(tcode-mazegaki-switch-to-dictionary)
	(let ((dic-yomi (tcode-get-yomi-in-dictionary yomi)))
	  (tcode-mazegaki-search-yomi dic-yomi)
	  ;; ɤߤϿƤСɲä
	  ;; ϿƤʤС˥ȥ롣
	  (cond ((not (looking-at (concat dic-yomi " /")))
		 (insert dic-yomi " /" kanji "/\n")
		 t)
		((re-search-forward (concat "/" kanji "/")
				    (save-excursion (end-of-line) (point))
				    t)
		 (and (interactive-p)
		      (progn
			(ding)
			(message "%sפϤǤϿƤޤ" kanji)))
		 nil)
		(t
		 (tcode-mazegaki-find-kanji-entry)
		 (insert kanji "/"))))))))

(defun tcode-mazegaki-variable-yomi-p (yomi)
  "ɤߤѤΤɤɽҸ졣"
  (let ((gobi-length (length tcode-mazegaki-katuyou-gobi)))
    (and (stringp yomi)
	 (> (length yomi) gobi-length)
	 (string= (if tcode-mazegaki-reverse-yomi-jisho
		      (substring yomi 0 gobi-length)
		    (substring yomi (- gobi-length)))
		  tcode-mazegaki-katuyou-gobi))))

;;;###autoload
(defun tcode-mazegaki-toroku-and-kakutei ()
  "ʥȥ򤼽񤭼Ͽꤹ롣
ɤߤϡ򤼽Ѵ椢뤤ľѴ˼ԤƤϡ롣
ơϿϿꤹ롣
򤼽Ѵ椢뤤Ѵ˼ԤľʳξϡϹԤʤ"
  (interactive)
  (let ((yomi-exists (or tcode-in-mazegaki-p
			 (eq last-command 'tcode-mazegaki-start))))
    (and tcode-in-mazegaki-p
	 (tcode-mazegaki-restore-yomi-and-quit))
    (let* ((yomi-kanji (tcode-mazegaki-get-yomi-and-kanji
			"Ͽ" (if yomi-exists
				     (tcode-mazegaki-list-to-string
				      tcode-mazegaki-yomi-list 0
				      (length tcode-mazegaki-yomi-list))
				   nil)))
	   (yomi (car yomi-kanji)))
      (tcode-mazegaki-toroku yomi (car (cdr yomi-kanji)))
      (and yomi-exists
	   ;; ꤹ
	   (let* ((split-yomi
		   (tcode-split-string-by-regexp yomi
						 tcode-mazegaki-splitter))
		  (real-yomi (let (s)
			       (while split-yomi
				 (setq s (concat s (car split-yomi))
				       split-yomi (cdr split-yomi)))
			       s)))
	     (tcode-mazegaki-henkan
	      (let ((yomi-list (tcode-string-to-char-list real-yomi)))
		(if (<= (car yomi-list) 255)
		    1			; alphabet
		  (length yomi-list)))
	      (tcode-mazegaki-variable-yomi-p real-yomi)))))))

;;;###autoload
(defun tcode-mazegaki-delete-kanji (yomi kanji)
  "ɤ YOMI KANJI Υȥ򤼽񤭼񤫤롣"
  (interactive
   (let* ((minibuffer-setup-hook
	   ;; avoid referencing undefined variables in NEmacs.
	   (and (boundp 'minibuffer-setup-hook)
		(cons 'toggle-input-method minibuffer-setup-hook)))
	  (yomi (if tcode-in-mazegaki-p
		    (buffer-substring
		     (marker-position tcode-in-mazegaki-p)
		     (point))
		  (read-from-minibuffer "ɤ ")))
	  (found (save-excursion
		   (tcode-mazegaki-switch-to-dictionary)
		   (tcode-mazegaki-search-yomi yomi)))
	  (kouho (and found
		      (tcode-mazegaki-make-table-and-select
		       (format "ɤ %s " yomi))))
	  (yes (and (stringp kouho)
		    (y-or-n-p
		     (format
		      "ɤߡ%s״%sפޤ? "
		      yomi kouho))))
	  (kanji (cond (yes
			kouho)
		       ((not found)
			(error "ɤߡ%sפϿƤޤ" yomi))
		       ((error "")))))
     (list yomi kanji)))
  (save-excursion
    (tcode-mazegaki-switch-to-dictionary)
    (let ((dic-yomi (tcode-get-yomi-in-dictionary yomi)))
      (if (and (tcode-mazegaki-search-yomi dic-yomi)
	       (re-search-forward (concat "\\(/" kanji "\\)/")
				  (save-excursion (end-of-line) (point))
				  t))
	  (prog2			; 1ΤȤ t 
					; ʳ nil ֤
	      (progn
		(delete-region (match-beginning 1) (match-end 1))
		(tcode-mazegaki-find-kanji-entry))
	      (and (looking-at "$")
		   (prog1 t		; 1Τ
		     (beginning-of-line)
		     (delete-region (point) (progn (forward-line 1) (point)))))
	    (and (interactive-p)
		 (message "ɤߡ%s״%sפޤ" yomi kanji)))
	(and (interactive-p)
	     (progn
	       (ding)
	       (message "ɤߡ%s״%sפϿƤޤ"
			yomi kanji)))))))

(defun tcode-mazegaki-ikkatu-region (beg end func msg)
  "꡼μιܤ줾Ф FUNC ŬѤ롣
FUNC ؤϡɤߡ˴缡Ϥ롣

ιܤϰԤĻꤹ롣ƹԤν񼰤

ɤ //[/]*\\n"
  (interactive "r")
  (save-excursion
    (save-restriction
      (message "%s..." msg)
      (narrow-to-region beg end)
      (goto-char (point-min))
      (let ((line 1))
	(condition-case nil
	    (while (not (eobp))
	      (let* ((eol (save-excursion (end-of-line) (point)))
		     (bol (point))
		     (yomi (tcode-get-yomi-in-dictionary
			    (buffer-substring (point)
					      (progn
						(search-forward " /" eol)
						(goto-char (- (point) 2))
						(point))))))
		(re-search-forward "/$" eol)
		(goto-char (1- (point)))
		(while (re-search-backward "/\\(.+\\)" bol t)
		  (funcall func yomi (buffer-substring
				      (match-beginning 1)
				      (match-end 1))))
		(setq line (1+ line))
		(forward-line 1)))
	  (error
	   (ding)
	   (message "%d ܤǼν񼰤ְäƤޤ" line)))
	(message "%s...λ" msg))
      (widen))))

;;;###autoload
(defun tcode-mazegaki-ikkatu-toroku-region (beg end)
  "꡼μιܤ礷Ͽ롣
ν񼰤ϴؿ `tcode-mazegaki-ikkatu-region' 򻲾ȡ"
  (interactive "r")
  (tcode-mazegaki-ikkatu-region beg end 'tcode-mazegaki-toroku "Ͽ"))

;;;###autoload
(defun tcode-mazegaki-ikkatu-toroku-buffer (&optional buffer)
  "Хåեμιܤ礷Ͽ롣
ޥ `tcode-ikkatu-toroku-region' ȡ"
  (interactive)
  (save-excursion
    (and buffer
	 (set-buffer buffer))
    (tcode-mazegaki-ikkatu-toroku-region (point-min) (point-max))))

;;;###autoload
(defun tcode-mazegaki-ikkatu-delete-region (beg end)
  "꡼μιܤ礷ƺ롣
ν񼰤ϴؿ `tcode-mazegaki-ikkatu-region' 򻲾ȡ"
  (interactive "r")
  (tcode-mazegaki-ikkatu-region beg end 'tcode-mazegaki-delete-kanji ""))

;;;###autoload
(defun tcode-mazegaki-ikkatu-delete-buffer (&optional buffer)
  "Хåեμιܤ礷ƺ롣
ޥ `tcode-ikkatu-delete-region' ȡ"
  (interactive)
  (save-excursion
    (and buffer
	 (set-buffer buffer))
    (tcode-mazegaki-ikkatu-delete-region (point-min) (point-max))))

;;;###autoload
(defun tcode-mazegaki-delete-by-last-yomi (arg)
  "ǸϤɤߤ򤷡롣
 ARG  nil ǤʤȤϡɤߤ⿷Ϥ롣"
  (interactive "P")
  (if (or (null tcode-mazegaki-yomi-list)
	  arg)
      (call-interactively 'tcode-mazegaki-delete-kanji)
    (let* ((yomi (save-excursion
		   (tcode-mazegaki-switch-to-dictionary)
		   (beginning-of-line)
		   (looking-at "\\([^/]+\\) /")
		   (tcode-get-yomi-in-dictionary
		    (buffer-substring (match-beginning 1) (match-end 1)))))
	   (kanji (tcode-mazegaki-make-table-and-select
		   (format "ɤߡ%s״? " yomi))))
      (if (not (stringp kanji))
	  (message "")
	(and (y-or-n-p (format "ɤߡ%s״%sפޤ "
			       yomi kanji))
	     (tcode-mazegaki-delete-kanji yomi kanji))))))

;;;; ɤߤ䴰

(defun tcode-mazegaki-make-completion-prompt (yomi comp-list)
  "䴰䤬ʣΡΤΥץץȤʸ롣"
  (let* ((prompt (concat yomi "{"
			 (substring (car comp-list) (length yomi) nil)))
	 (max-len (- (frame-width) 12)) ; 12 is for postfix
	 (yomi-len (length yomi))
	 (diff (substring (car (setq comp-list (cdr comp-list)))
			  yomi-len nil))
	 (new-prompt (concat prompt ", " diff)))
    (concat
     (catch 'overflow
       (while comp-list
	 (or (< (string-width new-prompt) max-len)
	     (throw 'overflow prompt))
	 (setq prompt new-prompt
	       comp-list (cdr comp-list)
	       diff (and comp-list
			 (substring (car comp-list) yomi-len nil))
	       new-prompt (concat prompt ", " diff)))
       prompt)
     (if comp-list
	 (format ",  (+%d)" (length comp-list))
       "}"))))

;;;###autoload
(defun tcode-mazegaki-complete (&optional henkan)
  "򤼽񤭼ɤߤ䴰Ԥ
䤬ʣȤΥƤϼΤȤꡣ

    SPC		θƬˤ
    DEL		ǸθƬˤ
    TAB		Ƭθ䴰λ
    LFD		Ƭθ䴰λθѴ
    RET		򤻤䴰λ

HENKAN  nil ǤʤȤ䴰(䴰ԤäΤ)ѴԤ"
  (interactive "*P")
  (setq tcode-mazegaki-yomi-list (tcode-mazegaki-get-reverse-yomi-list))
  (let ((yomi-len (length tcode-mazegaki-yomi-list)))
    (or tcode-mazegaki-yomi-list
	(error "䴰Ǥޤ"))
    (let* ((yomi-prefix
	    (catch 'found
	      (while (> yomi-len 0)
		(let ((yomi (regexp-quote
			     (tcode-mazegaki-construct-yomi yomi-len))))
		  (save-excursion
		    (tcode-mazegaki-switch-to-dictionary)
		    (tcode-mazegaki-search-yomi yomi)
		    (and (looking-at yomi)
			 (or (not (looking-at (concat yomi " /")))
			     (save-excursion
			       (forward-line 1)
			       (looking-at yomi)))
			 (throw 'found yomi))))
		(and tcode-in-mazegaki-p
		     tcode-mazegaki-yomi-fixed-p
		     (throw 'found nil))
		(setq yomi-len (1- yomi-len)))))
	   (completion-list
	    (and yomi-prefix
		 (save-excursion
		   (tcode-mazegaki-switch-to-dictionary)
		   (let (list yomi (i 0))
		     (while (looking-at (concat "\\(" yomi-prefix ".*\\) /"))
		       (setq yomi (buffer-substring
				   (match-beginning 1)
				   (match-end 1)))
		       (setq i (1+ i))
		       (and (> i tcode-mazegaki-complete-max)
			    (error "%sפϸο¿ޤ"
				   yomi-prefix))
		       (or (string= yomi yomi-prefix)
			   (setq list (nconc list (list (cons yomi nil)))))
		       (forward-line 1))
		     list))))
	   (most (and completion-list
		      (try-completion yomi-prefix completion-list)))
	   comp)
      (or completion-list
	  (error "䴰Ǥޤ"))
      ;; for NEmacs
      (and (stringp most)
	   (let ((last-char (aref most (1- (length most)))))
	     (and (= (mod (string-width most) 2) 1)
		  (> last-char 127)
		  (<= last-char 255)
		  (setq most (substring most 0 -1))
		  (string= yomi-prefix most)
		  (setq most nil))))
      ;; 䴰Ǥʬ䴰
      (or (null most)
	  (progn
	    (delete-region (tcode-mazegaki-beginning tcode-mazegaki-yomi-list
						     yomi-len)
			   (point))
	    (insert (if (stringp most)
			most
		      yomi-prefix))
	    (tcode-do-auto-fill)))
      (and (stringp most)
	   (setq yomi-prefix most))
      (setq comp (and completion-list
		      (all-completions yomi-prefix completion-list)))
      (or (<= (length comp) 1)
	  ;; ⡼
	  (progn
	    (catch 'quit
	      (while t
		(message (tcode-mazegaki-make-completion-prompt
			  yomi-prefix comp))
		(let ((ch (read-char)))
		  (cond ((= ch ? )
			 ;; θƬ
			 (setq comp (nconc (cdr comp) (list (car comp)))))
			((= ch ?\C-?)
			 ;; ǸθƬ
			 (let ((list comp))
			   (while (and (cdr list)
				       (cdr (cdr list)))
			     (setq list (cdr list)))
			   (setq comp (append (cdr list) comp))
			   (rplacd list nil)))
			((or (= ch ?\t)
			     (= ch last-command-char))
			 ;; Ƭθ򤷤ƽλ
			 (insert (substring (car comp)
					    (length yomi-prefix) nil))
			 (tcode-do-auto-fill)
			 (throw 'quit t))
			((= ch ?\n)
			 ;; Ƭθ򤷤ƽλλѴ
			 (insert (substring (car comp)
					    (length yomi-prefix) nil))
			 (tcode-do-auto-fill)
			 (setq henkan t)
			 (throw 'quit t))
			((= ch ?\r)
			 ;; 򤻤λ
			 (setq henkan nil)
			 (throw 'quit t))
			(t
			 ;; λΥޥɤ¹
			 (tcode-redo-command ch)
			 (setq henkan nil)
			 (throw 'quit t))))))
	    (or (tcode-mazegaki-in-minibuffer-p)
		(message ""))))
      (and henkan
	   (tcode-mazegaki-henkan nil)))))

;;;###autoload
(defun tcode-mazegaki-complete-and-henkan ()
  "򤼽񤭼ɤߤ䴰ԤθѴ롣
ܺ٤ϥޥ `tcode-mazegaki-complete-and-henkan' ȡ"
  (interactive "*")
  (tcode-mazegaki-complete t))

;;;; ¾(Ƥ伭¸ʤ)

(defun tcode-mazegaki-backward-delete-char (arg)
  "ޥ `backward-delete-char' Ʊ˸򤼽Ѵλ롣
򤼽ѴλΤϡäȤ"
  (interactive "*p")
  (if (<= (point) (marker-position tcode-in-mazegaki-p))
      (tcode-mazegaki-kakutei)
    (backward-delete-char arg)))

(defun tcode-mazegaki-command-summary ()
  "򤼽ѴΥγưɽ롣
ɽƤϡѿ `tcode-mazegaki-command-summary-alist' ǻꤹ롣"
  (interactive)
  (message
   (mapconcat
    (function
     (lambda (elm)
       (let* ((key (where-is-internal (cdr elm) tcode-mazegaki-input-map t))
	      (key-str (if (null key)
			   (error
			    (concat "`tcode-mazegaki-command-summary-alist' "
				    "δؿ̾˴ְ㤤ޤ"))
			 (key-description key))))
	 (format "%s=%s" key-str (car elm)))))
    tcode-mazegaki-command-summary-alist " ")))

;;;###autoload
(defun tcode-start-fixed-mazegaki ()
  "ַθ򤼽Ѵ򳫻Ϥ롣"
  (interactive)
  (let (tcode-auto-help)
    (tcode-mazegaki-kakutei))
  (if (stringp tcode-mazegaki-prefix-mark)
      (insert tcode-mazegaki-prefix-mark)
    (add-hook 'post-command-hook 'tcode-mazegaki-put-henkan-face))
  (setq tcode-in-mazegaki-p (point-marker)
	tcode-mazegaki-yomi-list nil))

(defun tcode-mazegaki-unset-key (key)
  "򤼽Ѵ⡼ɤˤ KEY ̵ˤ롣"
  (define-key tcode-mazegaki-input-map key
    'tcode-mazegaki-kakutei-and-self-insert))

(defun tcode-save-jisyo ()
  "򤼽񤭼(ѹƤ)ե¸롣"
  (interactive)
  (and (memq tcode-mazegaki-buffer (buffer-list)) ; buffer is deleted?
       (buffer-modified-p tcode-mazegaki-buffer) ; buffer is modified
       (let ((filename (expand-file-name tcode-mazegaki-dictionary-name))
	     (backup-inhibited t))
	 (and tcode-mazegaki-dictionary-backup-name
	      (rename-file filename
			   (expand-file-name
			    tcode-mazegaki-dictionary-backup-name)
			   t))
	 (save-excursion
	   (set-buffer tcode-mazegaki-buffer)
	   (write-region (point-min) (point-max) filename)
	   (set-buffer-modified-p nil)))))

(defun tcode-self-insert-or-henkan (arg)
  "ޥ `self-insert-command' Ʊ򤼽ѴԤ
򤼽ѴԤΤϡɤߡפϤƤΤߡ
ѴԤ tԤʤ nil ֤"
  (interactive "*P")
  (if (not tcode-in-mazegaki-p)
      (self-insert-command
       (prefix-numeric-value arg))	; `self-insert-command'  nil ֤
    (tcode-mazegaki-henkan nil current-prefix-arg)
    t))					; ѴȤ t ֤

(unless (featurep 'tc-mazegaki)
  (setq tcode-mazegaki-input-map (make-keymap))

  (tcode-define-key-for-all-chars tcode-mazegaki-input-map
				  'tcode-mazegaki-kakutei-and-self-insert)

  (define-key tcode-mode-map " " 'tcode-self-insert-or-henkan)
  (aset tcode-keymap-table 0 -3)

  (mapcar
   (function (lambda (elm)
	       (define-key tcode-mazegaki-input-map (car elm) (cdr elm))))
   '((" "     . tcode-mazegaki-select-kouho-or-relimit)
     ("\C-u"  . tcode-mazegaki-restore-yomi-and-quit)
     ("\C-m"  . tcode-mazegaki-kakutei)
     ("<"     . tcode-mazegaki-relimit-left)
     (">"     . tcode-mazegaki-relimit-right)
     ("|"     . tcode-mazegaki-toroku-and-kakutei)
     ("\C-\?" . tcode-mazegaki-backward-delete-char)
     ("?"     . tcode-mazegaki-command-summary)))

  (or (not (boundp 'minor-mode-map-alist))
      (assq 'tcode-mazegaki-mode minor-mode-map-alist)
      (setq minor-mode-map-alist
	    (cons (cons 'tcode-mazegaki-mode tcode-mazegaki-input-map)
		  minor-mode-map-alist)))

  (run-hooks 'tcode-mazegaki-init-hook))

(provide 'tc-mazegaki)

;;; tc-mazegaki.el ends here
