/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#ifndef _VFUDIR_H_
#define _VFUDIR_H_

extern int DirTreeChanged;

//
// file: vfudir.cpp
//
char* GetDirName(const char *prompt, const char *defaultdir, int ShouldExist = 1 );
void AddToChDirHistory( char* pS );
void ChDir( const char *NewDir = NULL );
void ChDirHistory();

extern long DirSizeFCount; // dir count
extern long DirSizeDCount; // files count
fsize_t DirSize( const char *s );

void LoadTree();
void SaveTree();
void DropTree();
void RebuildTree();
void ViewTree();

int  DirTreeIndex( const char *s );
fsize_t DirTreeGetSize( const char *s );
void DirTreeSetSize( const char *s, fsize_t size );
const char* DirTreeFind( const char *s ); // return full path by dirname
int DirTreeFind( const char *s, PSZCluster *sc ); // return count of found dirnames and stores them to sc

#endif //_VFUDRI_H_

