# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: bookmarker.sql,v 1.5 1999/07/04 19:58:00 prenagha Exp $
# ---------------------------------------------------------------

#
# Table structure for table 'active_sessions'
#
CREATE TABLE active_sessions (
  sid varchar(32) DEFAULT '' NOT NULL,
  name varchar(32) DEFAULT '' NOT NULL,
  val text,
  changed varchar(14) DEFAULT '' NOT NULL,
  PRIMARY KEY (name,sid),
  KEY changed (changed)
);

#
# Table structure for table 'auth_user'
#
CREATE TABLE auth_user (
  uid varchar(32) DEFAULT '' NOT NULL,
  username varchar(32) DEFAULT '' NOT NULL,
  password varchar(32) DEFAULT '' NOT NULL,
  perms varchar(255),
  name varchar(50) DEFAULT '' NOT NULL,
  email varchar(50) DEFAULT '' NOT NULL,
  PRIMARY KEY (uid),
  UNIQUE k_username (username)
);

#
# sample data for table 'auth_user'
#

INSERT INTO auth_user (uid, username, password, perms, name, email) VALUES ('5647980gfdsjklgfduiyo78','bk','7e7ec59d1f4b21021577ff562dc3d48b','admin', 'Bookmarker Admin', 'bookmarker@myhost.com');
INSERT INTO auth_user (uid, username, password, perms, name, email) VALUES ('7947980abcsjklgfduiyo78','guest','084e0343a0486ff05530df6c705c8bb4','guest', 'Guest User', 'bk-guest@myhost.com');

#
# Table structure for table 'bookmark'
#
CREATE TABLE bookmark (
  id int(11) DEFAULT '0' NOT NULL auto_increment,
  url varchar(255) DEFAULT '' NOT NULL,
  name varchar(255) DEFAULT '' NOT NULL,
  ldesc varchar(255) DEFAULT '' NOT NULL,
  keywords varchar(255),
  category_id tinyint(4) DEFAULT '0' NOT NULL,
  subcategory_id tinyint(4) DEFAULT '0' NOT NULL,
  rating_id tinyint(4) DEFAULT '0' NOT NULL,
  username varchar(32) DEFAULT '' NOT NULL,
  PRIMARY KEY (id),
  KEY username (username)
);

#
# sample data for table 'bookmark'
#
INSERT INTO bookmark (id, url, name, ldesc, keywords, category_id, subcategory_id, rating_id, username) VALUES (1,'http://www.php.net/','PHP','PHP: Hypertext Preprocessor','php',1,1,3,'bk');
INSERT INTO bookmark (id, url, name, ldesc, keywords, category_id, subcategory_id, rating_id, username) VALUES (2,'http://phplib.shonline.de/','PHPLIB','PHPLIB: Class Library for PHP','php library',1,1,3,'bk');
INSERT INTO bookmark (id, url, name, ldesc, keywords, category_id, subcategory_id, rating_id, username) VALUES (3,'http://www.mysql.net/','MySQL','MySQL Relational Database','db sql php',1,1,3,'bk');
INSERT INTO bookmark (id, url, name, ldesc, category_id, subcategory_id, rating_id, username) VALUES (4,'http://www.apache.org/','Apache','Apache Web Server',1,1,3,'bk');
INSERT INTO bookmark (id, url, name, ldesc, category_id, subcategory_id, rating_id, username) VALUES (5,'http://www.renaghan.com/bookmarker/','bookmarker','bookmarker Web based bookmark mangement tool',1,1,3,'bk');

#
# Table structure for table 'category'
#
CREATE TABLE category (
  id tinyint(3) unsigned DEFAULT '0' NOT NULL,
  name varchar(30) DEFAULT '' NOT NULL,
  username varchar(32) DEFAULT '' NOT NULL,
  PRIMARY KEY (id,username)
);

#
# sample data for table 'category'
#

INSERT INTO category (id, name, username) VALUES (0,'unassigned','bk');
INSERT INTO category (id, name, username) VALUES (1,'linux','bk');

#
# Table structure for table 'rating'
#
CREATE TABLE rating (
  id tinyint(3) unsigned DEFAULT '0' NOT NULL,
  name varchar(30) DEFAULT '' NOT NULL,
  username varchar(32) DEFAULT '' NOT NULL,
  list_tag varchar(255),
  PRIMARY KEY (id,username)
);

#
# sample data for table 'rating'
#
INSERT INTO rating (id, name, username, list_tag) VALUES (0,'not rated','bk','');
INSERT INTO rating (id, name, username, list_tag) VALUES (1,'weak','bk',NULL);
INSERT INTO rating (id, name, username, list_tag) VALUES (2,'good','bk',NULL);
INSERT INTO rating (id, name, username, list_tag) VALUES (3,'excellent','bk',NULL);

#
# Table structure for table 'subcategory'
#
CREATE TABLE subcategory (
  id tinyint(3) unsigned DEFAULT '0' NOT NULL,
  name varchar(30) DEFAULT '' NOT NULL,
  username varchar(32) DEFAULT '' NOT NULL,
  PRIMARY KEY (id,username)
);

#
# sample data for table 'subcategory'
#
INSERT INTO subcategory (id, name, username) VALUES (0,'unassigned','bk');
INSERT INTO subcategory (id, name, username) VALUES (1,'development','bk');

#
# Table structure for table 'search'
#
CREATE TABLE search (
  id tinyint(3) unsigned DEFAULT '0' NOT NULL auto_increment,
  name varchar(30) DEFAULT '' NOT NULL,
  query varchar(255) DEFAULT '' NOT NULL,
  username varchar(32) DEFAULT '' NOT NULL,
  PRIMARY KEY (id,username)
);
