<?php 
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: create.php3,v 1.15 1999/07/08 12:13:42 prenagha Exp $
# ---------------------------------------------------------------
include("bkprepend.php3");
page_open(array( "sess" => "bk_sess"
          ,"auth" => "bk_cr_auth"
				  ,"perm" => "bk_perm"
				  ,"user" => "bk_user"));

$tpl->define(array(
  standard   => "common.standard.tpl",
  msie_js    => "common.msie_js.tpl",
  body       => "create.body.tpl",
  possible_dup        => "create.possible_dup.tpl",
  possible_dup_lines  => "create.possible_dup.line.tpl",
  msg        => "common.message.tpl",
  error_msg  => "common.error_message.tpl"
));

set_standard("create", &$tpl);

# if browser is MSIE, then need to add this bit
# of javascript to the page so that MSIE correctly
# brings quik-mark and mail-this-link popups to the front.
if (check_browser() == "MSIE") {
  $tpl->parse(MSIE_JS, "msie_js");
}

set_bkusername(); 

## initialize variable that holds id of newly created bookmark
$id = 0;

### Submit Handler
### Get a database connection
$db   = new bk_db;

## Check if there was a submission
while ( is_array($HTTP_POST_VARS) 
     && list($key, $val) = each($HTTP_POST_VARS)) {
  switch ($key) {

  ## Create a new bookmark
  case "bk_create":

    ## Do we have permission to do so?
    if (!$perm->have_perm("editor")) {
      $error_msg .= "You do not have permission to create bookmarks.";
      break;
    }

    ## Trim form fields
		$url = $validate->strip_space($url);
		$name = trim($name);
		$desc = trim($desc);
    $keyw = trim($keyw);
		
    ## Do we have all necessary data?
    if (empty($url) || empty($name)) {
      $error_msg .= "Please fill out <B>URL</B> and <B>Name</B>!";
      break;
    }

    ## Must set these codes
    if (isset($category) AND isset($subcategory) AND isset($rating)) {
    } else {
      $error_msg .= "Please select a <strong>Category</strong>, <strong>Subcategory</strong>, and <strong>Rating</strong>!";
      break;
    }

  ## does the admin want us to check URL format
	  if ($bookmarker->url_format_check > 0 ) {
	## Is the URL format valid
      if (!$validate->is_url($url))  { 
        $format_msg = "URL invalid. Format must be <strong>http://</strong> or <strong>ftp://</strong> followed by a valid hostname and URL!<br><small> $validate->ERROR </small>";

	## does the admin want this formatted as a warning or an error?
				if ( $bookmarker->url_format_check == 2 ) {
				  $error_msg .= $format_msg;
          break;
				} else {
				  $msg .= $format_msg;
			  }
	    }
    }		
    
    ## Does the bookmark already exist?
    ## NOTE: This should be a transaction, but it isn't...
    $query = sprintf("select id from bookmark where url='%s' and username = '%s'",$url, $bkusername);
    $db->query($query);
    if ($db->nf() > 0) {
      $error_msg .= sprintf("URL <B>%s</B> already exists!", $url);
      break;
    }

    ## Insert the bookmark
    $query = sprintf("insert into bookmark (url, name, ldesc, keywords, category_id, subcategory_id, rating_id, username) values('%s', '%s', '%s','%s',%s,%s,%s, '%s')", $url, addslashes($name), addslashes($desc), addslashes($keyw), $category, $subcategory, $rating, $bkusername);
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg .= "<b>Insert failed:</b> $query";
      break;
    }
    ## get the id of the new row
  	$id = $db->insert_id();

  	$maintain_url = "maintain.php3?id=".$id;
    $msg .= sprintf("Bookmark %s created sucessfully.<br>Click <a href=\"%s\">here</a> to modify this bookmark.<a href=\"maillink.php3?id=%s\"><img width=14 height=10 align=top border=0 src=\"%smailto.gif\"></a>", $id, $sess->url($maintain_url), $id, $bookmarker->image_url_prefix);
		
  	## Does the URL respond
    if (!$validate->url_responds($url))  { 
      $msg .= "<BR><strong>**WARNING**</strong>: The URL you entered is not responding!<br><small> $validate->ERROR </small>";
		}

    ## Update the PHPLIB user variable that keeps track of how
		## many bookmarks this user has.
		$user->register("user_total_bookmarks");
    $query = sprintf("select count(*) as nbr_bookmarks from bookmark where username = '%s'", $bkusername);
    $db->query($query);
    if ($db->next_record()){
      $user_total_bookmarks = $db->f("nbr_bookmarks");
    }

    break;

  default:
    break;
 }
}

if (isset ($error_msg)) {
  $tpl->assign(ERROR_MSG_TEXT, $error_msg);
  $tpl->parse(ERROR_MSG, "error_msg");
}

if (isset ($msg)) {
  $tpl->assign(MSG_TEXT, $msg);
  $tpl->parse(MSG, "msg");
}

# if dislpaying b/c of error, show previous data
if ($url > "") {
  $default_url = $url;
# otherwise default from URL if available
} elseif ($curl > "") {
  $default_url = $curl;
# otherwise just default to http://
} else {
  $default_url = "http://";
}

# if dislpaying b/c of error, show previous data
if ($name > "") {
  $default_name = $name;
# otherwise default from URL if available
} elseif ($ctitle > "") {
  $default_name = $ctitle;
} else {
  $default_name = "";
}

# if dislpaying b/c of error, show previous data
if ($desc > "") {
  $default_desc = $desc;
# otherwise default from URL if available
} elseif ($ctitle > "") {
  $default_desc = $ctitle;
} else {
  $default_desc = "";
}

# if dislpaying b/c of error, show previous data
if ($keyw > "") {
  $default_keyw = $keyw;
} else {
  $default_keyw = "";
}

# if dislpaying b/c of error, show previous data
if ($category > 0) {
  $default_category = $category;
} else {
  $default_category = 0;
}

# if dislpaying b/c of error, show previous data
if ($subcategory > 0) {
  $default_subcategory = $subcategory;
} else {
  $default_subcategory = 0;
}

# if dislpaying b/c of error, show previous data
if ($rating > 0) {
  $default_rating = $rating;
} else {
  $default_rating = 0;
}

## Check to see if any existing bookmarks are a "close match".
if ( $default_url != "http://") {
  $db_dup   = new bk_db;
	
## the "close match" consists of looking for other URLs at the
## hostname that match the first $bookmarker->possible_dup_chars
## after the hostname.
	$url_elements = parse_url($default_url);
	$hostname	= $url_elements[host];
  $scheme		= $url_elements[scheme];
	$path_part = substr($url_elements[path], 0, $bookmarker->possible_dup_chars);
	$look_for = $scheme."://".$hostname.$path_part."%";
	
  $query = sprintf("select url, name from bookmark where url like '%s' and username = '%s'", $look_for, $bkusername);

## if we just created a bookmark, make sure to not include it in the check
## otherwise we ALWAYS find a possible dup!
  if ( $id > 0 ) {
	  $query = $query. sprintf(" and id <> %s ", $id);
	}

  $db_dup->query($query);
  while ($db_dup->next_record()){
    $tpl->assign(array(
      DUP_URL            => $db_dup->f("url"),
      DUP_NAME           => htmlspecialchars(stripslashes($db_dup->f("name")))
	  ));
    $tpl->parse(POSSIBLE_DUP_LINES, ".possible_dup_lines");
		$possible_dups_found = TRUE;
  }
  if ($possible_dups_found){
    $tpl->parse(POSSIBLE_DUP, "possible_dup");
  }
}

load_ddlb("category", $default_category, $bkusername, &$category_select, FALSE);
load_ddlb("subcategory", $default_subcategory, $bkusername, &$subcategory_select, FALSE);
load_ddlb("rating", $default_rating, $bkusername, &$rating_select, FALSE);

$tpl->assign(array(
  FORM_ACTION            => $sess->self_url(),
  DEFAULT_URL            => $default_url,
  DEFAULT_NAME           => htmlspecialchars(stripslashes($default_name)),
  DEFAULT_DESC           => htmlspecialchars(stripslashes($default_desc)),
  DEFAULT_KEYW           => htmlspecialchars(stripslashes($default_keyw)),
	DEFAULT_CATEGORY       => $default_category,
  DEFAULT_SUBCATEGORY    => $default_subcategory,
  DEFAULT_RATING         => $default_rating,
  CATEGORY_SELECT        => $category_select,
  SUBCATEGORY_SELECT     => $subcategory_select,
  RATING_SELECT          => $rating_select
));

$tpl->parse(BODY, "body");
$tpl->parse(MAIN, "standard");
$tpl->FastPrint();

page_close();
?>
