<?php 
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: search.php3,v 1.15 1999/07/08 12:12:42 prenagha Exp $
# ---------------------------------------------------------------
require("bkprepend.php3");
page_open(array( "sess" => "bk_sess"
              ,"auth" => "bk_cr_auth"
		          ,"perm" => "bk_perm"
		          ,"user" => "bk_user"));
include("plist.inc");

$tpl->define(array(
  standard   => "common.standard.tpl",
  body       => "search.body.tpl",
  results    => "search.results.tpl",
  msg        => "common.message.tpl",
  error_msg  => "common.error_message.tpl"
));

set_standard("search", &$tpl);

set_bkusername(); 

### Submit Handler
### Get a database connection
$db   = new bk_db;

// the following fields are selectable
$field = array(
	 "bookmark.name" 	    => "Name"
	,"bookmark.keywords" 	=> "Keywords"
	,"bookmark.url"		    => "URL"
	,"bookmark.ldesc"	    => "Description"
	,"category.name" 	    => "Category"
	,"subcategory.name" 	=> "Sub Category"
	,"rating.name"		    => "Rating"
	,"bookmark.id"		    => "ID");

# PHPLIB's sqlquery class loads this string when
# no query has been specified.
$noquery = "1=0";

# if we don't have a query object for this session yet,
# then create one and save as a session variable.
if (!isset($q)) {
	$q = new bk_Sql_Query;
	$sess->register("q");
}

# if a WHERE clause was specified in the URL, then use it
if (isset($where)) {
  $q->query = base64_decode($where);
}

## Check if there was a submission
while ( is_array($HTTP_POST_VARS) 
     && list($key, $val) = each($HTTP_POST_VARS)) {
  switch ($key) {

  ## Load a Saved Search
  case "bks_load":
    ## Do we have all necessary data?
    if ($search > 0 ) {
		} else {
      $error_msg .= "Please select a <strong>Saved Search</strong> to load!";
      break;
    }

    ## get the saved search
    $query = sprintf("select query from search where id=%s and username='%s'", $search, $bkusername);
    $db->query($query);
    if ($db->next_record()){
      $q->query = $db->f("query");
    } else {
      $error_msg .= "Saved Search not found in database!";
      break;
    }
    
    $msg .= "Saved Search loaded sucessfully.";
	break;

  ## Change Saved Search
  case "bks_save":
    ## Do we have permission to do so?
    if (!$perm->have_perm("editor")) {
      $error_msg .= "You do not have permission to change Saved Searches.";
      break;
    }

    ## Do we have all necessary data?
    if ($search > 0 ) {
		} else {
      $error_msg .= "Please select a <strong>Saved Search</strong> to update!";
      break;
    }

    if ($q->query == $noquery) {
		  $error_msg .= "No query to save!";
      break;
    }

    ## Update bookmark information.
    $query = sprintf("update search set query='%s' where id=%s and username='%s'", addslashes($q->query), $search, $bkusername);
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg .= "<b>Update failed:</b> $query";
      break;
    }
    
    $msg .= "Saved Search changed sucessfully.";
		
	break;

  ## Delete the saved search
  case "bks_delete":
    ## Do we have permission to do so?
    if (!$perm->have_perm("editor")) {
      $error_msg .= "You do not have permission to delete Saved Searches.";
      break;
    }

    ## Do we have all necessary data?
    if ($search > 0 ) {
		} else {
      $error_msg .= "Please select a <strong>Saved Search</strong> to delete!";
      break;
    }

    ## Delete that bookmark.
    $query = sprintf("delete from search where id='%s' and username='%s'", $search, $bkusername);
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg .= "<b>Delete failed:</b> $query";
      break;
    }
    
    $msg .= "Saved Search deleted sucessfully.";

  break;

  ## Create a new saved search
  case "bks_create":

    ## Do we have permission to do so?
    if (!$perm->have_perm("editor")) {
      $error_msg .= "You do not have permission to create Saved Searches.";
      break;
    }

    ## Trim form fields
		$name = trim($name);
		
    ## Do we have all necessary data?
    if (empty($name)) {
      $error_msg .= "Please enter a <B>Name</B> for the Saved Search!";
      break;
    }

    if ($q->query == $noquery) {
      $error_msg .= "No query to save!";
      break;
    }

    ## Does the bookmark already exist?
    ## NOTE: This should be a transaction, but it isn't...
    $query = sprintf("select id from search where name='%s' and username = '%s'",addslashes($name), $bkusername);
    $db->query($query);
    if ($db->nf() > 0) {
      $error_msg .= sprintf("Saved Search named <B>%s</B> already exists!", $url);
      break;
    }

    ## Insert the bookmark
    $query = sprintf("insert into search (name, query, username) values('%s', '%s', '%s')", addslashes($name), addslashes($q->query), $bkusername);
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg .= "<b>Insert failed:</b> $query";
      break;
    }
    ## get the id of the new row
  	$id = $db->insert_id();

    $msg .= "Saved Search created sucessfully.";
    break;
  
  default:
  break;
 }
}

if (isset ($error_msg)) {
  $tpl->assign(ERROR_MSG_TEXT, $error_msg);
  $tpl->parse(ERROR_MSG, "error_msg");
}

if (isset ($msg)) {
  $tpl->assign(MSG_TEXT, $msg);
  $tpl->parse(MSG, "msg");
}

# build the where clause based on user entered fields
if (isset($x)) {
  $q->query = $q->where("x", 1);
}

# load the list of previously saved searches
# and prepare the save search form
load_ddlb("search", $search, $bkusername, &$search_select, FALSE);
$tpl->assign(array(
  SEARCH_SELECT => $search_select,
  FORM_ACTION   => $sess->self_url()
));

# build the search form
$tpl->assign(QUERY_FORM, $q->form("x", $field, "qry", ""));

if ($q->query == $noquery) {
} else {
  
  $limit = 0;
  $offset = 0;

  print_list ($q->query, $bkusername, $limit, $offset, &$bookmark_list);
	
  $tree_search_url = $sess->url( "tree.php3?where=" . base64_encode($q->query));
  $tpl->assign(array(
	  QUERY_CONDITION => htmlspecialchars($q->query),
	  BOOKMARK_LIST   => $bookmark_list,
		TREE_SEARCH_URL => $tree_search_url
  ));
  $tpl->parse(QUERY_RESULTS, "results");
}

$tpl->parse(BODY, "body");
$tpl->parse(MAIN, "standard");
$tpl->FastPrint();

page_close();
?>
