/* TCPgeturl.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>

#include "url.h"
#include "express.h"
#include "util.h"


extern int	errno;
extern char	*syserrlist[];


/*
 * parse a URL, in the relative context of rel_url
 */
URL *parse_url(char *url, char *rel_url)
{
   URL *ret_url;
   char *protocol=NULL, *port=NULL, *loc=NULL, *rloc=NULL;
   char *url_copy, *rel_url_copy=NULL;
   int use_rel=0; /* whether or not using rel_url */
   int len;
 
#ifdef DEBUG
   fprintf(stderr, "in parse_url()\n");
#endif

   len = strlen(url) + 2;
   if(len==2) return NULL;
   
   if((ret_url = (URL *)pmalloc(sizeof(struct _URL), "ret_url"))==NULL) {
      cleanexit(0);
   }
   bzero(ret_url, sizeof(struct _URL));

   strcpy(ret_url->path, (const char *)"/");

   url_copy = (char *)pmalloc(len, "url_copy");
   bzero(url_copy, len);
   strcpy(url_copy, url);

   if(rel_url) {
#ifdef DEBUG
     fprintf(stderr, "rel_url ok to use\n");
#endif
     use_rel=1;
     rel_url_copy = (char *)pmalloc(len, "rel_url_copy");
     bzero(rel_url_copy, len);
     strcpy(rel_url_copy, rel_url);
   } else {
#ifdef DEBUG
     fprintf(stderr, "can't use rel_url!\n");
#endif
   }
   if((loc=strstr(url_copy, (const char *)"://"))) {
#ifdef DEBUG
      fprintf(stderr, "Ok, got full url\n");
#endif
      use_rel=0;
      protocol=strtok(url_copy, (const char *)"://");   
      loc += 3;
   }
   else if(use_rel) {
#ifdef DEBUG
     fprintf(stderr, "need rel_url!\n");
#endif
     use_rel=1;
     loc = url_copy;
     if((rloc=strstr(rel_url_copy, (const char *)"://"))) {
       protocol = strtok(rel_url_copy, (const char *)"://");
       rloc += 3;
     } else {
       /* you've got to be kidding */
       /* flag a url error */
#if 0
      protocol = "http";
#endif
     }
   }

   if(!strcmp(protocol, "file")) {
      ret_url->protocol = URL_FILE;
      strcpy(ret_url->path, loc);
   } else if (!strcmp(protocol, "http")) {
#ifdef DEBUG
      fprintf(stderr, "loc: %s\n", loc);
#endif
      ret_url->protocol = URL_HTTP;
      if(use_rel) {
        sprintf(ret_url->host, "localhost");
        sprintf(ret_url->path, "/");
        ret_url->port = 80;
#if 0
        strcpy(ret_url->host, strtok(rloc, (const char *)"/"));
#if 0
        if(*loc == '/') {
          /* relative url, absolute path */
          strcpy(ret_url->path, loc);
        } else {
          sprintf(ret_url->path, "/%s", rloc+strlen(ret_url->host)+1);
        }
#endif
#endif
      } else {
#ifdef DEBUG
        printf("loc: %s\n", loc);
#endif
        strcpy(ret_url->host, strtok(loc, (const char *)"/"));
#ifdef DEBUG
        printf("host: %s\n", ret_url->host);
#endif

        /*sprintf(ret_url->path, "/%s", ret_url->host+strlen(ret_url->host)+1);*/
        sprintf(ret_url->path, "/%s", loc+strlen(ret_url->host)+1);
#ifdef DEBUG
        printf("path: %s\n", ret_url->path);
#endif
#if 0
      }
#endif
   
      if((port = strpbrk(ret_url->host, (const char *)":")) != NULL) {
         *port++ = '\0';
      }
      else {   
         port = "80";
      }
      ret_url->port = atoi(port);

      }

   } else if (!strcmp(protocol, "ftp")) {
      ret_url->protocol = URL_FTP;
   }
   
  if(ret_url->protocol==URL_HTTP && ret_url->port==80) {
    sprintf(ret_url->url, "%s://%s%s", protocol, ret_url->host, ret_url->path);
  } else {
    sprintf(ret_url->url, "%s://%s:%d%s", protocol, ret_url->host, ret_url->port, ret_url->path);
  }
#ifdef DEBUG
  fprintf(stderr, "%s\n", ret_url->url);
#endif

#if 0
   fprintf(stderr, "host: %s\nport: %d\npath: %s\n",
	   ret_url->host, ret_url->port, ret_url->path);
#endif

   return ret_url;
}

#if 0
char *form_url(char *dest, url_ds url)
{
  return dest;
}
#endif

#if 0
char *rel_url(url_ds prev_url, char *unqualified)
{
  char *new_url;
  url_ds new_url_ds;

  new_url_ds = parse_url(unqualified);
  fprintf(stderr, "host: %s\nport: %d\npath: %s\n",
	   new_url_ds->host, new_url_ds->port, new_url_ds->path);
   

  new_url = (char *)pmalloc(sizeof(char) * URL_LEN, "new_url");

  strcpy(new_url, unqualified);

  return new_url;
}
#endif

