package HNS::Calendar::NoTable;
################################################################
# HNS::Calendar::NoTable;
#
# usage:
#  my $cal = new HNS::Calendar::NoTable(year=>$y, month=>$m, col=>$col);
#  print $cal->AsHTML;
#
# $Id: NoTable.pm,v 1.10 1999/06/01 00:48:44 kenji Exp $
################################################################
use strict;
use ObjectTemplate;
@HNS::Calendar::NoTable::ISA = qw(ObjectTemplate);

attributes qw();

use Time::Local;
use DateTime::Date;
use HNS::Collection;
use HNS::Template;

# template
use vars qw($NextTemplate $PrevTemplate $ThisTemplate 
		$DayCurrentTemplate $DayNonCurrentTemplate);

$NextTemplate = qq(<a href="?%year%month">Next</a>);
$PrevTemplate = qq(<a href="?%year%month">Prev</a>);
$ThisTemplate = qq(<a href="?%year%month">%year/%month</a>);
$DayCurrentTemplate = qq(<a href="%ruri#%{ymd}0">%day</a>);
$DayNonCurrentTemplate = qq(<a href="./?%year%month%high#%{ymd}0">%day</a>);

################################################################
sub AsHTML ($)
{
    my ($self, $year, $month, $col) = @_;
    ($year, $month) = (sprintf("%04d", $year), sprintf("%02d", $month));

    my $html;
    my $templ = new HNS::Template;
    
    # month
    my $date = new DateTime::Date(year=>$year, month=>$month, day=>1);
    $html .= "\n";
    $html .= $templ->Expand($ThisTemplate,
			    {year=>$date->year,
			     month=>sprintf("%02d", $date->month)});
    $html .= "\n";
    # day
    my $start_week = $date->week;
    # 1..31
    for my $day (1..$date->DaysMonth){
	my $w = ($day+$start_week-1)%7;

	my $ymd = sprintf("%04d%02d%02d", $year, $month, $day);
	if ($w == 0){
	    $html .= " | \n";
	}
	if ($col->diarys->{$ymd}){
	    my $high = int($day/10);
            my $abc;
            if ($day < 11) {
                $abc = "a";
            }
            elsif ($day < 21) {
                $abc = "b";
            }
            else {
                $abc = "c";
            }
            if ($col->diarys->{$ymd}->read_done){
                $html .= $templ->Expand($DayCurrentTemplate,
                                {ruri=>$ENV{'REQUEST_URI'}, year=>$year,
                                 month=>$month, day=>$day, ymd=>$ymd});
            } else {
                $html .= $templ->Expand($DayNonCurrentTemplate,
                                {year=>$year, month=>$month, high=>$high,
                                 abc=>$abc, day=>$day, ymd=>$ymd});
            }
	    $html .= " ";
	} else {
	    $html .= " $day ";
	}
    }
    $html .= " | \n";
    $date -= '1M';
    $html .= $templ->Expand($PrevTemplate,
			    {year=>$date->year,
			     month=>sprintf("%02d", $date->month)});
    $date += '2M';
    $html .= " ";
    $html .= $templ->Expand($NextTemplate,
			    {year=>$date->year,
			     month=>sprintf("%02d", $date->month)});
    $html .= "<br>";
    return $html;
}
1;

