<?php

##
## Copyright (c) 1999 Guarneri Carmelo <carmelo@melting-soft.com>
##
## $Id: ct_dba.inc,v 1.1.2.2 2000/11/09 02:24:53 chuck Exp $
##
## PHPLIB Data Storage Container using DBM Files with Database abstraction layer functions
##
## Code inspired by ct_dbm.inc v 1.1 

class CT_Dba {
	##
	## Define these parameters by overwriting or by
	## deriving your own class from it (recommened)
	##

	var $dba_handler = "gdbm";    ## either dbm, gdbm, ndbm, cdb, db2
			       ## the handler must be compiled in php
				   
	var $dbm_file = "";    ## PREEXISTING DBM File 
			       ## writable by the web server UID

	## end of configuration
	
	var $dbaid;	       ## our dbm resource handle
	
	function ac_start() {
		# Open DBM file for write access
		$this->dbaid = @dba_open($this->dbm_file, "c", $this->dba_handler);
	}

	function ac_get_lock() {
		# Not needed in this instance
	}

	function ac_release_lock() {
		# Not needed in this instance
		dba_close($this->dbaid);
	}

	function ac_newid($str, $name) {
		return $str;
	}

	function ac_store($id, $name, $str) {
		dba_replace("$id$name", urlencode($str).";".time(), $this->dbaid);
		return true;
	}

	function ac_delete($id, $name) {
		dba_delete( "$id$name", $this->dbaid);
	}

	function ac_gc($gc_time, $name) {
		$cmp = time() - $gc_time * 60;
		$i = dba_firstkey($this->dbaid);
		while ($i) {
			$val = @dba_fetch( $i, $this->dbaid);
			$dat = explode(";", $val);
			if(strcmp($dat[1], $cmp) < 0) {
		      dba_delete( $i, $this->dbaid);
			}
			$i = dba_nextkey($this->dbaid);
		}
	}

	function ac_halt($s) {
		echo "<b>$s</b>";
		exit;
	}

	function ac_get_value($id, $name) {
		$dat = explode(";", dba_fetch( "$id$name", $this->dbaid));
		return urldecode($dat[0]);
	}
}
?>
