# $Horde: horde/scripts/database/mysql_alter.sql,v 1.1.2.1 2000/09/21 15:31:01 bjn Exp $
#
# This script can be used to update a Horde MySQL database from the format
# it had in Horde 1.2.0 (IMP 2.2.0) and previous, to the new format shipped
# with 1.2.2 (2.2.2) and later.  It alters the tables in-place.  No columns
# are added or removed; only the column types are changing, and indexes are
# being added, to improve efficiency.
#
# >>> NOTE <<< that due to the new primary keys, if there are rows with
# duplicate keys (such as two imp_addr rows with the same user+address)
# the first is kept and the rest are silently ignored!
#
# >>> BACK UP YOUR PRODUCTION DATABASE <<< before using this script; the
# mysqldump utility makes a good way to do this.
#
# You can simply direct this file to mysql as STDIN:
# $ mysql (user/pass/host args) < mysql_create.sql

CONNECT horde;

ALTER IGNORE TABLE imp_addr
  MODIFY user varchar(120) NOT NULL,
  MODIFY address varchar(120) NOT NULL,
  MODIFY nickname varchar(255),
  MODIFY fullname varchar(255),
  ADD PRIMARY KEY (user,address)
;

ALTER IGNORE TABLE imp_pref
  MODIFY user varchar(120) NOT NULL,
  MODIFY fullname varchar(70),
  MODIFY replyto varchar(70),
  ADD PRIMARY KEY (user)
;

# done!
