%{ /* make it look better in emacs: -*- mode: Makefile; -*- */
/* We need the Makefile mode in emacs to type \t (tab) characters */
/* 
 * We build a lexical analyzer that converts a Perl source file to 
 * a beautifully highlighted HTML file now.
 */

#include "colors.h"
#include "mymain.h"

%}
%s ONELINECOMMENT
%s STRING1
%s STRING2

id [a-zA-Z_][a-zA-Z01-9_]*
wsnl [\t \n]*
ws   [\t ]*
/* when to break parsing comments, strings, etc to handle special 
   characters: */
onelinecommentnospecial  [^&<>----\n]
string1nospecial         [^&<>----\\\n']
string2nospecial         [^&<>----\\\n$@%*"]
variable		 ((("$"*|"@"|"%"|"*")*){id}((("::"|"."){id})*))|("$"([]_./,\#*?[;!@:0$<>()%=-~^|&+1-9]))

%%
	/* This characters have to be recoded everywhere
	 * because the WWW-browsers interpret them in their
	 * own (here not wanted) way.
	 */
"&"	{ MyStringOutput (yyout, "&amp;"); }
"<"	{ MyStringOutput (yyout, "&lt;"); }
">"	{ MyStringOutput (yyout, "&gt;"); }
	/* All character as latin1 greater than dec192 or hexBF */
""	{ MyStringOutput (yyout, "&Agrave;"); }
""	{ MyStringOutput (yyout, "&Aacute;"); }
""	{ MyStringOutput (yyout, "&Acirc;"); }
""	{ MyStringOutput (yyout, "&Atilde;"); }
""	{ MyStringOutput (yyout, "&Auml;"); } 
""	{ MyStringOutput (yyout, "&Aring;"); }
""	{ MyStringOutput (yyout, "&AElig;"); }
""	{ MyStringOutput (yyout, "&Ccedil;"); }
""	{ MyStringOutput (yyout, "&Egrave;"); }
""	{ MyStringOutput (yyout, "&Eacute;"); }
""	{ MyStringOutput (yyout, "&Ecirc;"); } 
""	{ MyStringOutput (yyout, "&Euml;"); }  
""	{ MyStringOutput (yyout, "&Igrave;"); }
""	{ MyStringOutput (yyout, "&Iacute;"); }
""	{ MyStringOutput (yyout, "&Icirc;"); } 
""	{ MyStringOutput (yyout, "&Iuml;"); }  
	/* ""	{ MyStringOutput (yyout, "", yytext); } */
""	{ MyStringOutput (yyout, "&Ntilde;"); }
""	{ MyStringOutput (yyout, "&Ograve;"); }
""	{ MyStringOutput (yyout, "&Oacute;"); }
""	{ MyStringOutput (yyout, "&Ocirc;"); } 
""	{ MyStringOutput (yyout, "&Otilde;"); }
""	{ MyStringOutput (yyout, "&Ouml;"); }  
	/* ""	{ MyStringOutput (yyout, "", yytext); } */
""	{ MyStringOutput (yyout, "&Oslash;"); }
""	{ MyStringOutput (yyout, "&Ugrave;"); }
""	{ MyStringOutput (yyout, "&Uacute;"); }
""	{ MyStringOutput (yyout, "&Ucirc;"); } 
""	{ MyStringOutput (yyout, "&Uuml;"); }  
""	{ MyStringOutput (yyout, "&Yacute;"); }
""	{ MyStringOutput (yyout, "&THORN;"); }
""	{ MyStringOutput (yyout, "&szlig;"); }
""	{ MyStringOutput (yyout, "&agrave;"); }
""	{ MyStringOutput (yyout, "&aacute;"); }
""	{ MyStringOutput (yyout, "&acirc;"); } 
""	{ MyStringOutput (yyout, "&atilde;"); }  
""	{ MyStringOutput (yyout, "&auml;"); }
""	{ MyStringOutput (yyout, "&aring;"); }
""	{ MyStringOutput (yyout, "&aelig;"); }
""	{ MyStringOutput (yyout, "&ccedil;"); }
""	{ MyStringOutput (yyout, "&egrave;"); }
""	{ MyStringOutput (yyout, "&eacute;"); }
""	{ MyStringOutput (yyout, "&ecirc;"); } 
""	{ MyStringOutput (yyout, "&euml;"); }  
""	{ MyStringOutput (yyout, "&igrave;"); }
""	{ MyStringOutput (yyout, "&iacute;"); }
""	{ MyStringOutput (yyout, "&icirc;"); } 
""	{ MyStringOutput (yyout, "&iuml;"); }  
""	{ MyStringOutput (yyout, "&eth;"); }
""	{ MyStringOutput (yyout, "&ntilde;"); }
""	{ MyStringOutput (yyout, "&ograve;"); }
""	{ MyStringOutput (yyout, "&oacute;"); }
""	{ MyStringOutput (yyout, "&ocirc;"); } 
""	{ MyStringOutput (yyout, "&otilde;"); }  
""	{ MyStringOutput (yyout, "&ouml;"); }
	/* ""	{ MyStringOutput (yyout, "", yytext); } */
""	{ MyStringOutput (yyout, "&oslash;"); }
""	{ MyStringOutput (yyout, "&ugrave;"); }
""	{ MyStringOutput (yyout, "&uacute;"); }
""	{ MyStringOutput (yyout, "&ucirc;"); } 
""	{ MyStringOutput (yyout, "&uuml;"); }  
""	{ MyStringOutput (yyout, "&yacute;"); }
""	{ MyStringOutput (yyout, "&thorn;"); }
""	{ MyStringOutput (yyout, "&yuml;"); }

\\\"		{  MyStringOutput(yyout, yytext); }
\\\'		{  MyStringOutput(yyout, yytext); }
<STRING1>\'	{ 
		  MyStringOutput(yyout, yytext);
		  /* Close the string font */
		  BEGIN 0;
		  ChangeFontTo(yyout, NULL, NORMAL);
		}
<STRING1>\\\\	{ MyStringOutput(yyout, yytext); }
<STRING1>\\\n	{ MyStringOutput(yyout, yytext); }
<STRING1>\n	{ MyStringOutput(yyout, yytext); }
<STRING1>{string1nospecial}+	{ MyStringOutput(yyout, yytext); }

<STRING2>\\[^\"\n]	{ MyStringOutput(yyout, yytext); }
<STRING2>{variable}	{ 
		  ChangeFontTo(yyout, NULL, NORMAL); 
		  MyStringOutput(yyout, yytext); 
		  ChangeFontTo(yyout, definelinecolor, NORMAL);
		}
<STRING2>\"	{ 
		  MyStringOutput(yyout, yytext);
		  /* Close the string font */
		  BEGIN 0;
		  ChangeFontTo(yyout, NULL, NORMAL);
		}
<STRING2>\\\\	{ MyStringOutput(yyout, yytext); }
<STRING2>\\\n	{ MyStringOutput(yyout, yytext); }
<STRING2>\n	{ MyStringOutput(yyout, yytext); }
<STRING2>{string2nospecial}+	{ MyStringOutput(yyout, yytext); }

<ONELINECOMMENT>\n	{ 
		  ChangeFontTo(yyout, NULL, NORMAL);
		  MyStringOutput(yyout, yytext); 
		  BEGIN 0;
		}
<ONELINECOMMENT>{onelinecommentnospecial}+	{ 
		  MyStringOutput(yyout, yytext); 
		}

^"import"{ws}.*;	{
			  ChangeFontTo(yyout, definelinecolor, NORMAL);
			  MyStringOutput(yyout, yytext);
			  ChangeFontTo(yyout, NULL, NORMAL);
	}

\"	{
	  /* Start a string */
	  BEGIN STRING2;
	  ChangeFontTo(yyout, definelinecolor, NORMAL);
	  MyStringOutput(yyout, yytext);
	}
\'	{
	  /* Start a string */
	  BEGIN STRING1;
	  ChangeFontTo(yyout, definelinecolor, NORMAL);
	  MyStringOutput(yyout, yytext);
	}
^"#"{onelinecommentnospecial}*	{
	  BEGIN ONELINECOMMENT;
	  ChangeFontTo(yyout, commentcolor, NORMAL);	  
	  MyStringOutput(yyout, yytext);
	}
[\t ]+"#"{onelinecommentnospecial}*	{
	  BEGIN ONELINECOMMENT;
	  ChangeFontTo(yyout, commentcolor, NORMAL);	  
	  MyStringOutput(yyout, yytext);
	}
[{}]	{ MyStringOutput(yyout, yytext); }


^{ws}"sub"{ws}({id}{wsnl})"("([$@%;\\])*(";")?")"	{
		  ChangeFontTo(yyout, keywordcolor, BOLD);
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NORMAL);		  
		}		  
^{ws}"sub"{ws}({id}{wsnl})	{
		/*^{ws}"sub"{ws}({id}{wsnl}|"*")*"("({id}|{wsnl}|"\.\.\."|[][*(),])*")"	*/
		  ChangeFontTo(yyout, keywordcolor, BOLD);
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NORMAL);		  
		}		  

^("use"|"import"|"no"|"package"|"require")({id}|{wsnl}|[()])*";"	{
		  ChangeFontTo(yyout, keywordcolor, NORMAL);
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NORMAL);
		}		  
^{ws}{id}":"    {
		  ChangeFontTo(yyout, labelcolor, BOLD);
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NORMAL);
		}		  

^("bless"|"caller"|"close"|"continue"|"do"|"else"|"elsif"|"for"|"foreach"|"goto"|"if"|"last"|"local"|"my"|"next"|"open"|"pop"|"push"|"redo"|"return"|"tie"|"split"|"system"|"untie"|"until"|"unless"|"while")/[^a-zA-Z_0123456789] 	{ 
		  ChangeFontTo(yyout, keywordcolor, NORMAL);
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NORMAL);
		  /* highlight the rest of the reserved words */
		}
[\t ]+("bless"|"caller"|"close"|"continue"|"do"|"else"|"elsif"|"for"|"foreach"|"goto"|"if"|"last"|"local"|"my"|"next"|"open"|"pop"|"push"|"redo"|"return"|"tie"|"split"|"system"|"untie"|"until"|"unless"|"while")/[^a-zA-Z_0123456789] 	{ 
		  ChangeFontTo(yyout, keywordcolor, NORMAL);
		  MyStringOutput(yyout, yytext);
		  ChangeFontTo(yyout, NULL, NORMAL);
		  /* highlight the rest of the reserved words */
		}

[\t ]+		{ 
		  MyStringOutput(yyout, yytext);
		  /* let whitespaces like they are */
		}

[a-zA-Z_][a-zA-Z_0123456789]*	{
		  MyStringOutput(yyout, yytext);
		}

.		{ 
		  MyStringOutput(yyout, yytext);
		}
\n		{ 
		  MyStringOutput(yyout, yytext);
		}

%%

void StartNewYylex(FILE * in, FILE * out)
{
  BEGIN 0;
  yyin                 = in;
  yyout                = out;
  config.lineNumber    = 1;
  config.needLabel     = 1;
  config.currentColor  = NULL;
  config.currentWeight = NORMAL;

  yylex();
}

int
main(int argc, char *argv[])
{
  return MyMain(argc, argv);
  /* unreachable, but suppresses compiler warning. */
  yyunput(0, NULL);
}

