
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "ssiWizard_handlers.h"
#include "ssiWizard.h"

#include "editor.h"

const gchar *active_variable = "DATE_GMT";;
const gchar *active_exec = "cgi";
const gchar *active_size = "bytes";

void handle_var_menu (GtkWidget *menu, gpointer var) {
   gchar *tmp = (gchar *) var;
   active_variable = tmp;
}

void handle_exec_menu (GtkWidget *menu, gpointer exec) {
   gchar *tmp = (gchar *) exec;
   active_exec = tmp;
}

void handle_size_menu (GtkWidget *menu, gpointer size) {
   gchar *tmp = (gchar *) size;
   active_size = tmp;
}

void add_some_text (char *text)
{
   gint pos;
   extern GtkWidget *app;
   
   pos = screem_editor_get_pos();
   screem_editor_insert( pos, text );
   screem_editor_set_pos( pos + strlen( text ));
}

void
on_include_apply_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
   extern GtkWidget *include_path;
   gchar *tmp, *inc;
   
   tmp = gtk_entry_get_text(GTK_ENTRY(include_path));
   if ((tmp == NULL) || strlen(tmp) < 2)
     return;
   inc = malloc (90);
   sprintf (inc, "<!--#include virtual=\"%s\" -->", tmp);
   add_some_text(inc);
   free(inc);
}


void
on_info_apply_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   extern GtkWidget *entry8;
   extern GtkWidget *radiobutton3;
   extern GtkWidget *radiobutton4;
   gchar *tmp, *mode, *fname;
   
   fname = gtk_entry_get_text (GTK_ENTRY(entry8));
   if ((fname == NULL) || (strlen(fname) < 2))
     return;
   
   mode = (gchar *) malloc (9);
   if (GTK_TOGGLE_BUTTON(radiobutton4)->active) {
      /* time */
      strcpy (mode, "flastmod");
   } else {
      /* size */
      strcpy (mode, "fsize");
   }
   tmp = malloc (80);
   sprintf (tmp, "<!--#%s virtual=\"%s\" -->",
	    mode, fname);
   add_some_text(tmp);
   free (mode);
   free (tmp);
}


void
disable_var_widgets                    (void)
{
   extern GtkWidget *var_name, *var_name_label;
   extern GtkWidget *var_value, *var_value_label;
   
   gtk_widget_set_sensitive (GTK_WIDGET (var_name), FALSE);
   gtk_widget_set_sensitive (GTK_WIDGET (var_value), FALSE);
   gtk_widget_set_sensitive (GTK_WIDGET (var_name_label), FALSE);
   gtk_widget_set_sensitive (GTK_WIDGET (var_value_label), FALSE);

}


void
enable_var_widgets                     (GtkButton       *button,
                                        gpointer         user_data)
{
   extern GtkWidget *var_name, *var_name_label;
   extern GtkWidget *var_value, *var_value_label;
   
   gtk_widget_set_sensitive (GTK_WIDGET (var_name), TRUE);
   gtk_widget_set_sensitive (GTK_WIDGET (var_value), TRUE);
   gtk_widget_set_sensitive (GTK_WIDGET (var_name_label), TRUE);
   gtk_widget_set_sensitive (GTK_WIDGET (var_value_label), TRUE);

}


void
on_var_apply_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   extern GtkWidget *var_print, *var_name, *var_value;
   gchar *tmp1, *tmp2, *to_add;
   
   if (GTK_TOGGLE_BUTTON(var_print)->active) {
      add_some_text ("<!--#printenv -->");
      return;
   }
   tmp1 = gtk_entry_get_text(GTK_ENTRY(var_name));
   tmp2 = gtk_entry_get_text(GTK_ENTRY(var_value));
   to_add = malloc (strlen (tmp1) + strlen(tmp2) + 30);
   
   sprintf (to_add, "<!--#set var=\"%s\" value=\"%s\" -->",
	    tmp1, tmp2);
   add_some_text (to_add);
}


void
on_config_apply_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
   extern GtkWidget *config_error;
   extern GtkWidget *config_timefmt;
   extern GtkWidget *config_sizemenu;
   extern GtkWidget *config_sizemenu_menu;
   gchar *error_msg, *time_msg, *tmp;

   error_msg = gtk_entry_get_text(GTK_ENTRY (config_error));
   if (strlen(error_msg) < 2) {
      error_msg = "";
   }
   
   time_msg = gtk_entry_get_text(GTK_ENTRY (config_timefmt));
   if (strlen(time_msg) < 2) {
      time_msg = "";
   }
   tmp = (char *) malloc (500);
   sprintf (tmp, "<!--#config errmsg=\"%s\" sizefmt=\"%s\" timefmt=\"%s\" -->",
	    error_msg, active_size, time_msg);
   add_some_text (tmp);
   free (tmp);
}


void
on_exec_apply_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   extern GtkWidget *exec_command;
   gchar *tmp, *exe;
   
   tmp = gtk_entry_get_text(GTK_ENTRY(exec_command));
   if ((tmp == NULL) || strlen(tmp) < 2)
     return;
   exe = malloc (90);
   sprintf (exe, "<!--#exec %s=\"%s\" -->", active_exec, tmp);
   add_some_text(exe);
   free(exe);

}


void
on_echo_apply_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   gchar *tmp;
   
   tmp = malloc (60);
   sprintf (tmp, "<!--#echo var=\"%s\" -->", active_variable);
   add_some_text (tmp);
   free(tmp);
}


void
enable_test_expr                       (GtkButton       *button,
                                        gpointer         user_data)
{
   extern GtkWidget *cond_expr, *cond_label;
   
   gtk_widget_set_sensitive (GTK_WIDGET (cond_expr), TRUE);
   gtk_widget_set_sensitive (GTK_WIDGET (cond_label), TRUE);
}


void
disable_test_expr                      (GtkButton       *button,
                                        gpointer         user_data)
{
   extern GtkWidget *cond_expr, *cond_label;
   
   gtk_widget_set_sensitive (GTK_WIDGET (cond_expr), FALSE);
   gtk_widget_set_sensitive (GTK_WIDGET (cond_label), FALSE);

}


void
on_cond_apply_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   extern GtkWidget *radiobutton6; /* if */
   extern GtkWidget *radiobutton7; /* elif */
   extern GtkWidget *radiobutton8; /* else */
   extern GtkWidget *radiobutton9; /* endif */
   extern GtkWidget *cond_expr;
   gchar *new_text, *expr;
   
   if (GTK_TOGGLE_BUTTON(radiobutton9)->active) {
      add_some_text ("<!--#endif -->");
      return;
   } else if (GTK_TOGGLE_BUTTON(radiobutton8)->active) {
      add_some_text ("<!--#else -->");
      return;
   } else {
      if ((expr = gtk_entry_get_text(GTK_ENTRY (cond_expr)))) {
	 if (strlen(expr) <3)
	   return;
	 new_text = malloc (strlen(expr) + 20);
	 if (GTK_TOGGLE_BUTTON(radiobutton7)->active) {
	    sprintf (new_text, "<!--#elif expr=\"%s\" -->", expr);
	 } else if (GTK_TOGGLE_BUTTON(radiobutton6)->active) {
	    sprintf (new_text, "<!--#if expr=\"%s\" -->", expr);
	 }
	 add_some_text (new_text);
	 free (new_text);
      }
   }
}


void
on_ssi_help_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_close_ssi_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   extern GtkWidget *window1;
   gtk_widget_destroy (window1);
   window1 = NULL;
}

