/*  Screem:  interface.c,
 *  This file creates the main interface for the program.
 * 
 *  Copyright (C) 1999  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <config.h>
#include <gnome.h>
#include <gnome-xml/debugXML.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

#include "editor.h"
#include "interface.h"
#include "linkview.h"
#include "menus.h"
#include "pageUI.h"
#include "preferences.h"
#include "preview.h"
#include "siteTreeUI.h"
#include "siteUI.h"
#include "tag_tree.h"
#include "toolbar.h"

extern Preferences *cfg;

static void tab_switch( GtkNotebook *notebook, GtkNotebookPage *page,
			guint page_num );

GtkWidget* create_splash()
{
  GtkWidget *window1;
  GtkWidget *table1;
  GtkWidget *text1;

  GtkWidget *pixmap1;
  GtkWidget *pixmap2;
  GtkWidget *pixmap3;
  GtkWidget *pixmap4;

  GdkImlibImage *image;
  gchar *file;
  GdkPixmap *p;
  GdkBitmap *b;

  window1 = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_widget_ref (window1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "window1", window1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_window_set_title (GTK_WINDOW (window1), 
			_("SCREEM - Site CReating and Editing EnvironMent"));
  gtk_window_set_policy( GTK_WINDOW( window1 ), FALSE, FALSE, TRUE );

  table1 = gtk_table_new (3, 3, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (window1), table1);

  text1 = gtk_text_new (NULL, NULL);
  gtk_widget_ref (text1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "text1", text1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (text1);
  gtk_table_attach (GTK_TABLE (table1), text1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_widget_set_usize (text1, 233, 10);

  /* load images */
  file = SPLASH_DIR"1.png";
  image = gdk_imlib_load_image( file );
  gdk_imlib_render( image, image->rgb_width, image->rgb_height );
  p = gdk_imlib_move_image( image );
  b = gdk_imlib_move_mask( image );
  pixmap1 = gtk_pixmap_new( p, b );
  gtk_table_attach (GTK_TABLE (table1), pixmap1, 0, 1, 0, 3,
                    0, 0, 0, 0);
  gdk_imlib_destroy_image( image );

  file = SPLASH_DIR"2.png";
  image = gdk_imlib_load_image( file );
  gdk_imlib_render( image, image->rgb_width, image->rgb_height );
  p = gdk_imlib_move_image( image );
  b = gdk_imlib_move_mask( image );
  pixmap2 = gtk_pixmap_new( p, b );
  gtk_table_attach (GTK_TABLE (table1), pixmap2, 1, 3, 2, 3,
                    0, 0, 0, 0);
  gdk_imlib_destroy_image( image );

  file = SPLASH_DIR"3.png";
  image = gdk_imlib_load_image( file );
  gdk_imlib_render( image, image->rgb_width, image->rgb_height );
  p = gdk_imlib_move_image( image );
  b = gdk_imlib_move_mask( image );
  pixmap3 = gtk_pixmap_new( p, b );
  gtk_table_attach (GTK_TABLE (table1), pixmap3, 1, 3, 0, 1,
                    0, 0, 0, 0);
  gdk_imlib_destroy_image( image );

  file = SPLASH_DIR"4.png";
  image = gdk_imlib_load_image( file );
  gdk_imlib_render( image, image->rgb_width, image->rgb_height );
  p = gdk_imlib_move_image( image );
  b = gdk_imlib_move_mask( image );
  pixmap4 = gtk_pixmap_new( p, b );
  gtk_table_attach (GTK_TABLE (table1), pixmap4, 2, 3, 1, 2,
                    0, 0, 0, 0);
  gdk_imlib_destroy_image( image );

  return window1;
}

void create_about()
{
        static GtkWidget *about;

        static const gchar *authors[] = {
                "",
                "Main Author: David A. Knight (david@screem.org)",
                "Sitecopy Integration: Lee Mallabone (lee0@callnetuk.com)",
                "Sitecopy: Joe Orton (joe@orton.demon.co.uk)",
                NULL
        };

        static gchar *about_text =
                N_("Site CReation and Editing EnvironMent\nScreem provides an easy to use development environment for creating websites ");
        
        if( about ) {
                gdk_window_raise (about->window);
                gdk_window_show (about->window);
                return;
        }

        about = gnome_about_new( PACKAGE, VERSION,
                                 "(C) 1999 David A Knight",
                                 authors,
                                 about_text,
                                 NULL );
        gtk_signal_connect( GTK_OBJECT( about ), "destroy", 
                            GTK_SIGNAL_FUNC( gtk_widget_destroyed ), &about );
        gtk_widget_show( about );
}

GtkWidget* create_app( gboolean normal, gchar *appname, gchar *title )
{
	GtkWidget *app;
	GtkWidget *toolbar;
	GtkWidget *appbar;
	GtkWidget *workarea;
	GtkWidget *label;

	GtkWidget *left_pane = NULL;
	GtkWidget *tree_pane = NULL;

	GtkWidget *tag_window;
	GtkWidget *tag_tree;
	GtkWidget *window;

	GtkWidget *sitebook;
	GtkWidget *combo;
	GtkWidget *file_window;
	GtkWidget *tree;
	GtkWidget *list;

	GtkWidget *sw;
	GtkWidget *link_view;

	GtkWidget *design_view;

	GtkWidget *notebook = NULL;
	GtkWidget *editor;
	GtkWidget *preview;
	GtkWidget *box;
	GtkWidget *box2;

	/* create the app window */
	app = gnome_app_new( appname, title );
	gtk_window_set_policy( GTK_WINDOW( app ), TRUE, TRUE, FALSE);
        gnome_app_enable_layout_config( GNOME_APP( app ), TRUE );

	if( ! normal )
                gtk_signal_connect( GTK_OBJECT( app ), "delete_event",
                                    GTK_SIGNAL_FUNC( gtk_main_quit ), NULL );

	/* create/attach the menu/toolbars/statusbar */
	gnome_app_create_menus( GNOME_APP( app ), main_menu );

	toolbar = create_toolbar1();
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "toolbar1", GNOME_DOCK_ITEM_BEH_NORMAL,
			       GNOME_DOCK_TOP, 1, 1, 0 );

	toolbar = create_toolbar2();
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "toolbar2", GNOME_DOCK_ITEM_BEH_NORMAL,
			       GNOME_DOCK_TOP, 1, 2, 0 );

	toolbar = create_toolbar3();
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "toolbar3", GNOME_DOCK_ITEM_BEH_NORMAL,
			       GNOME_DOCK_TOP, 1, 3, 0 );

	toolbar = create_toolbar4();
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "toolbar4", GNOME_DOCK_ITEM_BEH_NORMAL,
			       GNOME_DOCK_TOP, 1, 4, 0 );

	/* a toolbar to put wizards on */
	toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
				   GTK_TOOLBAR_ICONS );
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "wizardbar", GNOME_DOCK_ITEM_BEH_NORMAL,
			       GNOME_DOCK_TOP, 2, 1, 0 );
	gtk_object_set_data( GTK_OBJECT( app ), "wizardbar", toolbar );

	toolbar = create_toolbar5();
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "toolbar5", GNOME_DOCK_ITEM_BEH_NORMAL,
			       GNOME_DOCK_TOP, 2, 2, 0 );

	toolbar = create_toolbar6();
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "toolbar6", GNOME_DOCK_ITEM_BEH_NORMAL,
			       GNOME_DOCK_TOP, 2, 3, 0 );

	toolbar = create_toolbar7();
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "toolbar7", 
			       GNOME_DOCK_ITEM_BEH_NORMAL,
			       GNOME_DOCK_TOP, 2, 4, 0 );

	appbar = gnome_appbar_new( FALSE, TRUE, GNOME_PREFERENCES_NEVER );
	gnome_app_set_statusbar( GNOME_APP( app ), appbar );
	gnome_app_install_menu_hints( GNOME_APP( app ), main_menu );

	workarea = gtk_vbox_new( FALSE, 0 );

	gnome_app_set_contents( GNOME_APP( app ), workarea );
	
	left_pane = gtk_hpaned_new();
	gtk_object_set_data( GTK_OBJECT(app), "left_pane", left_pane );
	gtk_container_add( GTK_CONTAINER( workarea ), left_pane );
	
	tree_pane = gtk_vpaned_new();
	gtk_object_set_data( GTK_OBJECT(app), "tree_pane", tree_pane );
	gtk_container_add( GTK_CONTAINER( left_pane ), tree_pane );
	
	/* create the html tag list window */
	tag_window = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( tag_window ),
                                        GTK_POLICY_AUTOMATIC, 
                                        GTK_POLICY_AUTOMATIC );
	gtk_object_set_data( GTK_OBJECT( app ), "tag_window", tag_window );
	gtk_widget_set_usize( tag_window, 
			      cfg->tag_width,
			      cfg->tag_height );
	/* now the tree itself */
	tag_tree = screem_tag_tree_build( cfg->tag_tree );
	gtk_object_set_data( GTK_OBJECT( app ), "tag_tree", tag_tree );
	gtk_container_add( GTK_CONTAINER( tag_window ), tag_tree );

	gtk_container_add( GTK_CONTAINER( tree_pane ), tag_window );

	/* create the site notebook */
	sitebook = gtk_notebook_new();
	gtk_object_set_data( GTK_OBJECT( app ), "sitebook", sitebook );
	GTK_WIDGET_UNSET_FLAGS( sitebook, GTK_CAN_FOCUS );
	gtk_notebook_set_tab_pos( GTK_NOTEBOOK( sitebook ), GTK_POS_BOTTOM );

	gtk_container_add( GTK_CONTAINER( tree_pane ), sitebook );

	/* add the file list to the notebook */
	box = gtk_vbox_new( FALSE, 0 );
	combo = gtk_combo_new();
	gtk_entry_set_editable( GTK_ENTRY( GTK_COMBO( combo )->entry ), FALSE);
	gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( combo )->entry ),
			    _( "No Site Loaded" ) );
	gtk_box_pack_start( GTK_BOX( box ), combo, FALSE, FALSE, 4 );
	gtk_object_set_data( GTK_OBJECT( app ), "sitecombo", combo );
	gtk_signal_connect( GTK_OBJECT( GTK_COMBO( combo )->entry ),
			    "changed",
			    GTK_SIGNAL_FUNC( screem_site_change ), NULL );

	file_window = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( file_window ),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC );
	gtk_box_pack_start( GTK_BOX( box ), file_window, TRUE, TRUE, 0 );
	label = gtk_label_new( _( "Site" ) );
	gtk_notebook_append_page( GTK_NOTEBOOK(sitebook), box, label );

	/* the tree */
	tree = gtk_ctree_new( 1, 0 );
	gtk_ctree_set_line_style( GTK_CTREE( tree ), GTK_CTREE_LINES_DOTTED );
        gtk_ctree_set_expander_style( GTK_CTREE( tree ),
				      GTK_CTREE_EXPANDER_SQUARE);
        gtk_clist_set_column_auto_resize( GTK_CLIST( tree ), 0, TRUE );
	gtk_clist_set_selection_mode( GTK_CLIST( tree ),GTK_SELECTION_BROWSE );
	gtk_signal_connect( GTK_OBJECT( tree ), "button_press_event",
        		    GTK_SIGNAL_FUNC( tree_clicked ), 0 );
	gtk_drag_source_set( tree, ( GDK_BUTTON1_MASK | GDK_BUTTON2_MASK ),
			     site_tree_drag_types, site_tree_num_drag_types,
			     ( GDK_ACTION_COPY | GDK_ACTION_MOVE | GDK_ACTION_ASK ) );
	gtk_drag_dest_set(tree, 
			  (GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP),
			  site_tree_drop_types, site_tree_num_drop_types,
			  (GDK_ACTION_COPY | GDK_ACTION_MOVE | GDK_ACTION_ASK)
			  );
	gtk_signal_connect( GTK_OBJECT( tree ), "drag_data_get",
			    GTK_SIGNAL_FUNC( tree_set_dnd_data ), 0 );
	gtk_signal_connect( GTK_OBJECT( tree ), "drag_begin",
			    GTK_SIGNAL_FUNC( tree_drag_begin ), 0 );
	gtk_signal_connect( GTK_OBJECT( tree ), "drag_motion",
			    GTK_SIGNAL_FUNC( tree_drag_motion ), 0 );
	gtk_signal_connect( GTK_OBJECT( tree ), "drag_data_received",
			    GTK_SIGNAL_FUNC( tree_drop_data ), 0 );
	GTK_WIDGET_UNSET_FLAGS( tree, GTK_CAN_FOCUS );

	gtk_container_add( GTK_CONTAINER( file_window ), tree );
	gtk_object_set_data( GTK_OBJECT( app ), "file_tree", tree );

	gtk_widget_set_usize( sitebook, cfg->file_width, cfg->file_height );

	/* add the browse tab to the sitebook */
	file_window = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( file_window ),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC );
	label = gtk_label_new( _( "Browse" ) );
	list = gtk_clist_new( 2 );
	GTK_WIDGET_UNSET_FLAGS( list, GTK_CAN_FOCUS );
	gtk_container_add( GTK_CONTAINER( file_window ), list );
	gtk_object_set_data( GTK_OBJECT( app ), "browse", list );
	gtk_clist_set_selection_mode( GTK_CLIST( list ),
                                      GTK_SELECTION_BROWSE );
        gtk_clist_column_titles_hide( GTK_CLIST( list ) );
	gtk_signal_connect( GTK_OBJECT( list ), "button_press_event",
			    GTK_SIGNAL_FUNC( browse_list_clicked ), NULL );
	gtk_drag_source_set( list, ( GDK_BUTTON1_MASK | GDK_BUTTON2_MASK ),
			     site_tree_drag_types, site_tree_num_drag_types,
			     ( GDK_ACTION_COPY | GDK_ACTION_MOVE | GDK_ACTION_ASK ) );
	gtk_drag_dest_set(list, 
			  (GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP),
			  site_tree_drop_types, site_tree_num_drop_types,
			  (GDK_ACTION_COPY | GDK_ACTION_MOVE | GDK_ACTION_ASK)
			  );
	gtk_signal_connect( GTK_OBJECT( list ), "drag_data_get",
			    GTK_SIGNAL_FUNC( tree_set_dnd_data ), 0 );
	gtk_signal_connect( GTK_OBJECT( list ), "drag_begin",
			    GTK_SIGNAL_FUNC( tree_drag_begin ), 0 );
	gtk_signal_connect( GTK_OBJECT( list ), "drag_motion",
			    GTK_SIGNAL_FUNC( tree_drag_motion ), 0 );
	gtk_signal_connect( GTK_OBJECT( list ), "drag_data_received",
			    GTK_SIGNAL_FUNC( tree_drop_data ), 0 );
	gtk_notebook_append_page( GTK_NOTEBOOK(sitebook), file_window, label );

	/* add the resources tab to the sitebook */
	tree = gtk_ctree_new( 1, 0 );
	gtk_ctree_set_line_style( GTK_CTREE( tree ), GTK_CTREE_LINES_DOTTED );
        gtk_ctree_set_expander_style( GTK_CTREE( tree ),
				      GTK_CTREE_EXPANDER_SQUARE);
        gtk_clist_set_column_auto_resize( GTK_CLIST( tree ), 0, TRUE );
	gtk_clist_set_selection_mode( GTK_CLIST( tree ),GTK_SELECTION_BROWSE );
	GTK_WIDGET_UNSET_FLAGS( tree, GTK_CAN_FOCUS );
	file_window = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( file_window ),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC );
	gtk_container_add( GTK_CONTAINER( file_window ), tree );
	gtk_object_set_data( GTK_OBJECT( app ), "resource_tree", tree );
	label = gtk_label_new( _( "Resources" ) );
	gtk_notebook_append_page( GTK_NOTEBOOK(sitebook), file_window, label );

	/* the editing notebook area */
	box = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( left_pane ), box );

	notebook = gtk_notebook_new();
	GTK_WIDGET_UNSET_FLAGS( notebook, GTK_CAN_FOCUS );
	gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), 
				  GTK_POS_TOP );
	gtk_object_set_data( GTK_OBJECT( app ), "notebook", notebook );
	gtk_box_pack_start( GTK_BOX( box ), notebook, TRUE, TRUE, 0 );

	/* the editor */
	editor = screem_editor_new();
	gtk_object_set_data( GTK_OBJECT( app ), "editor", 
			     gtk_object_get_data( GTK_OBJECT( editor ), 
						  "text_widget" ) );

	label = gtk_label_new( _( "Editor" ) );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), 
				  editor, label );

	/* the preview */
	preview = screem_preview_new();
	gtk_object_set_data( GTK_OBJECT( app ), "preview", preview );
	label = gtk_label_new( _( "Preview" ) );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), 
				  preview, label );
	gtk_widget_show_all( notebook );
	gtk_notebook_set_page( GTK_NOTEBOOK( notebook ), 1 );

	/* add the design tab canvas */
	sw = gtk_scrolled_window_new( NULL, NULL );
	design_view = gnome_canvas_new();
	gtk_widget_set_usize( sw, cfg->editor_width, 
			      cfg->editor_height );
	gtk_object_set_data( GTK_OBJECT( app ), "design_view", 
			     design_view );
	label = gtk_label_new( _( "Design" ) );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), 
				  sw, label );

	gtk_container_add( GTK_CONTAINER( sw ), design_view );
	gtk_object_set_data( GTK_OBJECT( design_view ), "window", sw );

	/* add the link view canvas */
	sw = gtk_scrolled_window_new( NULL, NULL );
	gtk_widget_push_visual(gdk_rgb_get_visual());
	gtk_widget_push_colormap(gdk_rgb_get_cmap());
	link_view = gnome_canvas_new();
	gtk_widget_pop_colormap();
	gtk_widget_pop_visual();
	gtk_widget_set_usize( sw, cfg->editor_width, 
			      cfg->editor_height );
	gtk_object_set_data( GTK_OBJECT( app ), "link_view", 
			     link_view );
	label = gtk_label_new( _( "Link View" ) );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), 
				  sw, label );

	gtk_container_add( GTK_CONTAINER( sw ), link_view );
	gtk_object_set_data( GTK_OBJECT( link_view ), "window", sw );

	gtk_signal_connect( GTK_OBJECT( notebook ), "switch_page",
			    GTK_SIGNAL_FUNC( tab_switch ), NULL );

	/* the editor status */
	box2 = gtk_hbox_new( FALSE, 0 );
	label = gtk_label_new( "L: 0 C: 0" );
	gtk_object_set_data( GTK_OBJECT( app ), "editor_status", label );
	gtk_box_pack_end( GTK_BOX( box2 ), label, FALSE, FALSE, 4 );

	/* the page notebook */
	notebook = gtk_notebook_new();
	gtk_notebook_set_scrollable( GTK_NOTEBOOK( notebook ), TRUE );
	gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), GTK_POS_TOP );
	gtk_notebook_set_show_border( GTK_NOTEBOOK( notebook ), FALSE );
	gtk_notebook_set_tab_border( GTK_NOTEBOOK( notebook ), 0 );
	GTK_WIDGET_UNSET_FLAGS( notebook, GTK_CAN_FOCUS );
	gtk_box_pack_start( GTK_BOX( box2 ), notebook, TRUE, TRUE, 0 );
	gtk_object_set_data( GTK_OBJECT( app ), "pagebook", notebook );
	gtk_signal_connect( GTK_OBJECT( notebook ), "switch_page",
			    GTK_SIGNAL_FUNC( page_book_switch ), NULL );

	
	gtk_box_pack_start( GTK_BOX( box ), box2, FALSE, FALSE, 0 );

	return app;
}

static void tab_switch( GtkNotebook *notebook, GtkNotebookPage *page,
			guint page_num )
{
	switch( page_num ) {
	case 3:
		screem_link_view_create();
		break;
	case 1:
		preview_current_page();
		break;
	default:
		break;

	}
}
