/* 
 *      XSitecopy, for managing remote web sites with a GNOME interface.
 *      Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com
 *                                                                        
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *     
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *     
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gnome.h>

#ifndef GNOME_FE_COMMON_H
#define GNOME_FE_COMMON_H

enum view_type { gtk_slim, gtk_full };

/* One day perhaps..... */
void switch_gtk_view (void);

/* making new sites.. */
int create_site (void); /* Prompts for local path and friendly name */

/*void fe_connected( );*/
/* For update mode */
bool fe_can_update( const struct site_file_t *file );
void fe_updating( const struct site_file_t *file );
void fe_updated(const struct site_file_t *file, const bool success,
		const char *error );
/* For synch mode */
void fe_synching( const struct site_file_t *file );
void fe_synched( const struct site_file_t *file, const bool success,
		const char *error);
/* For synch and update modes */
void fe_transfer_progress( size_t progress, size_t total );

/* For messages */
void fe_message( char *message );
void fe_status (char *message);
int fe_gtk_question (char *question, GnomeReplyCallback yes_action);
int verifysite_gnome(struct site_t *a_site);

#endif
