// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        mutexlock.C
// 
// Purpose:     
// 
// Created:     19 Nov 1996   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: mutexlock.C,v 1.1 1996/12/06 13:36:50 root Exp $
// 
// $Log: mutexlock.C,v $
// Revision 1.1  1996/12/06 13:36:50  root
// Initial revision
//
// 
// </file> 
#include "mutexlock.h"

#include "assert.h"

// --------------------------------------------------------------------
Verbose HWMutexLock :: verbose ;
const char* HWMutexLock :: version1 = "HWMutexLock: $Id: mutexlock.C,v 1.1 1996/12/06 13:36:50 root Exp $" ;

HWMutexLock :: HWMutexLock() {
#ifdef Solaris
   error_ = ::mutex_init (&mutex_, USYNC_THREAD, 0 /*ignored with USYNC_THREAD*/) ;   
   if (error_) {
      DEBUGNL ("HWMutexLock::HWMutexLock(): ::mutex_init() failed, error was: "<<error_) ;
   }
#else
   hgassert (false, "HWMutexLock::HWMutexLock(): mutexes are not supported on this system") ;
   error_ = 1 ;
#endif
}

HWMutexLock :: ~HWMutexLock() {
   if (! error_) {
#ifdef Solaris
      error_ = ::mutex_destroy (&mutex_) ;
#endif
   }
   if (error_) {
#ifdef Solaris
      DEBUGNL ("HWMutexLock::~HWMutexLock(): ::mutex_destroy() failed, error was: "<<error_) ;
#endif
   }      
}

void HWMutexLock :: lock() {
#ifdef Solaris
   if ((error_ = ::mutex_lock (&mutex_))) {
      DEBUGNL ("HWMutexLock::lock(): ::mutex_lock() failed, error was: "<<error_) ;
   }
#endif
}

void HWMutexLock :: unlock() {
#ifdef Solaris
   if ((error_ = ::mutex_unlock (&mutex_))) {
      DEBUGNL ("HWMutexLock::unlock(): ::mutex_unlock() failed, error was: "<<error_) ;
   }
#endif
}

// --------------------------------------------------------------------
HWMutexLock::Guard :: Guard (HWMutexLock& lock)
: lock_(lock) {
   lock_.lock() ;
}

HWMutexLock::Guard :: ~Guard() {
   lock_.unlock() ;
}
