# rpms.mak - Makefile targets to generate rpms automatically
# Copyright (C) 1999 suzuki toshiya
#
# Author: suzuki toshiya <suzukis@file.phys.tohoku.ac.jp>
#
# This is part of gtkDPS now. However these targets might be useful
# for other program.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# As a special exception to the GNU General Public License, if you
# distribute this file as part of a program that contains a
# configuration script generated by Autoconf, you may include it under
# the same distribution terms that you use for the rest of that program.
#
RPM=rpm
rpmrcs:
	RPM_ARCH=`${RPM} --showrc | sed -n 's#^build arch *: ##p'` ;\
	mkdir -p RPMS/$${RPM_ARCH} ;\
	mkdir -p SRPMS ;\
	mkdir -p BUILD ;\
	RPM_VER=`${RPM} --version | sed -n '$$s#^.* ##p'` ;\
	echo rpm version is $${RPM_VER} ;\
	case $${RPM_VER} in \
	  2\.5*) \
	    echo generate rcfile for RPM ver2.5 ;\
	    ( LANG=C ${RPM} --showrc | sed '1,/^RPMRC VALUES:/d' \
	      | fgrep -v '(not set)' \
	      | egrep -v '^(build|rpm|source|spec|srcrpm|top)dir' \
	      | sed "s# *:#:#g;\
	             s#optflags:#optflags: $${RPM_ARCH}#" ;\
	      echo builddir: `pwd`/BUILD ;\
	      echo sourcedir: `pwd` ;\
	      echo specdir: `pwd` ;\
	      echo srcrpmdir: `pwd`/SRPMS ;\
	      echo rpmdir: `pwd`/RPMS ) > rpmrc ;\
	    ;; \
	  3\.0*) \
	    echo generate rcfile for RPM ver3.0 ;\
	    LANG=C ${RPM} --showrc | sed '/==/,/==/d;1,/^RPMRC VALUES:/d' \
	      | sed "s# *:#:#g;\
	             s#^optflags:#optflags: $${RPM_ARCH}#;\
	             s#^macrofiles: .*#&:`pwd`/rpmmacros#" > rpmrc ;\
	    ( echo %_builddir `pwd`/BUILD ;\
	      echo %_sourcedir `pwd` ;\
	      echo %_specdir `pwd` ;\
	      echo %_srcrpmdir `pwd`/SRPMS ;\
	      echo %_rpmdir `pwd`/RPMS ) > rpmmacros ;\
	    ;; \
	  *) \
	    echo $${RPM_VER} is unknown version ;\
	esac

srpm: dist rpmrcs
	${RPM} --rcfile rpmrc -bs -vv ${PACKAGE}.spec

rpm: srpm
	${RPM} --rcfile rpmrc --rebuild -vv \
	  SRPMS/${PACKAGE}-${VERSION}-${run_config_date}.src.rpm
