/* ui.c - user interface creation only */

#include <gnome.h>

#include <netinet/in.h>

#include "napster.h"
#include "gnapster.h"
#include "ui.h"
#include "menus.h"
#include "callbacks.h"

extern GNAPSTER_MAIN gnapster_main;
extern SEARCH_TAB search_tab;
extern DOWNLOAD_TAB download_tab;
extern MOTD_TAB motd_tab;
extern CONSOLE_TAB console_tab;
extern CHAT_TAB chat_tab;
extern PROP_DLG prop_dlg;

extern USER_INFO user_info;

void create_gnapster_main() {
   gnapster_main.window = gnome_app_new("gnapster", _("Gnapster"));
   gtk_widget_set_usize(GTK_WIDGET(gnapster_main.window), 550, 300);
   gtk_window_set_wmclass(GTK_WINDOW(gnapster_main.window),
			  "gnapster", "Gnapster");
   
   gnome_app_create_menus(GNOME_APP(gnapster_main.window), gnapster_menu);
//   gnome_app_create_toolbar(GNOME_APP(gnapster_main.window), gnapster_toolbar);
   
   gtk_window_set_title(GTK_WINDOW(gnapster_main.window), "Gnapster");
   
   gtk_signal_connect(GTK_OBJECT(gnapster_main.window), "delete-event",
		      GTK_SIGNAL_FUNC(gnapster_exit_cb), NULL);
   
   gnapster_main.notebook = gtk_notebook_new();
   gtk_signal_connect(GTK_OBJECT(gnapster_main.notebook), "switch-page",
		      GTK_SIGNAL_FUNC(switch_page_cb), NULL);
   gnome_app_set_contents(GNOME_APP(gnapster_main.window), 
			  gnapster_main.notebook);
   
   gnapster_main.appbar = gnome_appbar_new(TRUE, TRUE, GNOME_PREFERENCES_NEVER);
   gnapster_main.progress = gnome_appbar_get_progress(GNOME_APPBAR(gnapster_main.appbar));
   gtk_progress_set_activity_mode(GTK_PROGRESS(gnapster_main.progress), TRUE);
   gtk_progress_set_value(GTK_PROGRESS(gnapster_main.progress), 0);
   gnome_app_set_statusbar(GNOME_APP(gnapster_main.window),
			   gnapster_main.appbar);
   
   gtk_container_border_width(GTK_CONTAINER(GNOME_APP(gnapster_main.window)->contents), 5);
}

void create_search_tab() {
   char *titles[] = { "Filename", "Connection", "User", "Size", "KBps", NULL };
   
   search_tab.vbox = gtk_vbox_new(FALSE, 5);

   search_tab.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(search_tab.vbox), search_tab.hbox,
		      FALSE, FALSE, 0);
   
   search_tab.label = gtk_label_new("Query: ");
   gtk_box_pack_start(GTK_BOX(search_tab.hbox), search_tab.label,
		      FALSE, FALSE, 0);
   
   search_tab.entry = gtk_entry_new();
   gtk_signal_connect(GTK_OBJECT(search_tab.entry), "activate",
		      GTK_SIGNAL_FUNC(search_activate_cb), NULL);
   gtk_box_pack_start(GTK_BOX(search_tab.hbox), search_tab.entry,
		      TRUE, TRUE, 0);
   
   search_tab.search_btn = gtk_button_new_with_label("Search");
   gtk_signal_connect(GTK_OBJECT(search_tab.search_btn), "clicked",
		      GTK_SIGNAL_FUNC(search_activate_cb), NULL);
   gtk_box_pack_start(GTK_BOX(search_tab.hbox), search_tab.search_btn,
		      FALSE, FALSE, 0);
   
   search_tab.list_btn = gtk_button_new_with_label("Browse user");
   gtk_signal_connect(GTK_OBJECT(search_tab.list_btn), "clicked",
		      GTK_SIGNAL_FUNC(browse_user_cb), NULL);
   gtk_box_pack_start(GTK_BOX(search_tab.hbox), search_tab.list_btn,
		      FALSE, FALSE, 0);
   
   search_tab.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(search_tab.vbox), search_tab.hbox,
		      TRUE, TRUE, 0);
   
   search_tab.scroller = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(search_tab.scroller),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
   gtk_box_pack_start(GTK_BOX(search_tab.hbox), search_tab.scroller,
		      TRUE, TRUE, 0);
   
   search_tab.clist = gtk_clist_new_with_titles(5, titles);
   gtk_clist_set_compare_func(GTK_CLIST(search_tab.clist),
			      (GtkCListCompareFunc)gnapster_clist_sort);
   gtk_clist_set_sort_column(GTK_CLIST(search_tab.clist), 1);
   gtk_clist_set_column_width(GTK_CLIST(search_tab.clist), 0, 250);
   gtk_clist_set_column_width(GTK_CLIST(search_tab.clist), 2, 75);
   gtk_clist_set_column_width(GTK_CLIST(search_tab.clist), 3, 50);
   gtk_container_add(GTK_CONTAINER(search_tab.scroller), search_tab.clist);
   gtk_signal_connect(GTK_OBJECT(search_tab.clist), "button_press_event",
		      GTK_SIGNAL_FUNC(menu_popup_cb), search_popup_menu);
   
   gtk_notebook_append_page(GTK_NOTEBOOK(gnapster_main.notebook),
			    search_tab.vbox, gtk_label_new("Search"));
}

void create_download_tab() {
   char *titles[] = { "Filename", "Connection", "User", "Size", "%", NULL };
   
   download_tab.vbox = gtk_vbox_new(FALSE, 5);
   
   download_tab.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(download_tab.vbox), download_tab.hbox,
		      TRUE, TRUE, 0);
   
   download_tab.scroller = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(download_tab.scroller),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
   gtk_box_pack_start(GTK_BOX(download_tab.hbox), download_tab.scroller,
		      TRUE, TRUE, 0);
   
   download_tab.clist = gtk_clist_new_with_titles(5, titles);
   gtk_clist_set_column_width(GTK_CLIST(download_tab.clist), 0, 250);
   gtk_clist_set_column_width(GTK_CLIST(download_tab.clist), 2, 75);
   gtk_clist_set_column_width(GTK_CLIST(download_tab.clist), 3, 50);
   gtk_container_add(GTK_CONTAINER(download_tab.scroller), download_tab.clist);
   gtk_signal_connect(GTK_OBJECT(download_tab.clist), "button_press_event",
		      GTK_SIGNAL_FUNC(menu_popup_cb), download_popup_menu);
   
   gtk_notebook_append_page(GTK_NOTEBOOK(gnapster_main.notebook),
			    download_tab.vbox, gtk_label_new("Download"));
}

void create_console_tab() {
   console_tab.vbox = gtk_vbox_new(FALSE, 5);
   
   console_tab.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(console_tab.vbox), console_tab.hbox,
		      TRUE, TRUE, 0);
   
   console_tab.scroller = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(console_tab.scroller),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
   gtk_box_pack_start(GTK_BOX(console_tab.hbox), console_tab.scroller,
		      TRUE, TRUE, 0);
   
   console_tab.text = gtk_text_new(NULL, NULL);
   gtk_text_set_point(GTK_TEXT(console_tab.text), 0);
   gtk_text_set_editable(GTK_TEXT(console_tab.text), FALSE);
   gtk_container_add(GTK_CONTAINER(console_tab.scroller), console_tab.text);
   
   console_tab.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(console_tab.vbox), console_tab.hbox,
		      FALSE, FALSE, 0);
   
   console_tab.entry = gtk_entry_new();
   gtk_signal_connect(GTK_OBJECT(console_tab.entry), "activate",
		      GTK_SIGNAL_FUNC(console_activate_cb), NULL);
   gtk_box_pack_start(GTK_BOX(console_tab.hbox), console_tab.entry,
		      TRUE, TRUE, 0);
   
   gtk_notebook_append_page(GTK_NOTEBOOK(gnapster_main.notebook), console_tab.vbox,
			    gtk_label_new("Console"));
}

void create_chat_tab() {
   char *titles[] = { "Username", NULL };
   
   chat_tab.vbox = gtk_vbox_new(FALSE, 5);

   chat_tab.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(chat_tab.vbox), chat_tab.hbox,
		      TRUE, TRUE, 0);
   
   chat_tab.scroller = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(chat_tab.scroller),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
   gtk_box_pack_start(GTK_BOX(chat_tab.hbox), chat_tab.scroller,
		      TRUE, TRUE, 0);
   
   chat_tab.text = gtk_text_new(NULL, NULL);
   gtk_text_set_point(GTK_TEXT(chat_tab.text), 0);
   gtk_text_set_editable(GTK_TEXT(chat_tab.text), FALSE);
   gtk_container_add(GTK_CONTAINER(chat_tab.scroller), chat_tab.text);
   
   chat_tab.scroller2 = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(chat_tab.scroller2),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
   gtk_box_pack_start(GTK_BOX(chat_tab.hbox), chat_tab.scroller2,
		      FALSE, FALSE, 0);
   
   chat_tab.clist = gtk_clist_new_with_titles(1, titles);
   gtk_widget_set_usize(GTK_WIDGET(chat_tab.clist), 100, -1);
   gtk_container_add(GTK_CONTAINER(chat_tab.scroller2), chat_tab.clist);

   chat_tab.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(chat_tab.vbox), chat_tab.hbox,
		      FALSE, FALSE, 0);
   
   chat_tab.entry = gtk_entry_new();
   gtk_signal_connect(GTK_OBJECT(chat_tab.entry), "activate",
		      GTK_SIGNAL_FUNC(chat_activate_cb), NULL);
   gtk_box_pack_start(GTK_BOX(chat_tab.hbox), chat_tab.entry,
		      TRUE, TRUE, 0);
   
   gtk_notebook_append_page(GTK_NOTEBOOK(gnapster_main.notebook), chat_tab.vbox,
			    gtk_label_new("Chat"));
}

void create_motd_tab() {
   motd_tab.vbox = gtk_vbox_new(FALSE, 5);
   
   motd_tab.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(motd_tab.vbox), motd_tab.hbox,
		      TRUE, TRUE, 0);
   
   motd_tab.scroller = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(motd_tab.scroller),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
   gtk_box_pack_start(GTK_BOX(motd_tab.hbox), motd_tab.scroller,
		      TRUE, TRUE, 0);
   
   motd_tab.text = gtk_text_new(NULL, NULL);
   gtk_text_set_point(GTK_TEXT(motd_tab.text), 0);
   gtk_text_set_editable(GTK_TEXT(motd_tab.text), FALSE);
   gtk_container_add(GTK_CONTAINER(motd_tab.scroller), motd_tab.text);
   
   gtk_notebook_append_page(GTK_NOTEBOOK(gnapster_main.notebook), motd_tab.vbox,
			    gtk_label_new("Message of the Day"));
}

void create_prop_dlg(void *changed_cb, void *button_cb, void *destroy_cb,
		     void *clicked_cb, int *new_user_val) {
   char *user, *pass, *download_dir;
   int conn, name_fix;
   
   user = gnome_config_get_string("/gnapster/User/user");
   pass = gnome_config_get_string("/gnapster/User/pass");
   download_dir = gnome_config_get_string("/gnapster/User/dl_dir");
   conn = gnome_config_get_int("/gnapster/User/connection");
   name_fix = gnome_config_get_int("/gnapster/User/name_fix");
   
   prop_dlg.window = gnome_property_box_new();
   gtk_window_set_title(GTK_WINDOW(prop_dlg.window),
			_("Gnapster Properties"));
   
   prop_dlg.vbox = gtk_vbox_new(FALSE, 5);
   
   prop_dlg.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(prop_dlg.vbox), prop_dlg.hbox,
		      FALSE, FALSE, 0);
   
   prop_dlg.label = gtk_label_new("Username: ");
   gtk_box_pack_start(GTK_BOX(prop_dlg.hbox), prop_dlg.label,
		      FALSE, FALSE, 0);
   
   prop_dlg.user_entry = gtk_entry_new();
   if (user) gtk_entry_set_text(GTK_ENTRY(prop_dlg.user_entry), user);
   gtk_signal_connect(GTK_OBJECT(prop_dlg.user_entry), "changed",
		      GTK_SIGNAL_FUNC(changed_cb), NULL);
   gtk_box_pack_start(GTK_BOX(prop_dlg.hbox), prop_dlg.user_entry,
		      FALSE, FALSE, 0);
   
   prop_dlg.new_user = gtk_check_button_new_with_label("New Account");
   gtk_signal_connect(GTK_OBJECT(prop_dlg.new_user), "clicked",
		      GTK_SIGNAL_FUNC(clicked_cb), new_user_val);
/*   gtk_signal_connect(GTK_OBJECT(prop_dlg.new_user), "changed",
		      GTK_SIGNAL_FUNC(changed_cb), NULL);*/
   gtk_box_pack_start(GTK_BOX(prop_dlg.hbox), prop_dlg.new_user,
		      FALSE, FALSE, 0);

   prop_dlg.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(prop_dlg.vbox), prop_dlg.hbox,
		      FALSE, FALSE, 0);
   
   prop_dlg.label = gtk_label_new("Password: ");
   gtk_box_pack_start(GTK_BOX(prop_dlg.hbox), prop_dlg.label,
		      FALSE, FALSE, 0);
   
   prop_dlg.pass_entry = gtk_entry_new();
   gtk_entry_set_visibility(GTK_ENTRY(prop_dlg.pass_entry), FALSE);
   if (pass) gtk_entry_set_text(GTK_ENTRY(prop_dlg.pass_entry), pass);
   gtk_signal_connect(GTK_OBJECT(prop_dlg.pass_entry), "changed",
		      GTK_SIGNAL_FUNC(changed_cb), NULL);
   gtk_box_pack_start(GTK_BOX(prop_dlg.hbox), prop_dlg.pass_entry,
		      FALSE, FALSE, 0);

   prop_dlg.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(prop_dlg.vbox), prop_dlg.hbox,
		      FALSE, FALSE, 0);
  
   prop_dlg.label = gtk_label_new("Download Directory: ");
   gtk_box_pack_start(GTK_BOX(prop_dlg.hbox), prop_dlg.label,
		      FALSE, FALSE, 0);
   
   prop_dlg.download_dir = gnome_file_entry_new(NULL, "Browse Download Directory");
   if (download_dir) gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(prop_dlg.download_dir))), download_dir);
   gtk_signal_connect(GTK_OBJECT(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(prop_dlg.download_dir))),
		      "changed", GTK_SIGNAL_FUNC(changed_cb), NULL);
   gtk_box_pack_start(GTK_BOX(prop_dlg.hbox), prop_dlg.download_dir,
		      TRUE, TRUE, 0);
   
   prop_dlg.hbox = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(prop_dlg.vbox), prop_dlg.hbox,
		      FALSE, FALSE, 0);
   
   prop_dlg.name_fix = gtk_check_button_new_with_label("Convert spaces to underscores?");
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_dlg.name_fix), name_fix);
   gtk_signal_connect(GTK_OBJECT(prop_dlg.name_fix), "clicked",
		      GTK_SIGNAL_FUNC(clicked_cb), &(user_info.name_fix));
   gtk_box_pack_start(GTK_BOX(prop_dlg.hbox), prop_dlg.name_fix,
		      FALSE, FALSE, 0);
   
/*   prop_dlg.label = gtk_label_new("Connection: ");
   gtk_box_pack_start(GTK_BOX(prop_dlg.hbox), prop_dlg.label,
		      FALSE, FALSE, 0);
   
   prop_dlg.conn_combo = gtk_combo_new();
   gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(prop_dlg.conn_combo)->entry),
			  FALSE);
   while(conn_table[i]) {
      conn_combo_attr = g_list_append(conn_combo_attr, conn_table[i]);
      i++;
   }
   gtk_combo_set_popdown_strings(GTK_COMBO(prop_dlg.conn_combo),
				 conn_combo_attr);
   gtk_signal_connect(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(prop_dlg.conn_combo)->entry)),
		      "changed", GTK_SIGNAL_FUNC(changed_cb), NULL);
   gtk_box_pack_start(GTK_BOX(prop_dlg.hbox), prop_dlg.conn_combo,
		      FALSE, FALSE, 0);*/
   
   gtk_container_border_width(GTK_CONTAINER(prop_dlg.vbox), 5);
   
   gnome_property_box_append_page(GNOME_PROPERTY_BOX(prop_dlg.window),
				  prop_dlg.vbox, 
				  gtk_label_new(_("User Information")));

   gtk_signal_connect(GTK_OBJECT(prop_dlg.window), "apply",
		      GTK_SIGNAL_FUNC(button_cb), "apply");
   gtk_signal_connect(GTK_OBJECT(prop_dlg.window), "destroy",
		      GTK_SIGNAL_FUNC(destroy_cb), "destroy");
}
