/* flags.h */
/*
  gtkfind - a graphical "find" program
  Copyright (C) 1999  Matthew Grossman <mattg@oz.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* the enum flag_t stuff, used to set flags instead of a bunch of global
   variables */

#ifndef FLAG_H
#define FLAG_H

enum flag_t { REGEXP_P = 0, SEARCH_SUBDIRS_P, SHELL_COMMAND_P,
	      PRINT_TO_STDOUT_P, PRINT_TO_WINDOW_P, PRINT_FILENAME_ANYWAY_P,
	      OWNER_READ_P, GROUP_READ_P, WORLD_READ_P, OWNER_WRITE_P,
	      GROUP_WRITE_P, WORLD_WRITE_P, OWNER_EXEC_P, GROUP_EXEC_P,
	      WORLD_EXEC_P, SETUID_P, SETGID_P, STICKY_P, DIRECTORY_P,
	      REGULAR_P, RAW_DEVICE_P, BLOCK_DEVICE_P, SYMLINK_P, SOCKET_P,
	      FIFO_P, UID_NOT_LOGIN_P, GID_NOT_GROUP_P, ATIME_ET_P,
	      ATIME_EQ_P, ATIME_LT_P, MTIME_ET_P, MTIME_EQ_P, MTIME_LT_P,
	      CTIME_ET_P, CTIME_EQ_P, CTIME_LT_P, WARNING_WINDOW_P,
	      LONG_OUTPUT_P, WILDCARD_CONTENTS_SEARCH_P,
	      WILDCARD_FILENAME_MATCH_P};



int set_flag(enum flag_t f, int value);
int get_flag(enum flag_t f);
int reset_flags();


#endif /* !FLAG_H */
